/*
          Program: Timer.c
      Modified by: Christopher A. Zielinski       (416) 767-9674
             Date: 93-07-22

          Purpose: MSC 5.10 C code to support clock in Clipper.
          Compile: CL /c /AL /FPa /Gs /Gh TICKERC.C

              DISPLAY CLOCK
                  CZ_Clock( <nForEveryXSec>, <nRow>, <nCol> ) -> NIL

              REMOVE CLOCK
                  CZ_Clock() -> NIL

*/

#include "extend.h"
#include <conio.h>
#include <dos.h>
#include <time.h>

#define INT_TICKS       0x08  // IBM Hardware IRQ0 (timer tick) vector
#define TICKS_PER_SEC 	18.2	// Number of times ISR is called per second

void ( _cdecl _interrupt _far *old_int )( void );
void _cdecl _interrupt _far ISR_Routine( void );
char _far *_getindosAddress( void );

char _far *indos = 0;   // Initialized with NULL pointer!
int Ticks = 0;
int TickerCount = 0;
int tHooked = 0;
unsigned char nAtRow;
unsigned char nAtCol;

union REGS ir, or;


CLIPPER CZ_Clock()
{
  if (PCOUNT == 3 && ISNUM( 1 ) && ISNUM( 2 ) && ISNUM( 3 )) {
    if ( ( Ticks = _parni( 1 ) * TICKS_PER_SEC ) != 0 ) { // If TickValue != 0 Setup Timer
      TickerCount = Ticks;

      nAtRow = _parni( 2 );
      nAtCol = _parni( 3 );

			if (! tHooked) {
				if	( ! indos ) // If indos is a NULL pointer
					indos = _getindosAddress(); // Get indos's address (pointer)

				old_int = (void _far *) _dos_getvect( INT_TICKS ); // Get current ISR
				_disable(); // Don't allow calls until ISR is fully installed.
				_dos_setvect( INT_TICKS, (void (_cdecl _interrupt _far *)(void)) ISR_Routine );  // Set to my ISR
				_enable();	// Re-enable ISR's
				tHooked = 1;
			}
		}
	}
  else {
    if (old_int != NULL) {
      _disable();  // Don't allow calls until ISR is fully installed
      // Set ISR back, a MUST before terminating the program!!!
      _dos_setvect( INT_TICKS, (void (_cdecl _interrupt _far *)(void)) old_int );
      _enable();  // Re-enable ISR's
      old_int = NULL;
			tHooked = 0;
    }
  }
  _ret();
}


void _cdecl _interrupt _far ISR_Routine()
{
  unsigned char page, row, col, curStart, curEnd;
  char timebuf[9];

  if ( ++TickerCount >= Ticks ) {  // Has the appropriate time passed
    if (! *indos) {
      /*
      InDOS is a flag used by DOS itself.  When DOS enters an Int 21h function
      DOS increments the InDOS flag; when DOS leaves, it decrements the flag.
      This flag is required because the operating system kernal is not fully
      reentrant!  This means that if an interrupt occurs while the operating
      system is already inside the kernel, the service routine cannot use
      Int 21h functions for processing because a call to a function might
      conflict with the previous call.  In this case, you could easily
      crash the system, but not necessarily in any way that could be traced
      directly to the interrupt handler.

      Some times this flag can be misleading, but better safe than sorry.

      BTW:  Don't forget...  DS:DX --> Segment:Offset
                             regs.x.dx = FP_OFF() // Offset (far pointer)
                              sregs.ds = FP_SEG() // Segment (far pointer)
      */

      _disable();  // Don't allow calls to other ISR's until ISR is finished

      // Get active page number
      ir.h.ah = 0x0F;
      int86( 0x10, &ir, &or );
      page = or.h.bh;

      // Get current row, column, and cursor type
      ir.h.ah = 0x03;
      ir.h.bh = page;
      int86( 0x10, &ir, &or );
      row = or.h.dh;
      col = or.h.dl;
      curStart = or.h.ch;
      curEnd = or.h.cl;

      // Turn cursor off
      ir.h.ah = 0x01;
      ir.x.cx = 0x2000;
      int86( 0x10, &ir, &or );

      // Position cursor to print time
      ir.h.ah = 0x02;
      ir.h.bh = page;
      ir.h.dh = nAtRow;
      ir.h.dl = nAtCol;
      int86( 0x10, &ir, &or );

      cputs( _strtime( timebuf ) );

      // Put cursor back
      ir.h.ah = 0x02;
      ir.h.bh = page;
      ir.h.dh = row;
      ir.h.dl = col;
      int86( 0x10, &ir, &or );

      // Return cursor to the way it was
      ir.h.ah = 0x01;
      ir.h.ch = curStart;
      ir.h.cl = curEnd;
      int86( 0x10, &ir, &or );

      TickerCount = 0;  // Reset Ticker Timer
      _enable();  // Re-enable ISR's
    }
  }
  _chain_intr( old_int ); // Execute old handler
}


char _far *_getindosAddress( void )
{
  union REGS in, out;
  struct SREGS sregs;

  in.h.ah = 0x34;
  segread( &sregs );
  intdosx( &in, &out, &sregs );

  /*
  Int 21h Function 34h -- Return address of InDOS Flag

  Calling Registers:  AH      34h
   Return Registers:  ES:BX   Pointer to InDOS Flag
  */

  return( (char _far *)( ((unsigned long)(sregs.es)<<16) | (unsigned long)(out.x.bx) ) );
}


