/*
    Program: TestTime.prg
    Purpose: To test & illustrate the use of CZ_Clock ISR.
    93.12.17
    CAZ

    WARNING:  CZ_Clock is an ISR!
              As with any ISR (Interrupt Service Request), it is the
              responsibility of the programmer to ensure the ISR is
              removed before returning control to the operating system!
              Failure to do so will cause the machine to CRASH.
              As well, CZ_Clock MUST REMAIN IN THE ROOT portion of the
              executable and NOT OVERLAID.

    CLIPPER TestTime
    RTLINK FI TestTime LIB Timer
    TestTime

*/

LOCAL bDefErr := ErrorBlock()  // An example of how to deal with an Quit on ERROR
ErrorBlock( { | oErr | CZ_Clock(), EVAL( bDefErr, oErr ), StartClock( ClockStats() ) } )

StartClock( { 1, 5, 5 } )

Dummy := 3/0  // Divide by zero error!

Inkey( 0 )    // Display current time every second and wait for a key
CZ_Clock()  // Remove ISR
QUIT      // Return control to operating system


PROCEDURE StartClock( aDetails )
    ClockStats( aDetails )  // Save clock details
    CZ_Clock( aDetails[1], aDetails[2], aDetails[3] )    // Install clock
RETURN


FUNCTION ClockStats( aDetails )
    STATIC aContainer := { 1, 1, 1 }
    IF aDetails != NIL
        aContainer := aDetails
    END
RETURN( aContainer )


