*Date: 10/15/91
*TIMEDBF.PRG     Mark Schiltz    72760,642
*
*Cheap and Dirty Software
*
*This was wipped up today in Summer '87
*Yes, it could be a lot cleaner but for something that might be used once or
*twice, why bother.   
*
*Creates a database file with time values for use in:
*   look-ups, validations, and calculations.
*
*Will create either:
*               TIME.DBF   or   CTIME.DBF
*   Records:    86,000          1,440
*   Size:       2,073,731       34,691
*
*TIME.DBF  contains a record for every second in the day.
*CTIME.DBF contains a record for only even minutes.
*
*File Structure:
*   TIME->STR_TIME    Ex. 02:01:42PM
*   TIME->MIL_TIME    Ex. 14:01:42
*   TIME->SECONDS     Ex. 50502
*
*For anyone who has made it this far:
*
*I would like to find other Clipper users in the Quad City Area.
*That is, Davenport,IA/Bettendorf,IA/Rock Island,IL/Moline,IL
*Any help would be appreciated.
*************
SET SCOREBOARD OFF
CLEAR
hour = 0
minute = 0
second = 0
totseconds = 0
compressed = .t.
yn = 'N'
@ 23,2 SAY 'Build compressed database file (database will contain only even minutes)' GET compressed PICTURE "Y"
@ 24,2 SAY '  Standard File 86,400 records 2MEG, Compressed File 1440 records 35K'
READ
CLEAROW(23)
@ 23,2 SAY 'Ready To Create File (Y/N)?' GET yn PICTURE "Y"
READ
CLEAROW(23)
CLEAROW(24)
IF UPPER(yn) = 'N'
    RETURN
ENDIF
IF compressed
    IF FILE('ctime.dbf')
        @ 23,2 SAY 'File exists, replace(Y/N)?' GET yn PICTURE "Y"
    ENDIF
ELSEIF !compressed
    IF FILE('time.dbf')
        @ 23,2 SAY 'File exists, replace(Y/N)?' GET yn PICTURE "Y"
    ENDIF
ENDIF
READ
CLEAROW(23)
IF UPPER(yn) = "N"
    RETURN
ENDIF
SET CURSOR OFF
CREATE temp
USE temp
APPEND BLANK
REPLACE temp->field_name WITH 'MIL_TIME'
REPLACE temp->field_type WITH 'C'
REPLACE temp->field_len WITH 8
APPEND BLANK
REPLACE temp->field_name WITH 'STR_TIME'
REPLACE temp->field_type WITH 'C'
REPLACE temp->field_len WITH 10
APPEND BLANK
REPLACE temp->field_name WITH 'SECONDS'
REPLACE temp->field_type WITH 'N'
REPLACE temp->field_len WITH 5
USE
IF compressed
    CREATE ctime FROM temp
    USE ctime
ELSE
    CREATE time FROM temp
    USE time
ENDIF
RUN del temp.dbf
FOR hour = 0 to 23
    FOR minute = 0 to 59
        FOR second = 0 to 59
            IF hour < 10
                milhour = '0'+SUBSTR(STR(hour,2),2,1)
            ELSE
                milhour = STR(hour,2)
            ENDIF
            IF minute < 10
                milminute = '0'+SUBSTR(STR(minute,2),2,1)
            ELSE
                milminute = STR(minute,2)
            ENDIF
            IF second < 10
                milsecond = '0'+SUBSTR(STR(second,2),2,1)
            ELSE
                milsecond = STR(second,2)
            ENDIF
            IF hour < 12
                ext = 'AM'
            ELSE
                ext = 'PM'
            ENDIF
            DO CASE
                CASE milhour = '00'
                    strhour = '12'
                CASE milhour = '13'
                    strhour = '01'            
                CASE milhour = '14'
                    strhour = '02'            
                CASE milhour = '15'
                    strhour = '03'            
                CASE milhour = '16'
                    strhour = '04'            
                CASE milhour = '17'
                    strhour = '05'            
                CASE milhour = '18'
                    strhour = '06'            
                CASE milhour = '19'
                    strhour = '07'            
                CASE milhour = '20'
                    strhour = '08'            
                CASE milhour = '21'
                    strhour = '09'            
                CASE milhour = '22'
                    strhour = '10'            
                CASE milhour = '23'
                    strhour = '11'            
                OTHERWISE
                    strhour=milhour
            ENDCASE
            miltime=milhour+':'+milminute+':'+milsecond
            strtime=strhour+':'+milminute+':'+milsecond+ext
            IF !compressed
                APPEND BLANK
                REPLACE str_time WITH strtime
                REPLACE mil_time WITH miltime
                REPLACE seconds WITH totseconds
                @ 16,2 SAY 'Building TIME.DBF. Record Number: '+STR(RECNO(),5)+'/86400'
                @ 18,2 SAY 'Field MIL_TIME: '+miltime
                @ 19,2 SAY 'Field STR_TIME: '+strtime
                @ 20,2 SAY 'Field SECONDS : '+LTRIM(STR(totseconds))
            ELSEIF compressed .and. second = 0
                APPEND BLANK
                REPLACE str_time WITH strtime
                REPLACE mil_time WITH miltime
                REPLACE seconds WITH totseconds
                @ 16,2 SAY 'Building CTIME.DBF. Record Number: '+STR(RECNO(),4)+'/1440'
                @ 18,2 SAY 'Field MIL_TIME: '+miltime
                @ 19,2 SAY 'Field STR_TIME: '+strtime
                @ 20,2 SAY 'Field SECONDS : '+LTRIM(STR(totseconds))
            ENDIF
            totseconds = totseconds+1
        NEXT
    NEXT
NEXT
SET CURSOR ON
CLOSE ALL

FUNCTION CLEAROW
PARAMETERS mrow
@ mrow,0 SAY SPACE(80)
RETURN ''
