/*******************************************************************************
* Program Id: ticker.c
*    Version: 1.00
********************************************************************************
*
*    Purpose: Returns the number of clock ticks from boot time to the present
*
*      Notes: Could be used for many things, including a seed for random number
*             generation
*
********************************************************************************
* Date     Name Description
*
* 06/05/89 jfk  Original program
********************************************************************************/
#include <nandef.h>
#include <extend.h>

/* address of system timer */
#define TIMER  0x046C

/**********************
*  ticker( [<divisor>] )
*
*  returns the number of clock ticks since bootup time.
*  if <divisor> is passed, MODs it by the value passed.
*
**********************/
CLIPPER ticker( void )
{
   if ( PCOUNT > 0 && ISNUM(1) )
   {
      _retnl( *( (long *) TIMER ) % _parnl(1) );
   }
   else
      _retnl( *( (long *) TIMER ) );
}
