*:*********************************************************************
*:
*: Procedure file: MENUPROC.PRG
*:
*:         System: THE.LIB sample menu functions
*:         Author: Roy H. Jennings, Jr.
*:      Copyright (c) 1989, Executive Programming Service
*:  Last modified: 06/12/89     22:42
*:
*:  Procs & Fncts: EDITMENU()
*:               : ADDMENU()
*:               : TESTPD
*:
*:      Documented 06/12/89 at 23:49                SNAP!  version 3.12e
*:*********************************************************************
*           starting choice is passed to all functions
*

*!*********************************************************************
*!
*!       Function: EDITMENU()
*!
*!       Bar Menu Example
*!
*!       Syntax:  action = EditMenu(action)
*!*********************************************************************
FUNCTION Editmenu
* --- standard edit menu returns first letter of selected option
*     Esc mapped to Quit
PARAMETER Mpos
PRIVATE Bar_row, Choice
DECLARE Baropt[6],Barmsg[6],Barcol[6]
IF UnDef('Mpos')
   Choice = 1
ELSE
   Choice = AT(Mpos,'NPFEDR')
   Choice = IIF(Choice = 0,1,Choice)
ENDIF
* --- arrays for edit menu
Bar_row = 23                             && row for the menu
Baropt[1] = 'Next'                       && options for the bar
Baropt[2] = 'Previous'
Baropt[3] = 'Find'
Baropt[4] = 'Edit'
Baropt[5] = 'Delete'
Baropt[6] = 'Return'
Barmsg[1] = 'Go to the next record'      && messages for the options
Barmsg[2] = 'Go to the previous record'
Barmsg[3] = 'Find a record'
Barmsg[4] = 'Edit this record'
Barmsg[5] = 'Delete this record'
Barmsg[6] = 'Leave this screen'
Barcol[1] = 12                           && columns for options
Barcol[2] = 22                           && to make it look nice,
Barcol[3] = 32                           && not required.
Barcol[4] = 42
Barcol[5] = 52
Barcol[6] = 62
@ Bar_row,0 CLEAR
Choice = MenuBar(Bar_row,Baropt,Barcol,Choice,Barmsg,Bar_row+1)
@ Bar_row,0 CLEAR
RETURN( SUBSTR('RNPFEDR',Choice + 1,1) )


*!*********************************************************************
*!
*!       Function: ADDMENU()
*!
*!       Implemented here as a Box Menu but better as a Bar Menu
*!
*!       Syntax:  action = Addmenu(action)
*!*********************************************************************
FUNCTION Addmenu
* --- standard menu for appending records
PARAMETER Mpos
DECLARE Finopt[2], Finmsg[2]
PRIVATE Choice, Mrow, Mcol
IF UnDef('Mpos')
   Choice = 1
ELSE
   Choice = AT(Mpos,'AF')
   Choice = IIF(Choice = 0,1,Choice)
ENDIF
Mrow = 12                   && top row of box
Mcol = 33                   && top right corner
Finopt[1] = 'Add another'                  && menu options
Finopt[2] = 'Finished'
Finmsg[1] = 'Add another record'           && option messages
Finmsg[2] = 'Leave this screen'
Choice = MenuBox(Mrow,Mcol,Finopt,Choice,Finmsg,24)
RETURN( SUBSTR('FAF',Choice+1,1) )


*!*********************************************************************
*!
*!       Procedure: TESTPD
*!
*!       Syntax:  DO TESTPD
*!*********************************************************************

clear
declare bar[3]                 && elements on the bar
DECLARE items[13]              && items that go with the bar elements
declare msgs[13]               && one message for each item (optional)
declare bcnt[3]                && numeric array that stores the number
*                              && of items associated with each bar element

private mchoice,ichoice, dummy

bcnt[1] = 5            && option 1 has 5 items in its box
bcnt[2] = 3            && option 2 has 3 items
bcnt[3] = 5            && option 3 has 5 items

bar[1] = 'One'
bar[2] = 'Two'
bar[3] = 'Three'

items[1] = 'One'
items[2] = 'Two'
items[3] = 'Three'
items[4] = 'Four'
items[5] = 'Five'

items[6] = 'One'
items[7] = 'Two'
items[8] = 'Three'

items[9] = 'One'
items[10] = 'Two'
items[11] = 'Three'
items[12] = 'Four'
items[13] = 'Five'

msgs[1] = 'Item One in box One'
msgs[2] = 'Item Two in box One'
msgs[3] = 'Item Three in box One'
msgs[4] = 'Item Four in box One'
msgs[5] = 'Item Five in box One'

msgs[6] = 'Item One in box Two'
msgs[7] = 'Item Two in box Two'
msgs[8] = 'Item Three in box Two'

msgs[9] = 'Item One in box Three'
msgs[10] = 'Item Two in box Three'
msgs[11] = 'Item Three in box Three'
msgs[12] = 'Item Four in box Three'
msgs[13] = 'Item Five in box Three'

mchoice = 1          && start with option 1 on the top bar
ichoice = 0          && don't pull down the item box

* --- run the menu until user presses escape

do  while .t.
    * --- mchoice and ichoice MUST be passed by reference using
    *     the @ operator
    *
    * --- note: although the function does return a value in 'dummy'
    *     its only useful for checking for a value caused by
    *     an unexpected return such as one caused by invalid
    *     parameters
    *
    dummy = menupd(1,@mchoice,@ichoice,bar,bcnt,items,msgs,0)

    * --- normally you would have a case structure here
    *     similar to this
*    do case
*       case mchoice = 1       && bar option 1
*            do case
*               case ichoice = 1     && selected item in pd box
*               case ichoice = 2
*               case ichoice = 3
*               * --- etc.
*            endcase
*       case mchoice = 2       && bar option 2
*       case mchoice = 3
*    endcase


    * --- the following code is here simply to show you the
    *     return values from MENUPD()  and to allow you
    *     to see how the boxes react to selected items
    *
    if mchoice = 0
       @ 14,15 clear to 15,79
       exit
    endif

    @ 14,15 clear to 15,79
    @ 14,15 say 'Mchoice = ' + ltrim(str(mchoice))
    @ 15,15 say 'Ichoice = ' + ltrim(str(ichoice))
    inkey(0)
    @ 2,0 clear
enddo .t.
return


*: EOF: MENUPROC.PRG
