/*
	This file contains two functions to be used for checking
	the correctness of numbers based on an 11 test.

	This kind of tests on numbers is often used for bank account
	numbers, social security numbers etc.
	
	The least significant digit of numbers is used as 'control digit'.
	The value of this control digit is such that when the sum of all
	digits multiplied with their rank is divided by 11, the remainder is 0.

	Example:
		Determine if the number 32567 is a correct number

		rank      5  4  3  2  1
		digit     3  2  5  6  7
		*        15  8 15 12  7
		The sum is 15+8+15+12=57
		The remainder of 55%11 is 2 so 32567 is not a correct number.
		(the correct control digit for 3256 is 5 ==> 32565)

	There are two functions in this file, the first test_11, will test
	if the given number is correct according to the afore mentioned 11
	test. The second function has as purpose to calculate the next number
	that satisfies the 11 test.


	R.P. Aarnts
	Schweitzerstraat 7
	2131 RA HOOFDDORP
	The Netherlands
	+31 30 2503 21435
*/
		*****************
		***  test_11  ***
		*****************
function test_11(N)
	/*
		Check if the number N is a correct number according to the 11 test
	*/
	
	local	sum	:= 0
	local	i

	for i=1 to 9
		sum := sum+(int((N%10**i)/10**(i-1)))*i
	next
	if (sum%11!=0)
		return .F.
	end if

return .T.

		**********************
		***  next_test_11  ***
		**********************
function next_test_11(nLast)
	/*
		Generate the next satisfying 11 test number.
		If nLast is NIL, the first number, which is 19, will be returned
	*/
	local	x
	if nLast = NIL
		return 19
	else
		x	:= nLast+1
		while !test_11(x)
			x++
		end while
	end if
return x
