* <<TESTCOPY.prg program initialization routine>>
* Date Written  : 12/28/89 jdb
* Date Modified :
* Designed by   : jeff bryant
* Coded by      : jeff bryant
* Called From   : DOS

* Notes:
* here is a routine that will allow you to add a certain level of
* copy protection to programs.  The basic idea is that the function INIT()
* calls upon clipper's low level file handling functions to actually change
* the return value of LEGIT() in the TESTCOPY.EXE file.
* When the program is run the first time the return value of LEGIT() is
* changed from '_jdb_' to '     ', within the exe.  Thereafter each time the
* program is run the return value of LEGIT is '     '.  Based on this you can
* then inform the user that they have an unauthorized copy of the program.

* This routines usefulness is limited, I grant.  It does give you an idea
* about the power of clipper's low level file functions.

* Credit needs to be given to Dave Benson from Second Story Computing,
* it was from his seminar at DevCon that this idea was born.


********************************************************************************
CLEAR

IF .NOT. EMPTY(LEGIT())                     && check to see if function has been altered
  INIT('TESTCOPY.EXE',LEGIT())              && init will change function legit
  @ 10,10 SAY 'TESTCOPY INITIALIZED'        && if it has not been...
 ELSE
  @ 10,10 SAY 'Unauthorized copy of TESTCOPY.exe, system halted'  && if it has been...
ENDIF
@ 11,10 SAY 'press any key'
INKEY(0)
RETURN



**************
FUNCTION LEGIT                              && actual function that gets changed
**************
RETURN('_jdb_')


*************
FUNCTION INIT
*************
PARAMETERS Mexe, Mstr
Mhandle  = FOPEN(Mexe,2)                    && name of the file to 'protect'
Mbuffer  = SPACE(4096)                      && buffer to hold bytes
Mstart   = FSEEK(Mhandle,0,0)               && starting byte to read
Mspace   = SPACE(LEN(Mstr))                 && blank string the length of replacement
Mlspace  = LEN(Mstr)+1                      && length of replacement string
Minitloop= .T.                              && loop variable

DO WHILE Minitloop
  Minitloop = .F.                           && assume we will break out of loop
  Mread     = FREAD(Mhandle,@Mbuffer,4096)  && fill the buffer
  Mpos      = AT(Mstr,Mbuffer)              && check for our string

  DO CASE
    CASE Mpos > 0                           && if the string is located in this chunk
      FSEEK(Mhandle,(Mstart+Mpos)-1,0)      && go to the character immediately preceeding the string
      FWRITE(Mhandle,Mspace)                && write the new string to the file
      FCLOSE(Mhandle)                       && close the file

    CASE Mread < 4096                       && if we've reached the end of the file
      FCLOSE(Mhandle)                       && close the file

    OTHERWISE
      Mstart   = FSEEK(Mhandle,-Mlspace,1)  && reset the pointer
      Mbuffer  = SPACE(4096)                && clean out the contents of Mbuffer
      Minitloop= .T.                        && continue the loop

  ENDCASE

ENDDO
RETURN(.T.)

*change log
* 19:35:37 12/28/89 created. jdb
*
*end of file testcopy
