/* **********************************************************************
   *** Telephone Number Converter...................by Pete Ticali    ***
   *** (C)opyright 1991 Peter J. Ticali, Tele-Net Computer Services   ***
   ***                                                                ***
   ***  PARAMETERS:  cPhoneNumber                                     ***
   ***                   character string of original phone number    ***
   ***  RETURNS:     cOutPhone                                        ***
   ***                   character string of new numeric type of      ***
   ***                              phone number                      ***
   ***  Recmended use:                                                ***
   ***  @ row,col Get cPhone PICTURE "(NNN) NNN-NNNN" VALID;          ***
   ***        IF(((cPhone:=TelePhoneNumber(cPhone))<>Nil),.t.,.f.)    ***
   ********************************************************************** */
Function TelePhoneNumber(cPhoneNumber)
LOCAL cOutPhone,chr,Error
Error:=.F.
cOutPhone:=""
For Counter := 1 to LEN(cPhoneNumber)
    chr:=UPPER(SUBSTR(cPhoneNumber,counter,1))
    DO CASE
       CASE chr="(" .OR. chr=")" .OR. chr=" " .OR. chr='-'
             cOutPhone:=cOutPhone+chr
       CASE chr>="0" .AND. chr<="9"
             cOutPhone:=cOutPhone+chr
       CASE (Chr>="A" .AND. Chr<="C")
              cOutPhone:=cOutPhone+"2"
       CASE (chr>="D" .AND. chr<="F")
              cOutPhone:=cOutPhone+"3"
       CASE (chr>="G" .AND. chr<="I")
               cOutPhone:=cOutPhone+"4"
       CASE (chr>="J" .AND. chr<="L")
              cOutPhone:=cOutPhone+"5"
       CASE (chr>="M" .AND. chr<="O")
              cOutPhone:=cOutPhone+"6"
       CASE (chr>="P" .AND. chr<="S")
              cOutPhone:=cOutPhone+"7"
       CASE (chr>="T" .AND. chr<="V")
              cOutPhone:=cOutPhone+"8"
       CASE (chr>="W" .AND. chr<="Y")
              cOutPhone:=cOutPhone+"9"
       OTHERWISE
             ERROR:=.T.
             EXIT
    ENDCASE
NEXT
If Error
   cOutPhone:=NIL
ENDIF
RETURN cOutPhone
