//  Virtuell screen emulation in windows
//  with CA Clipper Tools II

#define nVirtRow   203
#define nUpRow       4
#define cUpArrow   CHR(24)
#define cDownArrow CHR(25)

LOCAL InVar[nVirtRow]
LOCAL   getList   := {}
LOCAL nCol    := MAXCOL() +1
LOCAL   i

PUBLIC  nTrueRow  := MAXROW()

WMODE(.T.,.F.,.F.,.F.)
WSTEP(10, 3)

SCROLL()
@1,0 SAY CENTER("Use <Scroll Lock> and " +cUpArrow +cDownArrow)
FOR i =0 TO nTrueRow
   @ i, 1        SAY STR(i, 3)
   @ i, nCol -12 SAY i
NEXT
SHOWTIME(1, 62)

SETMAXROW(nVirtRow -1)
WBOX(12)
WBOARD( nUpRow  , 10, nVirtRow -1, nCol -11)
DispBox(nUpRow-1,  9, nVirtRow   , nCol -10)
SETCLEARB(176)
SCROLL( nUpRow  , 10, nTrueRow   , nCol -11)
WOPEN ( nUpRow  , 10, nVirtRow -1, nCol -11, .T.)

FOR i =1 TO MAXROW() STEP 2
   InVar[i]    :=i
   InVar[i +1] :=i +1
   @i, 2 SAY "Var_" +NTOC(i,    10, 3, "0") GET InVar[i]
   @i,40 SAY "Var_" +NTOC(i +1, 10, 3, "0") GET InVar[i +1]
NEXT i

SETPOS(0, 0)
TRAPINPUT("WTRACK")
READ

*****************************************

PROCEDURE WTRACK
 DO CASE
 CASE WROW() +ROW() >= nTrueRow
   WMOVE((nTrueRow -1) -ROW(), WCOL())
 CASE WROW() +ROW() <= nUpRow
   WMOVE((nUpRow   +1) -ROW(), WCOL())
 ENDCASE
RETURN

*****************************************


* eof wintrack.prg