// CA Clipper Tools II
//
// Growing boxes demonstration


#include "BOX.CH"

LOCAL i

DrawBoxes('Normal',0)
DrawBoxes('No Delay',1)
DrawBoxes('3 ms Delay',3)
DrawBoxes('5 ms Delay',5)
DrawBoxes('10 ms Delay',10)
DrawBoxes('20 ms Delay',20)

FillScreen()

SETBOXGROW(20)

@ 0,0, MAXROW(), MAXCOL() BOX SPACE(9)

INKEY(0)

FillScreen()

CLEARSLOW(20,0,0,MAXROW(),MAXCOL())




FUNC DrawBoxes(cText,nDelay)
  LOCAL nFak :=MAXROW()/MAXCOL()
  LOCAL nCRow:=INT(MAXROW()/2)
  LOCAL nCCol:=INT(MAXCOL()/2)
  LOCAL nStep:=INT(MAXCOL()/8)

  CLS

  @ 0,0 SAY CENTER(cText)

  SETBOXGROW(nDelay)

  FOR i= INT(MAXCOL()/2/nStep) TO 1 STEP -1

    @  nCRow-nStep*nFak*i,nCCol-nStep*i, ;
       nCRow+nStep*nFak*i,nCCol+nStep*i BOX B_DOUBLE+' '


  NEXT i

  INKEY(0)

RETURN(NIL)



FUNCTION FillScreen

  FOR i=0 TO MAXROW()-1

    @ i,0 SAY REPLICATE('@',MAXCOL())

  NEXT i

  INKEY(0)

RETURN(NIL)