/***
*   LPACK.h
*
*   DEFINEs and EXTERNs for interfacing with Clipper from C.
*
*   Large model C only (double word pointers to code and data)
*
*   Copyright (c) Nantucket Corporation 1987
*
*   Note: This is a modified version of EXTEND.H and NANDEF.H.
*         This is ONLY an example of how EXTEND.H and NANDEF.H
*         could be modified and is not supplied as a replacement,
*         due to possible copyright restrictions.  Note that
*         Nantucket still holds the copyright, even though
*         they didn't make the mods.
*
*/


/* Clipper func/proc function in C */
   #define CLIPPER      void pascal

/* Clipper Data types in c */
   typedef char *CL_c ;       /* CL_c     string                    */
   typedef int CL_csiz ;      /* CL_csiz  string siz                */
   typedef int CL_clen ;      /* CL_clen  string len                */
   typedef int CL_ni ;        /* CL_ni    numeric integer           */
   typedef long CL_nl ;       /* CL_nl    numeric long              */
   typedef double CL_nd ;     /* CL_nd    numeric double            */
   typedef int CL_l ;         /* CL_l     logical                   */
   typedef char *CL_ds ;      /* CL_ds    date string   YYYYMMDD    */
   typedef unsigned char *CL_mptr ;
                              /* CL_mptr  memory ptr                */
   typedef unsigned CL_msiz ; /* CL_msiz  memory size (in bytes)    */
   typedef int CL_par ;       /* CL_par   parameter (order or count */
   typedef int CL_ai ;        /* CL_ai    array index               */

/* _parinfo types */
   #define UNDEF        0
   #define CHARACTER    1
   #define NUMERIC      2
   #define LOGICAL      4
   #define DATE         8
   #define ALIAS       16
   #define MPTR        32      /* or'ed with type when passed by reference */
   #define MEMO        65
   #define WORD       128
   #define ARRAY      512

/* parameter count/type */
   extern CL_par _parinfo(CL_par) ;
   extern CL_par _parinfa(CL_par, CL_ai) ;

/* Clipper-parameter functions */
   extern CL_c    _parc(CL_par, ...) ;
   extern CL_csiz _parcsiz(CL_par, ...) ;
   extern CL_clen _parclen(CL_par, ...) ;
   extern CL_ni   _parni(CL_par, ...) ;
   extern CL_nl   _parnl(CL_par, ...) ;
   extern CL_nd   _parnd(CL_par, ...) ;
   extern CL_l    _parl(CL_par, ...) ;
   extern CL_ds   _pards(CL_par, ...) ;

/* Clipper-function return values */
   extern void _retc(CL_c) ;
   extern void _retclen(CL_c, CL_clen) ;
   extern void _retni(CL_ni) ;
   extern void _retnl(CL_nl) ;
   extern void _retnd(CL_nd) ;
   extern void _retl(CL_l) ;
   extern void _retds(CL_ds) ;

/* Clipper procedure return */
   extern void _ret(void);

/* Clipper memory allocation */
   extern CL_mptr _exmgrab(CL_msiz) ; /* size is in bytes */
   extern void _exmback(CL_mptr, CL_msiz);

/* misc */
/*   extern CL_clen strlen(CL_c) ;  */

/* parameter check macros */
   #define PCOUNT      (_parinfo(0))
   #define ISCHAR(n)   (_parinfo(n) & CHARACTER)
   #define ISNUM(n)   (_parinfo(n) & NUMERIC)
   #define ISLOG(n)   (_parinfo(n) & LOGICAL)
   #define ISDATE(n)   (_parinfo(n) & DATE)
   #define ISMEMO(n)   (_parinfo(n) & MEMO)
   #define ISBYREF(n)   (_parinfo(n) & MPTR)
   #define ISARRAY(n)   (_parinfo(n) & ARRAY)
   #define ALENGTH(n)   (_parinfa(n, 0))

/* Nantucket defines (in nandef.h) */
   #define FALSE   0
   #define TRUE   1

   #define NIL      '\0'
   #undef  NULL
   #define NULL   0L

/* Header structure */
   typedef unsigned char byte;
   typedef unsigned int quant;
   typedef int Boolean;


/*   extern DBF_HEADER *_dbfhead();  */
   extern int _dbfopen();

