/**********************************************************
* File ODOMETER.PRG
* 
* Odometer (status bar) functions
* 
* Compile with: /n/w
**********************************************************/

STATIC cScreen
STATIC cColor
STATIC nRecCount

/**********************************************************/

FUNCTION OdomInit (cMsg1, cMsg2)

   // Save the environment
   cScreen   := SAVESCREEN (09, 13, 16, 66)
   cColor    := SETCOLOR ("W+/GR")
   nRecCount := LASTREC ()

   // Pop up the status box
   @ 09, 13, 16, 66 BOX "ͻȺ "

   // If there are any messages, display them
   IF VALTYPE (cMsg1) == "C"
      @ 10, 15 SAY PADC (cMsg1, 50)
   ENDIF
   IF VALTYPE (cMsg2) == "C"
      @ 11, 15 SAY PADC (cMsg2, 50)
   ENDIF

   // Display an empty status bar
   @ 13, 15 SAY REPLICATE ("", 50)
   @ 15, 35 SAY "0% Complete"

   RETURN (NIL)

/**********************************************************/

FUNCTION Odometer ()

   // Calculate percentage and bar size
   LOCAL nPct := RECNO () / nRecCount * 100
   LOCAL nBar := INT ((nPct + .5) / 2)

   @ 15, 33 SAY nPct PICTURE "999"

   IF nBar > 0
      @ 13, 15 SAY REPLICATE ("", nBar)
   ENDIF

   // Return null string for cases when called directly
   // as part of a code block
   RETURN ""


   // Note: If using the Conditional DBFNTX driver, replace
   // the 'RETURN ""' above with a 'RETURN (.T.)'.
   //
   // This is due to the fact that the EVAL clause expects a 
   // logical value and HALTS THE INDEXING if a false (.F.) 
   // is returned.

/**********************************************************/

FUNCTION OdomEnd ()

   // Force a 100% and full status bar
   @ 15, 33 SAY "100"
   @ 13, 15 SAY REPLICATE ("", 50)

   // Pause long enough for the updated status to be seen
   INKEY (.5)

   // Restore the previous environment
   RESTSCREEN (09, 13, 16, 66, cScreen)
   SETCOLOR (cColor)

   // Clear the space used by the STATICs
   cScreen   := NIL
   cColor    := NIL
   nRecCount := 0

   RETURN (NIL)

// EOF ODOMETER.PRG
