/*******************************************************
*
* Key "filter" functions - Ideal for TBrowsing
*
* In all functions below, the arguments are:
*
*    cKey     The key field from the Parent DBF
*    bKey     A code block that evaluates to the
*             key field in the CHILD database
*
* Compile with /n/w
*
/******************************************************/

FUNCTION NextKey (cKey)
   LOCAL nKeyLen := LEN (cKey)
   RETURN SUBSTR (cKey, 1, (nKeyLen - 1)) + ;
            CHR (ASC (SUBSTR (cKey, nKeyLen, 1)) + 1)

/******************************************************/

FUNCTION KeyTop (cKey, bExp)

   // Seek "softly" since key passed may be partial
   DBSEEK (cKey, .T.)

   IF EVAL (bExp) != cKey
      GOTO 0   // Force a BOF
   ENDIF

   RETURN (.T.)

/******************************************************/

FUNCTION KeyBottom (cKey, bExp)

   // Seek "softly" since key passed may be partial
   DBSEEK (NextKey (cKey), .T.)

   SKIP -1

   IF EVAL (bExp) != cKey
      GOTO 0   // Force an EOF
   ENDIF

   RETURN (.T.)

/******************************************************/

FUNCTION KeySkip (nSkip, cKey, bExp)
   LOCAL nActual := 0
   LOCAL nMetCond := RECNO ()

   IF nSkip > 0
      DO WHILE nActual < nSkip .AND. (! EOF ()) .AND.;
            EVAL (bExp) == cKey
         SKIP 1
         IF (! EOF ()) .AND. EVAL (bExp) == cKey
            nActual ++
         ENDIF
      ENDDO
      IF nActual != nSkip
         SKIP -1
      ENDIF
   ELSEIF nSkip < 0
      DO WHILE nActual > nSkip .AND. (! BOF ()) .AND.;
            EVAL (bExp) == cKey
         SKIP -1
         IF (! BOF ()) .AND. EVAL (bExp) == cKey
            nActual --
         ENDIF
      ENDDO
      IF nActual != nSkip
         SKIP 1
      ENDIF
   ELSE
      SKIP 0
   ENDIF

   RETURN (nActual)

// EOF Filters.PRG
