
#include 'Directry.ch'

// Structure for a linked-list node
#define LINKED_LIST_NODE			2   // Length of structure
#define DATA_VALUE				1
#define NEXT_NODE					2
#define NULL						NIL

#define ELEMENT					1

#translate malloc(<x>)	=> ARRAY(<x>)
#command REPEAT       	=> DO WHILE .T.
#command UNTIL <x>    	=> IF <x> ; EXIT; END; END


FUNCTION TestLinkList
	LOCAL aFilesList, aDirectory, i
	CLEAR SCREEN

	aDirectory := DIRECTORY("*.*")

	// Loop to build the linked list
	FOR i = 1 to LEN(aDirectory)
		LinkListAdd(@aFilesList, aDirectory[i])
	NEXT i

	// Display contents of linked lists
	LinkListDisplay(aFilesList)
	RETURN (NIL)


FUNCTION LinkListDisplay(aHeadOfList)
	LOCAL aCurNode := aHeadOfList

	IF aCurNode <> NIL
		REPEAT
		? PAD(aCurNode[DATA_VALUE, F_NAME], 13),;
			aCurNode[DATA_VALUE, F_SIZE],;
			aCurNode[DATA_VALUE, F_DATE],;
			aCurNode[DATA_VALUE, F_TIME],;
			aCurNode[DATA_VALUE, F_ATTR]
		UNTIL (aCurNode := aCurNode[NEXT_NODE]) == NULL
	ENDIF
	RETURN (NIL)


FUNCTION LinkListAdd(aHeadOfList, aElementToAdd)
	LOCAL aPreviousNode, aCurNode, aNewNode

	IF .NOT. VALTYPE(aElementToAdd) == "A"
		aElementToAdd := {aElementToAdd}
	ENDIF

	aCurNode := aHeadOfList
	aNewNode := CreateNode(aElementToAdd)

	IF aCurNode == NIL
		aHeadOfList := aNewNode
	ELSE
		DO WHILE .T.
			IF aNewNode[DATA_VALUE, ELEMENT] > ;
				aCurNode[DATA_VALUE, ELEMENT]
				IF aCurNode[NEXT_NODE] <> NULL
					aPreviousNode := aCurNode
					aCurNode := aCurNode[NEXT_NODE]
				ELSE
					aCurNode[NEXT_NODE] := aNewNode
					EXIT
				ENDIF
			ELSE
				aNewNode[NEXT_NODE] := aCurNode
				IF aCurNode == aHeadOfList
					aHeadOfList := aNewNode
				ELSE
					aPreviousNode[NEXT_NODE] := aNewNode
				ENDIF
				EXIT
			ENDIF
		ENDDO
	ENDIF
	RETURN (NIL)


STATIC FUNCTION CreateNode(xDataValue)
	LOCAL aNodePtr := malloc(LINKED_LIST_NODE)
	aNodePtr[DATA_VALUE] := xDataValue
	aNodePtr[NEXT_NODE]  := NULL
	RETURN (aNodePtr)
