
001 :	#include 'Directry.ch'
002 :
003 :	#define NODE_MAX_KEYS				8
004 :	#define NULL						NIL
005 :
006 :	#define KEY_POINTER_PAIRS		1
007 :	#define DATA_VALUES				1
008 :	#define NEXT_NODE					2
009 :	#define NUM_KEYS					3
010 :	#define NODE_MAX					4
011 :	#define PREVIOUS_NODE				5
012 :
013 :	#define KEY_VALUE					1
014 :	#define CHILD_NODE				2
015 :
016 :	#define SPLIT_KEY					1
017 :	#define NEW_SPLIT_NODE			2
018 :
019 :	#define ELEMENT					1
020 :
021 :	#define IsBranch(axNode)			LEN(axNode) == 4
022 :	#define HighestKey(axNode)		IF(IsBranch(axNode),;
023 :		axNode[KEY_POINTER_PAIRS,axNode[NUM_KEYS],KEY_VALUE],;
024 :		axNode[DATA_VALUES,axNode[NUM_KEYS]])
025 :
026 :	#define HIGHEST_CHILD_NODE(axNode)	;
			axNode[KEY_POINTER_PAIRS, ;
			axNode[NUM_KEYS], CHILD_NODE]
027 :
028 :	#define NextHighestKeyPos(axNode,aKey) ;
029 :		ASCAN(axNode[DATA_VALUES],{|x| IF(IsBranch(axNode),;
030 :		x[KEY_VALUE,ELEMENT] >= aKey[ELEMENT],;
031 :		x[ELEMENT] >= aKey[ELEMENT] )} )
032 :
033 : #define KeyInNode(axNode,aKey,nInsertPos) ;
034 :		IF(IsBranch(axNode), axNode[KEY_POINTER_PAIRS, ;
			nInsertPos, KEY_VALUE,ELEMENT]==	aKey[ELEMENT],;
035 :		axNode[DATA_VALUES,nInsertPos,ELEMENT] == ;
			aKey[ELEMENT])
036 :
037 :	#define RoomInNode(axNode)		axNode[NUM_KEYS] < ;
038 :		axNode[NODE_MAX]
039 :
040 :
041 :	FUNCTION Main
042 :		LOCAL aFilesBTree, aDirectory, i
043 :		CLEAR SCREEN
044 :
045 :		aDirectory := DIRECTORY("*.*")
046 :
047 :		// Loop to build a binary tree of file information
048 :		FOR i = 1 to LEN(aDirectory)
049 :			BTreeInsert(@aFilesBTree, aDirectory[i])
050 :		NEXT i
051 :
052 :		// Display contents of binary tree
053 :		BTreeList(aFilesBTree)
054 :		RETURN (NIL)
055 :
056 :
057 :	FUNCTION BTreeList(aBTree)
058 :		LOCAL aNode := aBTree, i
059 :
060 :		DO WHILE IsBranch(aNode)
061 :			aNode := aNode[KEY_POINTER_PAIRS, 1, CHILD_NODE]
062 :		ENDDO
063 :
064 :		DO WHILE .T.
065 :			FOR i=1 TO aNode[NUM_KEYS]
066 :				? PAD( aNode[KEY_VALUE,i,F_NAME], 13), ;
067 :				aNode[KEY_VALUE,i,F_SIZE], ;
068 :				aNode[KEY_VALUE,i,F_DATE], ;
069 :				aNode[KEY_VALUE,i,F_TIME], ;
070 :				aNode[KEY_VALUE,i,F_ATTR]
071 :			NEXT i
072 :
073 :			IF aNode[NEXT_NODE] == NULL
074 :				EXIT
075 :			ELSE
076 :				aNode := aNode[NEXT_NODE]
077 :			ENDIF
078 :		ENDDO
079 :		RETURN (NIL)
080 :
081 :
082 :	FUNCTION BTreeInsert(aNode, aKey)
083 :		STATIC nRecursLevel := 0
084 :		LOCAL aSplit, aNewNode, nHighest
085 :
086 :		IF VALTYPE(aKey) <> "A"
087 :			aKey := {aKey}
088 :		ENDIF
089 :
090 :		nRecursLevel++
091 :
092 :		DO CASE
093 :		CASE aNode == NIL
094 :			aNode := CreateBranch(aKey, CreateLeaf(aKey))
095 :
096 :		CASE IsBranch(aNode)
097 :			IF aKey[ELEMENT] > HighestKey(aNode)[ELEMENT]
098 :				IF aNode[NEXT_NODE] == NULL
099 :					aNewNode := CreateLeaf(aKey)
100 :					aNewNode[PREVIOUS_NODE]:= ;
							HIGHEST_CHILD_NODE(aNode)
101 :					aNode[NEXT_NODE] := aNewNode
						//	The following lvalue yields an array 
						//	expression (see pseudo-function declared 
						//	on line 26).
102 :					HIGHEST_CHILD_NODE(aNode)[NEXT_NODE] := ;
							aNewNode
103 :				ELSE
104 :					aSplit:= BTreeInsert(aNode[NEXT_NODE], aKey)
105 :				ENDIF
106 :			ELSE
107 :				nHighest := NextHighestKeyPos(aNode,aKey)
108 :				aSplit:= BTreeInsert(aNode[KEY_POINTER_PAIRS, ;
						nHighest, CHILD_NODE], aKey)
109 :			ENDIF
110 :
111 :			IF aSplit <> NIL
112 :				aSplit := InsertKey(aNode, aSplit[SPLIT_KEY], ;
						aSplit[NEW_SPLIT_NODE])
113 :				IF nRecursLevel = 1 .AND. aSplit <> NIL
114 :					aNewNode := CreateBranch(aSplit[SPLIT_KEY],;
							aSplit[NEW_SPLIT_NODE])
115 :					aNewNode[NEXT_NODE] := aNode
116 :					aNode := aNewNode
117 :				ENDIF
118 :			ENDIF
119 :
120 :		OTHERWISE
121 :			aSplit := InsertKey( aNode, aKey )
122 :
123 :		ENDCASE
124 :		nRecursLevel--
125 :		RETURN (aSplit)
126 :
127 :
128 :	STATIC FUNCTION InsertKey(aNode, aKey, aSplitNode)
129 :		LOCAL aSplit, nInsertPos
130 :
131 :		nInsertPos := NextHighestKeyPos(aNode, aKey)
132 :
133 :		IF nInsertPos <> 0
134 :			IF KeyInNode(aNode, aKey, nInsertPos)
135 :				aNode[NODE_MAX]++
136 :			ENDIF
137 :		ENDIF
138 :
139 :		IF RoomInNode(aNode)
140 :			BTInsert(aNode, aKey, nInsertPos, aSplitNode)
141 :		ELSE
142 :			aSplit := BTSplit(aNode, aKey, aSplitNode)
143 :		ENDIF
144 :
145 :		RETURN (aSplit)
146 :
147 :
148 :	STATIC FUNCTION BTInsert(aNode,aKey, nInsertPos, ;
			aSplitNode)
149 :		ASIZE(aNode[DATA_VALUES], aNode[NUM_KEYS] + 1)
150 :
151 :		IF nInsertPos = 0
152 :			nInsertPos := LEN(aNode[DATA_VALUES])
153 :		ENDIF
154 :
155 :		IF IsBranch(aNode)
156 :			aKey := {aKey, aSplitNode}
157 :		ENDIF
158 :
159 :		AINS(aNode[DATA_VALUES],nInsertPos)
160 :		aNode[DATA_VALUES,nInsertPos] := aKey
161 :		aNode[NUM_KEYS]++
162 :		RETURN (NIL)
163 :
164 :
165 :	STATIC FUNCTION BTSplit(aNode, aKey, aSplitNode )
166 :		LOCAL nSplitPos, aNewNode, aTemp, nInsertPos, i, ;
				nMidPoint, lIsBranch
167 :
168 :		nMidPoint := nSplitPos := INT(aNode[NUM_KEYS]/2)
169 :		lIsBranch := IsBranch(aNode)
170 :
171 :		FOR i := nSplitPos + 1 TO aNode[NODE_MAX]
172 :			IF IIF(lIsBranch, aNode[KEY_POINTER_PAIRS, i, ;
173 :				KEY_VALUE]==aNode[KEY_POINTER_PAIRS,nMidPoint,;
174 :				KEY_VALUE], aNode[DATA_VALUES, i] == ;
175 :				aNode[DATA_VALUES, 	nMidPoint])
176 :				nSplitPos++
177 :			ELSE
178 :				EXIT
179 :			ENDIF
180 :		NEXT i
181 :
182 :		IF nSplitPos == aNode[NODE_MAX]
183 :			nSplitPos := nMidPoint -1
184 :			FOR i := nSplitPos TO 1 STEP -1
185 :				IF IIF( lIsBranch, aNode[KEY_POINTER_PAIRS,i, ;
186 :					KEY_VALUE] == aNode[KEY_POINTER_PAIRS, ;
187 :					nMidPoint,KEY_VALUE],aNode[DATA_VALUES,i]==;
188 :					aNode[DATA_VALUES, nMidPoint] )
189 :					nSplitPos--
190 :				ELSE
191 :					EXIT
192 :				ENDIF
193 :			NEXT i
194 :		ENDIF
195 :
196 :		aNewNode := {{}, aNode, nSplitPos, MAX(NODE_MAX_KEYS, ;
				nSplitPos+1)}
197 :		IF .NOT. lIsBranch
198 :			AADD( aNewNode, aNode[PREVIOUS_NODE] )
199 :		ENDIF
200 :
201 :		AEVAL(aNode[DATA_VALUES], ;
202 :			{|x| AADD(aNewNode[DATA_VALUES],x)}, 1, nSplitPos)
203 :
204 :		IF .NOT. lIsBranch
205 :			IF aNode[PREVIOUS_NODE] <> NULL
206 :				aNode[PREVIOUS_NODE,NEXT_NODE] := aNewNode
207 :			ENDIF
208 :			aNode[PREVIOUS_NODE] := aNewNode
209 :		ENDIF
210 :
211 :
212 :		aTemp := {}
213 :	 	AEVAL(aNode[DATA_VALUES], {|x| AADD(aTemp, x)}, ;
				nSplitPos+1)
214 :		aNode[DATA_VALUES]:=aTemp
215 :
216 :		aNode[NUM_KEYS]:= aNode[NODE_MAX] - nSplitPos
217 :		aNode[NODE_MAX]:= MAX(NODE_MAX_KEYS,aNode[NUM_KEYS] +1)
218 :
219 :		IF aKey[ELEMENT] <= IIF( lIsBranch,;
220 :			aNewNode[KEY_POINTER_PAIRS, aNewNode[NUM_KEYS], ;
				KEY_VALUE,ELEMENT], aNewNode[DATA_VALUES, ;
221 :			aNewNode[NUM_KEYS],ELEMENT])
222 :			nInsertPos := NextHighestKeyPos(aNewNode, aKey)
223 :			BTInsert(aNewNode, aKey,nInsertPos, aSplitNode)
224 :		ELSE
225 :			nInsertPos := NextHighestKeyPos(aNode, aKey)
226 :			BTInsert(aNode, aKey, nInsertPos, aSplitNode)
227 :		ENDIF
228 :
229 :		RETURN ({HighestKey(aNewNode), aNewNode})
230 :
231 :
232 :	STATIC FUNCTION CreateBranch(Key, nChildPointer)
233 :		RETURN ({{{Key,nChildPointer}},NULL, 1, NODE_MAX_KEYS})
234 :
235 :
236 :	STATIC FUNCTION CreateLeaf(Key)
237 :		RETURN ({{Key}, NULL, 1, NODE_MAX_KEYS, NULL})
