
//Structure of a binary tree
#define BINARY_TREE_NODE	3	// Length of binary tree structure
#define LEFT_SUBTREE			1
#define DATA_VALUE			2
#define RIGHT_SUBTREE 		3

#define NULL					NIL
#define ELEMENT				1

#include 'Directry.ch'

#translate malloc(<x>) 	=> ARRAY(<x>)
#command REPEAT			=> DO WHILE .T.
#command UNTIL <x>		=> IF <x>; EXIT; END; END

FUNCTION Main
	LOCAL aFilesList, aDirectory, i
	CLEAR SCREEN

	aDirectory := DIRECTORY("*.*")

	// Loop to build a binary tree of file information
	FOR i = 1 to LEN(aDirectory)
		TreeAdd(@aFilesList, aDirectory[i])
	NEXT i

	// Display contents of binary tree
	TreeList(aFilesList)
	RETURN (NIL)


FUNCTION TreeList(aSubTree)
	IF aSubTree[LEFT_SUBTREE] <> NULL
		TreeList(aSubTree[LEFT_SUBTREE])
	ENDIF

	? PAD( aSubTree[DATA_VALUE, F_NAME], 13 ),;
		aSubTree[DATA_VALUE, F_SIZE],;
		aSubTree[DATA_VALUE, F_DATE],;
		aSubTree[DATA_VALUE, F_TIME],;
		aSubTree[DATA_VALUE, F_ATTR]

	IF aSubTree[RIGHT_SUBTREE] <> NULL
		TreeList(aSubTree[RIGHT_SUBTREE])
	ENDIF
	RETURN (NIL)


FUNCTION TreeAdd(aBinaryTree, aKey)
	LOCAL aCurNode, aNewNode

	IF .NOT. VALTYPE( aKey ) == "A"
		aKey := { aKey }
	ENDIF

	aNewNode := CreateNode( aKey )
	aCurNode := aBinaryTree

	IF aBinaryTree <> NIL
		REPEAT
			IF aNewNode[DATA_VALUE, ELEMENT] > ;
				aCurNode[DATA_VALUE, ELEMENT]
				IF aCurNode[RIGHT_SUBTREE] == NULL
					aCurNode[RIGHT_SUBTREE] := aNewNode
				ENDIF
				aCurNode := aCurNode[RIGHT_SUBTREE]
			ELSE
				IF aCurNode[LEFT_SUBTREE] == NULL
					aCurNode[LEFT_SUBTREE] := aNewNode
				ENDIF
				aCurNode := aCurNode[LEFT_SUBTREE]
			ENDIF
		UNTIL (aCurNode == aNewNode )
	ELSE
		aBinaryTree := aNewNode
	ENDIF
	RETURN (NIL)


STATIC FUNCTION CreateNode(xDataValue)
	LOCAL aNodePtr := malloc(BINARY_TREE_NODE)
	aNodePtr[DATA_VALUE] := xDataValue
	aNodePtr[RIGHT_SUBTREE] := aNodePtr[LEFT_SUBTREE] := NULL
	RETURN (aNodePtr)
