// TBWhile() is a TBrowse system that enables you to limit a
// browse to a specified range of records.

// Calling Syntax:

// TBwhile(2,2,22,75, cIndexKey, ;           // Four corners, indexkey
//        { || FIELD->Unit := cIndexKey } )  // and assignment block
                                             // for appended records

#include "inkey.ch"

// File wide static variables.
STATIC oTB   // A TBrowse object.
STATIC oCol  // A pointer to the TBcolumn object.



FUNCTION TBwhile(nT, nL, nB, nR, cKeyValue, bKeyBlock)
LOCAL i, lNewRecord, cPrevScr, cKey
IF bKeyBlock == NIL
   bKeyBlock := {|| Date() }
ENDIF

SET CURSOR OFF

// Create the browse object.
oTB := TBrowseDb(nT+1, nL+1, nB-2, nR-1)
oTB:ColorSpec := SetColor()

IF cKeyValue <> NIL
   oTB:SkipBlock := {|x| SkipCode(x,cKeyValue)}
   oTB:GoTopBlock := {| | SkipCode((LastRec() * -1),cKeyValue)}
   oTB:GoBottomBlock := {| | SkipCode((LastRec() * 1),cKeyValue)}
ENDIF



// This next section creates the column objects for the browse.
// If any single field is used as an index key, it is not
// included in the browse.
FOR i = 1 TO FCOUNT()

   IF Field(i) == Upper(IndexKey()) 

      LOOP
   ENDIF

   oCol := TBcolumnNew(FieldName(i),FieldBlock(Field(i)) )
   oTB:AddColumn(oCol)     

NEXT

// Specify column header and column separator characters.
oTB:HeadSep := CHR(205)+CHR(209)+CHR(205)
oTB:FootSep := CHR(205)+CHR(207)+CHR(205)
oTB:ColSep := CHR(32)+CHR(179)+CHR(32)

// Here it goes into action.
WinShade(nT,nL,nB,nR, "ON")
@ nT+1,nL+1 CLEAR TO nB-1,nR-1
@ nB-1, nL+1 SAY PadC(" F9 = New Record  " + ;
               "F10 = Delete Record   " + ;
               "ESC = End Entry", (nR - nL -1))
// The structure of this keystroke processor is similar to the
// one presented previously. A GET function has been added as
// well.
DO WHILE .T.

   DO WHILE .NOT. oTB:Stabilize()                && Same as before.
      cKey := InKey()

      IF cKey <> 0
         EXIT
      ENDIF
   ENDDO


   IF oTB:Stable
      IF oTB:HitBottom .OR. oTB:HitTop
         Tone(200,1)
      ENDIF
      IF cKeyValue <> NIL

         IF cKeyValue <> Trim(&(IndexKey()))     && Terminates when the last
            EXIT                       && remaining record has been deleted.
         ENDIF
      ENDIF
      IF LastRec() == 0
         EXIT
      ENDIF


      cKey := InKey(0)     && Entry allowed, records in range,
                           && so just wait for keystrokes.
   ENDIF


   // Process keystrokes.
   IF cKey == K_F9
      IF Apnd()                                  && Create a new record and stuff the
         EVAL(bKeyBlock)                         && key value into it by EVALuating
                                                 && the key block that was passed as
                                                 && a parameter.
         oTB:GoTop()                             && The effect of these three lines
         oTB:GoBottom()                          && is to position the highlight on
         oTB:RefreshAll()                        && the new record in the lowest
                                                 && possible row in the window,
                                                 && which displays the maximum
                                                 && number of records.
      ELSE
         EXIT                                    && If the APPEND fails, drop out.
      ENDIF
   ELSEIF cKey == K_F10                          && User hit DELETE key.
      IF Rlok()                                  && Lock the record and delete it.
         DELETE                                  && Move the browse cursor to the
         oTB:GoTop()                             && top of the range to make sure
         oTB:RefreshAll()                        && the deleted record is no longer
                                                 && displayed. REQUIRES SET DELETED
                                                 && ON or a column to show deleted
                                                 && status.
      ENDIF                                      && If the lock fails, nothing happens. Browse
                                                 && continues.
   ELSEIF cKey == K_DOWN
      oTB:Down()
   ELSEIF cKey == K_UP
      oTB:Up()
   ELSEIF cKey == K_PGDN
      oTB:PageDown()
      oTB:RefreshAll()
   ELSEIF cKey == K_PGUP
      oTB:PageUp()
      oTB:RefreshAll()
   ELSEIF cKey == K_CTRL_PGDN
      oTB:GoBottom()
      oTB:RefreshAll()
   ELSEIF cKey == K_CTRL_PGUP
      oTB:GoTop()
      oTB:RefreshAll()
   ELSEIF cKey == K_RIGHT
      oTB:Right()
   ELSEIF cKey == K_LEFT
      oTB:Left()
   ELSEIF cKey == K_HOME
      oTB:Home()
   ELSEIF cKey == K_END
      oTB:End()
   ELSEIF cKey == K_CTRL_LEFT
      oTB:PanLeft()
   ELSEIF cKey == K_CTRL_RIGHT
      oTB:PanRight()
   ELSEIF cKey == K_CTRL_HOME
      oTB:PanHome()
   ELSEIF cKey == K_CTRL_END
      oTB:PanEnd()
   ELSEIF cKey == K_ESC                          && User terminates.
      EXIT

      // If the user presses return, the browse cursor is moved one
      // column to the right unless it is in the last column, in which
      // case it drops a line and moves to the leftmost column.
   ELSEIF cKey == K_RETURN
      IF oTB:ColPos < oTB:ColCount
         oTB:Right()
      ELSEIF oTB:ColPos == oTB:ColCount
         oTB:Down()
         oTB:PanHome()
      ENDIF
   ELSE
      KEYBOARD CHR(cKey)                         && Any other key causes the field
      ColGet(oTB)                                && to be edited.
   ENDIF
ENDDO
WinShade(nT,nL,nB,nR,"OFF")                 && Clean up and go back.
SET CURSOR ON
RETURN


STATIC FUNCTION ColGet(oTB)

LOCAL oColumn                                    && GET Column.
LOCAL oGet                                       && GET object.
LOCAL l_set := ReadExit(.T.)                     && Allow ESC to abort field edit.

DO WHILE .NOT. oTB:Stabilize()                   && Make it stable before
ENDDO                                            && editing.


// Create a new get object from the information held by the
// browse object.
oColumn := oTB:GetColumn(oTB:ColPos)
IF Upper(AllTrim(oColumn:Heading)) == Upper(AllTrim(IndexKey()))
   CLEAR TYPEAHEAD
   RETURN NIL
ENDIF

oGet := GetNew(Row(),Col(), oColumn:Block, oColumn:Heading)
oGet:ColorSpec := SubStr( SetColor(), Rat(",", SetColor())+1) + "," + ;
                  SubStr( SetColor(), Rat(",", SetColor())+1) 

IF .NOT. Rlok()                                  && If the record can't be locked the field
   RETURN NIL                                    && can't be edited.
ENDIF                                                           

SET CURSOR ON                                    && Unhide cursor.

ReadModal ({oGet})                               && Take entry into the get object.

oTB:RefreshCurrent()                             && Update the screen.

SET CURSOR OFF                                   && Re-hide the cursor and set READEXIT
ReadExit(l_set)                                  && back to its previous status.


IF LastKey() == K_UP .OR. ;                      && Certain keys need to be put
   LastKey() == K_DOWN .OR. ;                    && into the keyboard buffer in
   LastKey() == K_PGUP .OR. ;                    && order to honor the normal
   LastKey() == K_PGDN                           && @...GET conventions.

   KEYBOARD CHR(LastKey())
ENDIF

// If the entry is terminated by ENTER, the browse cursor needs
// to be moved to the next field.
IF LastKey() == K_RETURN .AND. oTB:ColPos < oTB:ColCount
   oTB:Right()
ELSEIF LastKey() == K_RETURN .AND. oTB:ColPos == oTB:ColCount
   oTB:Down()
   oTB:PanHome()
ENDIF

RETURN NIL



// This function keeps the browse within the range of records
// that share the key value specified when TBwhile() was called
// regardless of the number of records it has been told to SKIP.
// x is the number of records the brows object has asked to be
// SKIPped.
STATIC FUNCTION SkipCode(x,cKeyValue)
LOCAL i := 0

IF LastRec() == 0            && If there are no records, back out.
   RETURN i
ENDIF


// If the SKIP is forward and the file is not at end of file.
IF ( x > 0 .AND. RECNO() <> LastRec() +1 )
   // Loop as many times as there were SKIPs requested.
   DO WHILE ( i < x )
      SKIP 1
      // If SKIP goes out of range, back up and terminate.
      IF EOF() .OR. cKeyValue <> Trim(&(IndexKey()))
         SKIP -1
         EXIT
      ENDIF
      i++                    && Increment counter variable.
   ENDDO

   // If a backward skip is asked for....
ELSEIF ( x < 0 )
   DO WHILE ( i > x )                            && For as many records as requested
      SKIP -1                                    && SKIP backwards until beginning of
      IF BOF()                                   && file.
         EXIT
      ENDIF
      IF cKeyValue <> Trim(&(IndexKey()))
         SKIP 1                                  && range, come back and
         EXIT                                    && terminate.
      ENDIF
      i--                                        && Decrement counter variable.
   ENDDO
ENDIF
RETURN i                                         && Tell the browse object how many records were
                                                 && actually SKIPped.
*****************************************************************



