#include "Inkey.ch"
#include "Setcurs.ch"
#include "Error.ch"




// These #defines use the browse's "cargo" slot to hold the
// "append mode" flag for the browse. The #defines make it
// easy to change this later (e.g. if you need to keep
// several items in the cargo slot).
#define TURN_ON_APPEND_MODE(b)      (b:cargo := .T.)
#define TURN_OFF_APPEND_MODE(b)     (b:cargo := .F.)
#define IS_APPEND_MODE(b)           (b:cargo)
#define SAVEROW       .T.
#define RESTOREROW    .F.

// Separator strings for the browse display
#define MY_HEADSEP      ""
#define MY_COLSEP       "  "

STATIC FRAME:=chr(201)+chr(205)+chr(187)+chr(186)+chr(188)+chr(205)+chr(200)+chr(186)+" "



**************************************************************************
* bArray[1]={(.T. or .F.), dbf}
* bArray[2]=index
* bArray[3]={toprow,leftcol,bottomrow,rightcol}
* bArray[4]={appendmode  (.t. or .f.,""}
* bArray[5]={different Skipper codeblock(.T. or .F.),{||Skipper code Block}}
* bArray[6]={Record number in 1st col? (.T. or .F.),(ok, how many columns TO freeze?)}
* bArray[7]={Shadow or not? (.T. or .F.),Frame or not?(.T. or .F.)}
* bArray[8]={different Applykey(.T. or .F.),{||codeblock}}
* bArray[9]={different get(.T. or .F.),{||codeblock}}
* bArray[10]={Standard or Custom columns(.T. or .F.),{||codeblock(s)}}
* 

procedure po(dbf,index)


public bArray[10],ROWARRAY[80]


    // Lazy man's error checking
    bSaveHandler := ERRORBLOCK( {|x| BREAK(x)} )

    BEGIN SEQUENCE


      if empty(dbf)

        use bulk 

      else

        USE (dbf) INDEX (index)

      endif

    RECOVER USING error
        IF error:genCode == EG_OPEN
            ?? "Error opening file(s)"

        ELSE
            // Assume it was a problem with the params
            ?? "Usage: Tbdemo <dbf> [<index>]"

        ENDIF
       QUIT
      
    END

    // Restore the default error handler
    ERRORBLOCK(bSaveHandler)



      bArray[1]:={.F.,"PO"}
      bArray[2]:={.f.,""}
      bArray[3]:={2,2,21,76}
      bArray[4]:={.f.,""}
      bArray[5]:={.f.,""}
      bArray[6]:={.f.,""}
      bArray[7]:={.t.,.t.}
      bArray[8]:={.f.,""}
      bArray[9]:={.f.,""}
      bArray[10]:={.t.,{|x|tbulkscrn(x)}}


      tbarray(bArray)


return


function tbulkscrn(browse)

    LOCAL FLDARRY:={}

	old_select:=select()
    dbfname:=alias()
	select 3
	use bulkscr
    SET FILTER TO database=DBFNAME
    GOTO TOP
    IF BULKSCR->DATABASE<>DBFNAME
       dbclosearea()
       select(old_select)
       return browse
    endif
	DO WHILE !EOF()
		 IF BROWNORM1
		    AADD(FLDARRY,{BROWORD1,FIELD_NAME,BROWHDR1,BROWWID1})
		 ENDIF
		 SKIP
	ENDDO
	DBCLOSEAREA()
	SELECT(OLD_SELECT)
	ASORT(FLDARRY,,, {|x,y|x[1]<y[1]})
	N1=LEN(FLDARRY)
    // Add a column for each field in the current workarea
    FOR n := 1 TO N1
  
        // Make a new column
        column := TBColumnNew(                                          ;
                                FLDARRY[N,3],                       ;
                                FieldWBlock(FLDARRY[n][2], Select()) ;
                             )

        // Add the column to the browse
        browse:addColumn(column)
		column:width:=fldarry[n][4]
    NEXT
    browse:freeze := 1

   return browse


****
*   Tbarray()
*
*   Highly modified Tbdemo.prg w/Hiliter
*
*


***
*   Tbarray(aArray)
*

Function Tbarray(xArray)

    LOCAL bSaveHandler, error
    LOCAL cScreen
	PRIVATE OLDSELECT,OLDINDEX
    PUBLIC TOPONA,LEFTONA,BOTTOMA,RIGHTONA
    PUBLIC aArray



	OLDSELECT:=SELECT()
    oldindex:=indexord()
    cScreen := SAVESCREEN()	                 
    SETCOLOR("N/R+")

    aArray:=aclone(xArray) //Clone xArray because xArray as a passed parameter
                           //is PRIVATE and the array has parameter for various
                           //other procedures.


    if len(aArray[3])==4

       TOPONA:=aArray[3][1]
       LEFTONA:=aArray[3][2]
       BOTTOMA:=aArray[3][3]
       RIGHTONA:=aArray[3][4]  //Setup these variables so we can adjust the size
                               //of the window on the fly!
    else

       TOPONA:=1
       LEFTONA:=1
       BOTTOMA:=23
       RIGHTONA:=78

    endif

    if aArray[1][1]   //use current work area database or a new one?  aArray[1]={(.T. or .F.),dbf}

       // Lazy man's error checking
       bSaveHandler := ERRORBLOCK( {|x| BREAK(x)} )
   
       BEGIN SEQUENCE
   
   
          USE (aArray[1][2]) INDEX (aArray[2][2])  // aArray[2]=index                        
                                                           
   
       RECOVER USING error
           IF error:genCode == EG_OPEN
               ?? "Error opening file(s)"
   
           ELSE
               // Assume it was a problem with the params
               ?? "Error other than opening file(s)"
   
           ENDIF
   
           QUIT
       END
   
       // Restore the default error handler
       ERRORBLOCK(bSaveHandler)

    endif

	DO WHILE .T.
        RECNUM:=Mybrowse(TOPONA,LEFTONA,BOTTOMA,RIGHTONA)
		OUT1:=LASTKEY()
		IF OUT1==K_ESC

		   RECNUM:=0
		   EXIT

		ELSEIF OUT1==K_F10

		   EXIT

		ENDIF
        SET COLOR TO                             
        @ MAXROW(), 0
        RESTSCREEN(,,,,cScreen)
        SETCOLOR("N/BG")
    ENDDO
    SET COLOR TO                             
    @ MAXROW(), 0
    RESTSCREEN(,,,,cScreen)
	SET FILTER TO
    SELECT(OLDSELECT)
	SET ORDER TO oldindex

	RETURN RECNUM






***
*   MyBrowse()
*   Create a Tbrowse object and browse with it.
*

 PROCEDURE MyBrowse(nTop, nLeft, nBottom, nRight)

    LOCAL browse                        // The TBrowse object
    LOCAL cColorSave, nCursSave         // State preservers
    LOCAL nKey                          // Keystroke
    LOCAL lMore                         // Loop control
    public cursormove:=.t.                                   //* change for hiliter

    // Make a "stock" Tbrowse object for the current workarea
    browse := StockBrowseNew(nTop, nLeft, nBottom, nRight)
    browse:autolite:=.f.
    // This demo uses the browse's "cargo" slot to hold a logical
    // value of true (.T.) when the browse is in "append mode",
    // otherwise false (.F.) (see #defines at top).
    TURN_OFF_APPEND_MODE(browse)                                   

    // Use a custom 'skipper' to handle append mode (see below)

    IF aArray[5][1]

        browse:skipBlock := aArray[5][2]

    ELSE

        browse:skipBlock := { |x| Skipper(x, browse) }      //aArray[5]={Custome Skipper or Default(.T. or .F.),Skipper code Block}

    ENDIF

    // Change the heading and column separators
    browse:headSep := MY_HEADSEP
    browse:colSep := MY_COLSEP

    // Play with the colors
    FancyColors(browse)

    // Insert a column at the left for "Rec #" and freeze it       
    if aArray[6][1]

       AddRecno(browse)    //aArray[6]=Record number in 1st col? (.T. or .F.)

    else 

       browse:freeze:=aArray[6][2]

    endif


    // Draw a window shadow   aArray[7]=Shadow or not? (.T. or .F.)

    if aArray[7][1]

       cColorSave := SetColor("N/N")
       @ nTop+1, nLeft+1 CLEAR TO nBottom+1, nRight+1
       SETCOLOR("W/W")
       @ nTop, nLeft CLEAR TO nBottom, nRight
       SETCOLOR(cColorSave)

    endif
    if aArray[7][2]
      @ ntop-1, nleft-1, nbottom+1,nright+1 box frame
    endif

    // Save cursor shape, turn the cursor off while browsing

    //nCursSave := SetCursor(SC_NONE)             
    
    nCursSave := SetCursor(SC_NORMAL)  //*set cursor on when using 
                                       //*hiliter to browse individual fields
    // Main loop
    lMore := .T.
    DO WHILE lMore

        // Don't let the cursor move into frozen columns
        IF browse:colPos <= browse:freeze
            browse:colPos := browse:freeze + 1
        ENDIF

        // Stabilize the display until it's stable or a key is pressed
        nKey := 0
        DO WHILE nKey == 0 .AND. .NOT. browse:stable

            browse:stabilize()
            nKey := InKey()

        ENDDO


        IF browse:stable

            IF browse:hitBottom .AND. aArray[4][1] //aArray[4]=appendmode  (.t. or .f.)
                // Banged against EOF; go into append mode  


                TURN_ON_APPEND_MODE(browse)


                nKey := K_DOWN

            ELSE
                IF browse:hitTop .OR. browse:hitBottom
                    TONE(125, 0)
                ENDIF

                // Make sure that the current record is showing
                // up-to-date data in case we are on a network.

           IF cursormove

                browse:refreshCurrent()

                ForceStable(browse)

                ROWHILITE(SAVEROW,browse:rowpos)

                cursormove:=.f.

           endif

                // Everything's done -- just wait for a key
                nKey := InKey(0)

            ENDIF

        ENDIF
		DO CASE
		   CASE nkey == K_ESC
		        LMORE := .F.

		   CASE nkey == K_CTRL_F1
		        ++TOPONA
				IF TOPONA>=BOTTOMA
				     --TOPONA
				ENDIF
				LMORE := .F.

		   CASE	nkey ==	K_CTRL_F2
		        --TOPONA
				IF TOPONA==0
				  ++TOPONA
				ENDIF
				LMORE := .F.

		   CASE	nkey ==	K_CTRL_F3
		        --BOTTOMA
				IF BOTTOMA<=TOPONA
				    ++BOTTOMA
				ENDIF
				LMORE := .F.

		   CASE	nkey ==	K_CTRL_F4
		        ++BOTTOMA
				IF BOTTOMA>=24
				   --BOTTOMA
				ENDIF
				LMORE := .F.

		   CASE nkey == K_CTRL_F5
		        ++LEFTONA
				IF LEFTONA>=RIGHTONA
				  --LEFTONA
				ENDIF
				LMORE := .F.

		   CASE nkey == K_CTRL_F6
		        --LEFTONA
				IF LEFTONA==0
				   ++LEFTONA
				ENDIF
				LMORE := .F.

		   CASE nkey == K_CTRL_F7
		        --RIGHTONA
				IF RIGHTONA<=LEFTONA
				   ++RIGHTOP
				ENDIF
				LMORE := .F.

		   CASE nkey == K_CTRL_F8
		        ++RIGHTONA
				IF RIGHTONA>=79
				   --RIGHTONA
				ENDIF
				LMORE := .F.

           CASE nKey == K_ESC
                lMore := .F.

		   CASE nkey == K_F10
		        lmore := .f.
        OTHERWISE
            // Apply the key to the browse  aArray[8]={different Applykey(.T. or .F.),codeblock}
            if aArray[8][1]

               eval(aArray[8][1],browse,nkey)

            else

               ApplyKey(browse, nKey)

            endif

        ENDCASE


    ENDDO


    SETCURSOR(nCursSave)

    RETURN



****
*   Skipper()
*   Handle record movement requests from the Tbrowse object.
*
*   This is a special "skipper" that handles append mode. It
*   takes two parameters instead of the usual one. The second
*   parameter is a reference to the Tbrowse object itself. The
*   Tbrowse's "cargo" variable contains information on whether
*   append mode is turned on.
*
*   NOTE: uses the cargo #defines shown at the top of Tbdemo.prg
*

 FUNCTION Skipper(n, browse)

    LOCAL lAppend
    LOCAL i


    lAppend := IS_APPEND_MODE(browse)           // see #defines at top
    i := 0

    IF n == 0 .OR. LASTREC() == 0

        // Skip 0 (significant on a network)
        SKIP 0

    ELSEIF n > 0 .and. RECNO() != LASTREC() + 1

        // Skip forward
        DO WHILE i < n
            SKIP 1
            IF ( EOF() )
                IF ( lAppend )
                    i++
                ELSE
                    SKIP -1
                ENDIF

                EXIT
            ENDIF

            i++
        ENDDO

    ELSEIF n < 0

        // Skip backward
        DO WHILE i > n
            SKIP -1
            IF ( BOF() )
                EXIT
            ENDIF

            i--
        ENDDO

    ENDIF


    RETURN i



***
*   ApplyKey()
*   Apply one keystroke to the browse.                           
*
*   NOTE: uses the cargo #defines shown at the top of Tbdemo.prg
*

 PROCEDURE ApplyKey(browse, nKey)




    DO CASE
    CASE nKey == K_DOWN
        browse:down()
        cursormove:=.t.   //*another change for hiliter

    CASE nKey == K_PGDN
        browse:pageDown()
        cursormove:=.t.   //*another change for hiliter

    CASE nKey == K_CTRL_PGDN
        browse:goBottom()
        TURN_OFF_APPEND_MODE(browse)
        cursormove:=.t.   //*another change for hiliter

    CASE nKey == K_UP
        browse:up()
        cursormove:=.t.   //*another change for hiliter

        IF IS_APPEND_MODE(browse)
            TURN_OFF_APPEND_MODE(browse)
            browse:refreshAll()
        ENDIF

    CASE nKey == K_PGUP
        browse:pageUp()
        cursormove:=.t.   //*another change for hiliter

        IF IS_APPEND_MODE(browse)
            TURN_OFF_APPEND_MODE(browse)
            browse:refreshAll()
        ENDIF

    CASE nKey == K_CTRL_PGUP
        browse:goTop()
        cursormove:=.t.   //*another change for hiliter
        TURN_OFF_APPEND_MODE(browse)

    CASE nKey == K_RIGHT
       
        if browse:colpos == browse:rightvisible .and.;
                          browse:colcount > browse:rightvisible

        cursormove:=.t.   //*another change for hiliter
        
        endif

        browse:right()

    CASE nKey == K_LEFT


        if browse:leftvisible>1 .and. browse:leftvisible==browse:colpos

        cursormove:=.t.   //*another change for hiliter
        
        endif
        browse:left()


    CASE nKey == K_HOME
        browse:home()

    CASE nKey == K_END
        browse:end()

    CASE nKey == K_CTRL_LEFT


        if browse:leftvisible>1 

            cursormove:=.t.   //*another change for hiliter
        
        endif

        browse:panLeft()


    CASE nKey == K_CTRL_RIGHT



        if browse:colcount>browse:rightvisible

           cursormove:=.t.   //*another change for hiliter
        
        endif

        browse:panRight()
    

    CASE nKey == K_CTRL_HOME


        if browse:leftvisible>1

           cursormove:=.t.   //*another change for hiliter
        
        endif

        browse:panHome()



    CASE nKey == K_CTRL_END



        if browse:colcount>browse:rightvisible

        cursormove:=.t.   //*another change for hiliter
        
        endif
        browse:panEnd()
    
    

    CASE nKey == K_RETURN
        DoGet(browse)
        cursormove:=.f.

    OTHERWISE

        cursormove:=.f.
        KEYBOARD CHR(nKey)
        DoGet(browse)

    ENDCASE
    if cursormove


        rowhilite(RESTOREROW,browse:rowpos)

    endif

    RETURN



***
*   DoGet()
*   Do a GET for the current column in the browse.
*
*   NOTE: uses the cargo #defines shown at the top of Tbdemo.prg
*

 PROCEDURE DoGet(browse)

    LOCAL bIns, lScore, lExit
    LOCAL col, get, nKey
    LOCAL lAppend, xOldKey, xNewKey


    // Make sure screen is fully updated, dbf position is correct, etc.
    ForceStable(browse)

    // If confirming a new record, do the physical append
    lAppend := IS_APPEND_MODE(browse)
    IF lAppend .AND. RECNO() == LASTREC() + 1
        APPEND BLANK
		adder := .t.                                   //new line
    ENDIF


    // Save the current record's key value (or NIL)
    // (for an explanation, refer to the rambling note below)
    xOldKey := IF( EMPTY(INDEXKEY()), NIL, &(INDEXKEY()) )


    // Save global state
    lScore := Set(_SET_SCOREBOARD, .F.)
    lExit := Set(_SET_EXIT, .T.)
    bIns := SetKey(K_INS)

    // Set insert key to toggle insert mode and cursor shape
    SetKey( K_INS, {|| InsToggle()} )
                                                              
    // Set initial cursor shape
    SetCursor( IF(ReadInsert(), SC_INSERT, SC_NORMAL) )

    if aArray[9][1]  //aArray[9]={different get(.T. or .F.),codeblock}

       eval(aArray[9][2],browse)

    else

       // Get the current column object from the browse
       col := browse:getColumn(browse:colPos)
   
   
       // Create a corresponding GET
       get := GetNew(Row(), Col(), col:block, col:heading,,"W+/R,N/R")
   
       // Read it using the standard reader
       // NOTE: for a shared database, an RLOCK() is required here
       ReadModal( {get} )
   
    endif

    // Restore state
    SetCursor(SC_NORMAL)   //*Normally setcursor(0),meaning none
                           //*but we are using hiliter

    Set(_SET_SCOREBOARD, lScore)
    Set(_SET_EXIT, lExit)
    SetKey(K_INS, bIns)

    // Get the record's key value (or NIL) after the GET
    xNewKey := IF( EMPTY(INDEXKEY()), NIL, &(INDEXKEY()) )

    // If the key has changed (or if this is a new record)
    IF .NOT. (xNewKey == xOldKey) .OR. (lAppend .AND. xNewKey != NIL)

        // Do a complete refresh
        browse:refreshAll()
        ForceStable(browse)

        // Make sure we're still on the right record after stabilizing
        DO WHILE &(INDEXKEY()) > xNewKey .AND. .NOT. browse:hitTop()
            browse:up()
            ForceStable(browse)
        ENDDO

    ENDIF


    // For this demo, we turn append mode off after each new record
    TURN_OFF_APPEND_MODE(browse)

    // Check exit key from get
    nKey := LASTKEY()
    IF nKey == K_UP .OR. nKey == K_DOWN .OR. ;
        nKey == K_PGUP .OR. nKey == K_PGDN

        // Ugh
        KEYBOARD( CHR(nKey) )

    ENDIF


    RETURN



***
*   ForceStable()
*   Force a complete stabilization of a TBrowse.
*

 PROCEDURE ForceStable(browse)
    DO WHILE .NOT. browse:stabilize()
    ENDDO
    RETURN



***
*   InsToggle()
*   Toggle the global insert mode and the cursor shape.
*

 PROCEDURE InsToggle()

    IF READINSERT()
        READINSERT(.F.)
        SETCURSOR(SC_NORMAL)

    ELSE
        READINSERT(.T.)
        SETCURSOR(SC_INSERT)

    ENDIF

    RETURN



***
*   StockBrowseNew()
*   Create a "stock" Tbrowse object for the current workarea.
*

 FUNCTION StockBrowseNew(nTop, nLeft, nBottom, nRight)

    LOCAL browse
    LOCAL n, column, cType


    // Start with a new browse object from TBrowseDB()
    browse := TBrowseDB(nTop, nLeft, nBottom, nRight)        

    if aArray[10][1]    //aArray[10]={Standard or Custom columns(.T. or .F.,codeblock(s))

       browse:=eval(aArray[10][2],browse)

    ENDIF
    IF browse:colcount==0
    

       // Add a column for each field in the current workarea
       FOR n := 1 TO FCount()
   
           // Make a new column
           column := TBColumnNew(                                          ;
                                   Field(n),                               ;
                                   FieldWBlock(Field(n), Select())         ;
                                )
   
           // Add the column to the browse
           browse:addColumn(column)
   
       NEXT
   
    endif

    RETURN browse



***
*   FancyColors()
*   Set up some colors for the browse.
*

 PROCEDURE FancyColors(browse)

    LOCAL n, column
    LOCAL xValue


    // Set up a list of colors for the browse to use
    browse:colorSpec := "N/W, N/BG, B/W, W/R, B/W, B/BG, R/W, B/R"    //CHANGED HERE

    // Loop through the columns, choose some colors for each
    FOR n := 1 TO browse:colCount

        // Get (a reference to) the column
        column := browse:getColumn(n)

        // Get a sample of the underlying data by evaluating the codeblock
        xValue := EVAL(column:block)

        IF VALTYPE(xValue) != "N"
            // For non-numeric, just use colors 3 and 4 ("B/W" and "B/BG")
            column:defColor := {3, 4}

        ELSE
            // For numbers, use a color block to highlight negative values
            column:colorBlock := {|x| if( x < 0, {7, 8}, {5, 6} )}

            // Set default colors also (controls the heading color)
            column:defColor := {7, 8}

        ENDIF

    NEXT


    RETURN



***
*   AddRecno()
*   Insert a frozen column at the left that shows current record number
*

 PROCEDURE AddRecno(browse)

    LOCAL column

    // Create the column object
    column := TBColumnNew( "  Rec #", {|| RECNO()} )

    // Insert it as the leftmost column
    browse:insColumn(1, column)

    // Freeze it at the left
    browse:freeze := 1

    RETURN


*******************************************
*
*  ROW HILITER FUNCTION FOR A SELECTED ROW
*
*
*
*

function rowhilite(flag,rows) 


a:=savescreen(topona+rows+1,leftona,topona+rows+1,rightona)
d=chr(79)
c:=1
for b=2 to 160 step 2
    if flag
       rowarray[c]:=substr(a,b,1)
       c++
    else
       d:=rowarray[c]
       c++
    endif
    a:=stuff(a,b,1,d)
next
restscreen(topona+rows+1,leftona,topona+rows+1,rightona,a)

return 0

