/*****
 *
 * TBR18.PRG
 * Letter Incremental/decremental seek (case sensitive)
 *
 */

#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"

#include "tbrowse.ch"
#include "samples.ch"

#define        WHAT_IT_DOES           "ESC - Quit"    +;
                                      "          "    +;
                                      "ALT_X - Quits Seek" +;
                                      "          "    +;
                                      "Letters & backspace - Seek"

FUNCTION Tbr18()
   LOCAL oBrow, nKey
   LOCAL xKey, cKey
   LOCAL nLen, oCol
   LOCAL lContinue := .T.

   SET(_SET_PATH, WHERE_TO_FIND_FILES)

   DBUSEAREA( NEW, "DbfNtx", "testn" )
   DBSETINDEX( "testn" )

   // Save
   PushSets()
   PushScr()

   SET(_SET_SCOREBOARD, .F.)
   SET(_SET_CONFIRM, .T.)
   SETBLINK(.F.)
   SETCURSOR(SC_NONE)
   SETCOLOR(BGND_CLR)
   SCROLL()
   @ MAXROW(), 0 SAY PADC( WHAT_IT_DOES, MAXCOL() + 1) COLOR MSG_ROW_CLR

   // STEP 1
   oBrow := TBROWSEDB( 3, 7, MAXROW() - 3, 71 )
   oBrow:colorSpec := CLR_SPEC
   oBrow:colSep    := COLSEP
   oBrow:headSep   := HEADSEP

   // STEP 2
   oCol := TBCOLUMNNEW( "Last;Name"  , GetSetBlock(testn->lname) )
   oBrow:addColumn(oCol)

   oCol := TBCOLUMNNEW( "First;Name" , GetSetBlock(testn->fname) )
   oBrow:addColumn(oCol)

   oCol := TBCOLUMNNEW( "Extension"  , GetSetBlock(testn->ext) )
   oBrow:addColumn(oCol)

   xKey := ""
   WHILE lContinue
      @ 0, 0 SAY PADR("Key = " + xKey, MAXCOL() + 1) COLOR BROW_CLR

      // STEP 3
      cKey := CHR((nKey := IncrStable(oBrow)))

      IF (oBrow:stable)
         // STEP 4
         cKey := CHR((nKey := INKEY(0)))
         IF ( oBrow:hitTop .OR. oBrow:hitBottom )
            TONE(87.3,1)
            TONE(40,3.5)

         ENDIF

      ENDIF

      IF !TBMoveCursor( nKey, oBrow )
         IF ( nKey >= 65 .AND. nKey <= 90 ) .OR. ;
                ( nKey >= 97 .AND. nKey <= 122 )
            xKey += cKey
            SeekIt(xKey, SOFTSEEK_ON, oBrow)

         ELSEIF nKey == K_ESC
            lContinue := .F.

         ELSEIF nKey == K_ALT_X
            xKey := ""

         ELSEIF nKey == K_CTRL_H
            // Backspace
            IF (nLen := LEN(xKey)) > 0
               xKey := SUBSTR(xKey, 1, --nLen)
               SeekIt(xKey, SOFTSEEK_ON, oBrow)

            ENDIF

         ELSEIF nKey == K_ENTER
            // Edit
            DoGet(oBrow)
            xKey := ""

         ENDIF

      ENDIF

   END

   PopSets()
   PopScr()

   RETURN (.T.)

// EOF - TBR18.PRG //
