/*****
 *
 * TBR13.PRG
 * Horizontal scroll bar
 *
 */

#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"

#include "tbrowse.ch"
#include "samples.ch"

#define        WHAT_IT_DOES        "ESC - Quit          Left/Right Arrow - Move"

FUNCTION Tbr13()
   LOCAL oBrow, oCol, nKey

   SET(_SET_PATH, WHERE_TO_FIND_FILES)

   DBUSEAREA( NEW, "DbfNtx", "test" )
   DBSETINDEX( "test3" )

   SETCURSOR(SC_NONE)

   SETBLINK(.F.)
   SETCOLOR(BGND_CLR)
   SCROLL()
   SETCOLOR(BROW_CLR)       
   SCROLL( 2, 6, MAXROW() - 2, MAXCOL() - 7 )
   DISPBOX( 2, 6, MAXROW() - 2, MAXCOL() - 7, B_DOUBLE )
   @ MAXROW(), 0 SAY PADC( WHAT_IT_DOES,;
                           MAXCOL() + 1) COLOR MSG_ROW_CLR

   // STEP 1
   oBrow := TBROWSEDB( 3, 7, MAXROW() - 3, MAXCOL() - 8 )
   oBrow:colSep    := COLSEP
   oBrow:headSep   := HEADSEP
   oBrow:footSep   := FOOTSEP
   oBrow:colorSpec := CLR_SPEC

   // STEP 2
   // To be honest I do not like commands
   // but you should be flexible enough...
   //
   ADD COLUMN test->fld1 TO oBrow HEADING Field 1
   ADD COLUMN test->fld2 TO oBrow HEADING Field 2
   ADD COLUMN test->fld3 TO oBrow HEADING Field 3
   ADD COLUMN test->fld4 TO oBrow HEADING Field 4
   ADD COLUMN TRANSFORM(test->fld5, "99,999.99" ) ;
              TO oBrow HEADING Field 5
   ADD COLUMN test->fld6 TO oBrow HEADING Field 6
   ADD COLUMN test->fld7 TO oBrow HEADING Field 7
   ADD COLUMN test->fld8 TO oBrow HEADING Field 8

   WHILE .T.
      // Regular color
      oBrow:colorRect({oBrow:rowPos,  oBrow:freeze + 1,;
                       oBrow:rowPos, oBrow:colCount}, {1, 1})

      // STEP 3
      ForceStable(oBrow)

      // Bar color
      oBrow:colorRect({oBrow:rowPos, oBrow:freeze + 1,;
                   oBrow:rowPos, oBrow:colCount}, {7, 2})
      oBrow:hilite()

      IF ( oBrow:hitTop .OR. oBrow:hitBottom )
         TONE(87.3,1)
         TONE(40,3.5)

      ENDIF

      BrowHorizScrollBar( oBrow, MAXROW() - 2,;
                                   7, MAXCOL() - 8)


      // STEP 4
      nKey := INKEY(0)         

      IF !TBMoveCursor( nKey, oBrow )
         IF ( nKey == K_ESC )
            SCROLL()
            EXIT

         ENDIF

      ENDIF

   END

   RETURN (NIL)

/*****
 *
 * Horizontal Scroll Bar
 *
 * BrowHorizScrollBar(<oObj>, <nBottom>, <nLeft>, <nRight>) --> NIL
 *
 */

STATIC FUNCTION BrowHorizScrollBar(oObj, nBottom, nLeft, nRight)
   STATIC lIsStart := .T.
   STATIC nWindow, nInitPos, nNewPos

   DISPBEGIN()
   // First time
   IF lIsStart
      lIsStart := .F.
      nWindow  := nRight - nLeft
      nInitPos := 0
      DISPBOX(nBottom, nLeft, nBottom, nRight, CHR(219),;
              BAR_CLR)
      @ nBottom,nLeft SAY CHR(219) COLOR BRICK_CLR

   ENDIF

   // Update Bar Gauge
   nNewPos := nWindow / (oObj:colCount / oObj:colPos)
   IF ( oObj:colPos == 1 )
      nNewPos := 0

   ELSEIF ( oObj:colCount == oObj:colPos )
      nNewPos := nWindow

   ENDIF

   IF ( nInitPos != nNewPos )
      @ nBottom,nLeft + nInitPos SAY ;
                   CHR(219) COLOR BAR_CLR
      @ nBottom,nLeft + nNewPos  SAY ;
                   CHR(219) COLOR BRICK_CLR
      nInitPos := nNewPos

   ENDIF
   DISPEND()
   RETURN (NIL)

// EOF - TBR13.PRG //
