/*****
 *
 * TBR11.PRG
 * Shifting between indexes
 * Seek with TBrowse
 *
 */

#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"

#include "tbrowse.ch"
#include "samples.ch"

#define        WHAT_IT_DOES        "ESC - Quit          RIGHT,LEFT - "+;
                                   "Change active index" +;
                                   "           " +;
                                   "ALT_S - Seek"

FUNCTION Tbr11()
   LOCAL oBrow, oCol, nKey
   LOCAL nTemp, nRecNo, nCnt
   LOCAL cSearch
   LOCAL GetList := {}

   SET(_SET_PATH, WHERE_TO_FIND_FILES)

   DBUSEAREA( NEW, "DbfNtx", "test" )

   // Temporary index
   INDEX ON STR(test->fld4, 5) TO test4

   DBCLEARINDEX()
   DBSETINDEX( "test3" )
   DBSETINDEX( "test7" )
   DBSETINDEX( "test4" )

   SETCURSOR(SC_NONE)

   SETBLINK(.F.)
   SETCOLOR(BGND_CLR)
   SCROLL()
   SETCOLOR(BROW_CLR)       
   SCROLL( 2, 6, MAXROW() - 2,  MAXCOL() - 7 )
   DISPBOX( 2, 6, MAXROW() - 2, MAXCOL() - 7, B_DOUBLE )
   @ MAXROW(), 0 SAY PADC( WHAT_IT_DOES,;
                           MAXCOL() + 1) COLOR MSG_ROW_CLR

   // STEP 1
   oBrow := TBROWSEDB( 3, 7, MAXROW() - 3, MAXCOL() - 8 )
   oBrow:colSep    := COLSEP
   oBrow:headSep   := HEADSEP
   oBrow:footSep   := FOOTSEP
   oBrow:colorSpec := CLR_SPEC

   // STEP 2
   oCol := TBCOLUMNNEW( HEAD_3, {|| test->fld3} )
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_7, {|| test->fld7} )
   oBrow:addColumn( oCol )
   
   oCol := TBCOLUMNNEW( HEAD_4, {|| test->fld4} )
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( WHICH_REC, {|| RECNO()} )
   oBrow:addColumn( oCol )

   nTemp := 0
   WHILE .T.
      IF (nTemp != oBrow:colPos) .AND.;
         (oBrow:colPos >= 1 .AND. oBrow:colPos <= oBrow:colCount)
         nTemp := oBrow:colPos
         // Switch Indexes
         nRecNo := RECNO()
         // Reset all column colors
         FOR nCnt := 1 TO oBrow:colCount
            oCol := oBrow:getColumn( nCnt )
            oCol:defColor := {1, 2}

         NEXT

         DISPBEGIN()
         // Switch indexes (or no indexes)
         DBSETORDER( IF(INDEXKEY(oBrow:colPos) == "",;
                                   0, oBrow:colPos) )
         // Different color for the current column
         // This means the current key (or no key
         // if the file is not indexed)
         oCol := oBrow:getColumn( oBrow:colPos )
         oCol:defColor := {8, 2}

         oBrow:configure()
         oBrow:refreshAll()
         ForceStable(oBrow)
         //
         // As you already know, 
         // TBrowse has that behaviour ...
         //
         DBSKIP(0)
         WHILE (nRecNo != RECNO()) .AND. !(oBrow:hitTop())
            oBrow:up()
            ForceStable(oBrow)

         END
         DISPEND()

      ENDIF

      // STEP 3
      ForceStable(oBrow)

      IF (oBrow:hitTop .OR. oBrow:hitBottom )
         TONE(87.3,1)
         TONE(40,3.5)

      ENDIF

      // STEP 4
      nKey := INKEY(0)    

      IF !TBMoveCursor( nKey, oBrow )
         IF ( nKey == K_ESC )
            SCROLL()
            EXIT

         ELSEIF ( nKey == K_ALT_S )
            IF oBrow:colPos < FORBIDDEN_PLACE
               cSearch := SPACE(LEN(&(INDEXKEY(INDEXORD()))))
               // Placing the prompt over the TBrowse
               // window area will make unnecessary
               // to save the screen
               //
               DISPBOX( 9, 8, 11, 40, REPLICATE(CHR(32), 9), BGND_CLR )
               PushSets()
               SETCURSOR(SC_NORMAL)
               @ 10,10 SAY SEARCH_WHAT COLOR BGND_CLR;
                       GET cSearch ;
                       PICTURE "@S20" COLOR MENU_CLR
               READ
               PopSets()
               cSearch := TRIM(cSearch)
               SeekIt( cSearch ,, oBrow )

            ENDIF

         ENDIF

      ENDIF

   END

   // Erase temporary file
   FERASE( "test4.ntx" )
   RETURN (NIL)

/*****
 *
 * SeekIt(<xKey>, <lSoftSeek>, <oBrowse>) --> lFound
 *
 */

FUNCTION SeekIt( xKey, lSoftSeek, oObj )
   LOCAL lFound, nRecNo

   nRecNo    := RECNO()
   lSoftSeek := IF(VALTYPE(lSoftSeek) == "L", lSoftSeek, .F.)

   IF !(lFound := DBSEEK( xKey, lSoftSeek ))
      IF EOF()
         // Not found.
         // Keep pointer in the same place
         DBGOTO(nRecno)
         oObj:invalidate()

      ELSE
         // Not Found but, SoftSeek is on!
         // But there is that behaviour on TBrowse...
         //
         SetHilite(oObj)

      ENDIF

   ELSE
      // Found!
      // But there is that behaviour on TBrowse...
      //
      SetHilite(oObj)

   ENDIF

   RETURN (lFound)

/*****
 *
 * SetHilite(<oBrowse>) --> .T.
 *
 * Puts the hilite in the correct place
 *
 */

FUNCTION SetHilite(oObj)
   LOCAL nRecNo := RECNO()

   DISPBEGIN()
   oObj:refreshAll()
   ForceStable( oObj )
   WHILE (nRecNo != RECNO()) .AND. !(oObj:hitTop())
      oObj:up()
      ForceStable( oObj )

   END
   DISPEND()

   RETURN (.T.)

// EOF - TBR11.PRG //

