/*****
 *
 * TBR04.PRG
 * TBColumn:colorBlock and TBrowse:colorSpec
 * Uses forced stabilization
 * 
 */

// Include Header Files
#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"

#include "tbrowse.ch"
#include "samples.ch"

FUNCTION Tbr4()
   LOCAL oBrow, oCol, nKey

   // Settings
   SET(_SET_PATH, WHERE_TO_FIND_FILES)

   // Open files
   DBUSEAREA( NEW, "DbfNtx", "test" )
   DBSETINDEX( "test3" )

   // Cursors are for GETs, so turn it off
   // The SC_XXXX contants are defined in setcurs.ch
   SETCURSOR(SC_NONE)

   SETBLINK(.F.)
   SETCOLOR(BGND_CLR)
   SCROLL()
   SETCOLOR(BROW_CLR)       
   SCROLL( 2, 6, MAXROW() - 2, MAXCOL() - 7 )
   DISPBOX( 2, 6, MAXROW() - 2, MAXCOL() - 7, B_DOUBLE )

   // STEP 1
   oBrow := TBROWSEDB( 3, 7, MAXROW() - 3, MAXCOL() - 8 )
   oBrow:colSep  := COLSEP
   oBrow:headSep := HEADSEP
   oBrow:footSep := FOOTSEP
   // Now, we will use some color to TBrowse
   // Use the instance variable colorSpec, which contains a
   // character string defining a color table to the browse
   // display.
   // As a default, the current SETCOLOR() is copied into this 
   // variable
   // As a matter of fact some of my color preferrences
   // are a disaster
   oBrow:colorSpec := CLR_SPEC

   // STEP 2
   oCol := TBCOLUMNNEW( HEAD_1, {|| test->fld1} )
   oCol:footing := FOOT_FIRST
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_2, {|| test->fld2} )
   oBrow:addColumn( oCol )
   
   oCol := TBCOLUMNNEW( HEAD_3, {|| test->fld3} )
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_4, {|| test->fld4} )
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_5, {|| test->fld5} )
   oCol:footing := FOOT_LAST
   oCol:colorBlock := {|xBlockParm| ;
                       IF(xBlockParm > 4, { 6, 2 }, {1, 2}) }
   // This instance variable contains an optional code block
   // that determines the color of data items as they are 
   // displayed. This block is evaluated each time a new value
   // is retrieved using TBColumn:block
   // The retrieved data value is passed as an argument to 
   // TBColumn:colorBlock, which must return an array 
   // containing two numeric values
   // The first determines the unselected
   // color which determines the color used to headings,
   // footings, etc.
   // It is also used to display values when the cursor is not
   // on the data value being displayed.
   // The second value determines the selected color which 
   // is used to display the current browse cell
   oBrow:addColumn( oCol )

   oBrow:freeze := 1

   WHILE .T.
      IF ( oBrow:colPos <= oBrow:freeze )
         oBrow:colPos := oBrow:freeze + 1

      ENDIF

      // STEP 3
      //
      // Forces stabilization
      // Doing this way it can't be interrupted
      //
      ForceStable(oBrow)

      IF ( oBrow:hitTop .OR. oBrow:hitBottom )
         TONE(87.3,1)
         TONE(40,3.5)

      ENDIF

      // Do something while waiting for a key
      WHILE ((nKey := INKEY(.5)) == 0)
         @  0, MAXCOL() - 9 SAY " " + TIME() + " "

      END

      // STEP 4
      IF !TBMoveCursor( nKey, oBrow )
         IF ( nKey == K_ESC )
            SCROLL()
            EXIT

         ENDIF

      ENDIF

   END
   RETURN (NIL)

/*****
 *
 * ^ForceStable(oBrowse) --> NIL
 *
 */

STATIC FUNCTION ForceStable(oBrowse)
   WHILE !oBrowse:stabilize()
   END
   RETURN (NIL)

// EOF - TBR04.PRG //
