* TAPCAL.PRG
*****************************************************************************
*                                                                           *
*  Author    : T_A_P                                                        *
*  Date      : 04/25/88                                                     *
*  Notes     : (C) Copyright 1987-88.  All rights reserved.                 *
*  Comment   : This procedure will display a calendar and allow user to     *
*              change month and year by pressing the arrow key.             *     
*              The reason I am not using UDF because I want this program    *
*              to work on any version of Clipper.                           *
*              If you have any comment, please let me know by send it to:   *
*                                                                           *
*              T_A_P                                                        *
*              12336 Inletridge  Apt. H                                     *
*              St. Louis, Mo. 63043                                         *
*                                                                           *
*****************************************************************************
*
set proc to TAPCAL
save screen
PUBL st_col,no_days
m_day=day(date())
m_month=month(date())
m_year=year(date())
*
do disp_cal                                                   && Display calendar
do disp_hdate with date()                                     && Display heading date
do find_col with ctod(str(m_month,2)+'/01/'+str(m_year,4))    && Find starting column
do disp_days with date()                                      && Display days
do while .t.
   key=inkey(0)
   if key=27
      clos proc
      rest screen
      rele all
      return
   endif
   do case
      case key=5                             && Up
         m_year=m_year-1
      case key=24                            && Down
         m_year=m_year+1
      case key=4                             && Right
         m_month=m_month+1
         if m_month>12
            m_month=1
            m_year=m_year+1
         endif
      case key=19                            && Left
         m_month=m_month-1
         if m_month<1
            m_month=12
            m_year=m_year-1
         endif
   endcase
*--- Check to see if the current date is the last day of the month.
   if m_day>=28 .and. m_day<=31 
      do last_day with m_month, m_year
      m_day=no_days
   endif
   m_date=ctod(str(m_month,2)+'/'+str(m_day,2)+'/'+str(m_year,4))
   do find_col with ctod(str(m_month,2)+'/01/'+str(m_year,4))
   do disp_hdate with m_date
   do clear_date with 2
   do disp_days with m_date
   loop
enddo
*
*
*
PROC DISP_CAL
*
SET COLOR TO W/N
SET COLOR TO +BG/N
@1,01,19,29 BOX "Ŀ "
@3,01 SAY ""
@3,29 SAY ""
@5,01 SAY ""
@5,29 SAY ""
@7,01 SAY ""
@7,29 SAY ""
@9,01 SAY ""
@9,29 SAY ""
@11,01 SAY ""
@11,29 SAY ""
@13,01 SAY ""
@13,29 SAY ""
@15,01 SAY ""
@15,29 SAY ""
@17,01 SAY ""
@17,29 SAY ""
@3,02 SAY ""
@4,05 SAY "               "
@5,02 SAY ""
@6,05 SAY "               "
@7,02 SAY ""
@8,05 SAY "               "
@9,02 SAY ""
@10,05 SAY "               "
@11,02 SAY ""
@12,05 SAY "               "
@13,02 SAY ""
@14,05 SAY "               "
@15,02 SAY ""
@16,05 SAY "               "
@17,02 SAY ""
SET COLOR TO +W/B
@2,02 SAY ""+space(27)+""
SET COLOR TO +R/B
@4,02 SAY "Sun"
@4,06 SAY "Mon"
@4,10 SAY "Tue"
@4,14 SAY "Wed"
@4,18 SAY "Thu"
@4,22 SAY "Fri"
@4,26 SAY "Sat"
SET COLOR TO +GR/B
@ 18,02 SAY ""+chr(27)+""+chr(26)+" Month  "+chr(24)+""+chr(25)+" Year  Esc:Exit"
return
*
*
PROC DISP_HDATE
PARA mdate
*
* Called from: TAPCAL
* Date       : 04/23/1987
* Comment    : This procedure will display the new heading date for the calendar.
*
set colo to rg+/b
@2,3 say space(25)
@2,5 say cmonth(mdate)
@2,col()+2 say day(mdate)
@2,col()+2 say year(mdate)
RETURN
*
*
PROC DISP_DAYS
PARA m_date
*
* Called from: TAPCAL
* Date       : 04/20/88
* Revised    : 06/15/88
* Comment    : This procedure will display the date on the calendar.
*
st_row=6
do last_day with month(m_date), year(m_date)
for x = 1 to no_days
  set colo to w
*--- If x=current day, display in reverse video.
  if x=day(m_date)
    set colo to n/w
  endif
  @st_row,st_col say str(x,2)
  st_col=st_col+4
  st_col=if(st_col>27,2,st_col)
  st_row=if(st_col=2,st_row+2,st_row)
next
return
*
*
PROC CLEAR_DATE
PARA st_col
*
* Called from : TAPCAL
* Date        : 04/20/87
*
st_row=6
no_days=42
set colo to w
for x = 1 to no_days
  @st_row,st_col say '  '
  st_col=st_col+4
  st_col=if(st_col>27,2,st_col)
  st_row=if(st_col=2,st_row+2,st_row)
next
return
*
*
PROC FIND_COL
PARA mdate
*
* Called from: TAPCAL
* Date       : 4/20/1987
* Comment    : This procedure will find the starting column's depend which day is the first
*              day of the month.
*
fst_day=dow(mdate)
c=2
for x=1 to 7
  if fst_day=x
    st_col=c
    exit
  endif
  c=c+4
next
return
*
*
PROC LAST_DAY
PARA mmonth,myear
*
*  Called from: DISP_DAYS(TAPCAL)
*  Date       : 04/20/88
*  Revised    : 06/15/88
*  Comment    : This procedure will find the maximum no. of days of a 
*               particular month.
*
if mmonth=2
   no_days=if(int(myear/4)=myear/4,29,28)
   return
endif
no_days=if(str(mmonth,2)$' 1 3 5 7 8 10 12',31,30)
return
*
*
*

