/* tagprg.c 1.1 - Create TAGS file for Brief TAG Macro for Clipper *.PRGs	*/
/*                Donated to the world of public domain by:						*/
/*                    Mike Draper														*/
/*                    1073 Old Colony Road											*/
/*                    Kingston, Ontario K7P 1M3   613-389-9557					*/

/*                Please feel free to do whatever you like with this			*/
/*                program.																	*/

/*                Version 1.1 clears up a few extraneous entries in the		*/
/*                TAG file.   January 26, 1989										*/

#include <stdio.h>		/* To use: TAGPRG [filename]								*/
#include <stdlib.h>		/* where 'filename' is a reference to Clipper type	*/
#include <conio.h>		/*       program files. (eg ACC*.PRG)					*/
#include <ctype.h>		/*	If no 'filename' is specified the default name	*/
#include <dos.h>			/*  *.PRG is used.											*/
#include <dir.h>
#include <io.h>			/* The output files TAGS. works with the TAG macro	*/
#include <fcntl.h>		/* Tag file format:											*/
#include <string.h>		/* procname[tab]filename[tab]>searchstring			*/

#define true 1
#define false 0

void getword(char wd[], char ln[], int ii);	/* Get iith word ignore white */
int strcmpu(char *s1, char *s2);					/* Compare strings ignore case*/

void main(int argc, char *argv[])
{
	char line[256];									/* Input line						*/
	char word1[256];									/* First Word on line			*/
	char word2[256];									/* Second word on line			*/
	char fchar;											/* First non-white char			*/
	char fname[12];									/* Ambiguous file name			*/
	char infname[13];									/* Current input (.PRG) file	*/
	char infproc[13];									/* infname less .PRG				*/
	char outfname[] = "tags";						/* Output file name				*/
	struct ffblk ffblk;								/* For findfirst etc.		 	*/
	struct ffblk tmpblk;								/* For findfirst etc.		 	*/
	int done;											/* No more files?					*/
	int ncline;											/* First code line PROC/FUNC?	*/
	int i,k;												/* Utility ints					*/

	FILE *inf;											/* Input file						*/
	FILE *outf;											/* Output file						*/

	if (argc == 1)										/* No command line args			*/
		strcpy(fname,"*.prg");						/* Default is *.PRG				*/
	else
		strcpy(fname,argv[1]);						/* Use first command line arg	*/

	done = findfirst(fname,&ffblk,0);			/* Look for first matching	file*/

	if (done)											/* No matching files				*/
		{
		printf("No files like %s\n",fname);
		exit(1);
		}

	printf("\nTAGPRG Version 1.2\n------------------\n");

	i = 'N';

	if (!findfirst(outfname,&tmpblk,0))
		{
		printf("Append to current TAGS file? ");
		i = toupper(getch());
		printf("\n\n");
		}
	if (i == 'Y' || i == 'T')
		outf = fopen(outfname,"a");				/* Open TAGS for append			*/
	else
		outf = fopen(outfname,"w");				/* Open TAGS for output			*/

	while (!done)										/* Loop through files			*/
	   {
		strcpy(infname,(char *) &ffblk.ff_name);
	   
		inf = fopen(infname,"r");					/* Open input file				*/

		if (inf == NULL)								/* Open error (shouldn't be)	*/
			{
			printf("Error opening file %s\n",infname);
			exit(1);
			}

		printf("Processing file %s\n",infname);

		ncline = false;

	   while (fgets(line,254,inf) != NULL)		/* Read file line by line		*/
			{
			if (kbhit())								/* [Esc] to abort					*/
				{
				if (getch()  == 27)
					exit(0);
				}

			for (i = 0; (line[i] == ' ' || line[i] == '\t') &&
				line[i] != '\n';		   /* Skip white space		*/
				i++)
				;
			
			if (line[i] != '\n')			/* First non-whate character	*/
				fchar = line[i];

			if (line[i] == '*')			/* Comment line			*/
				continue;

			if (line[i] == '\n')			/* Blank line				*/
				continue;

			getword(word1,line,1);		/* First word				*/

			if (strcmpu(word1,"PROCEDURE") || strcmpu(word1,"FUNCTION") ||
				strcmpu(word1,"PROC") || strcmpu(word1,"FUNC"))
				{								/* PROCEDURE or FUNCTION	*/
				getword(word2,line,2);
				fprintf(outf,"%s\t%s\t<%s %s\n",word2,infname,word1,word2);
				}
			else if (!ncline)				 /* First word NOT PROC or FUNC	*/
				{
				for (k = 0; infname[k] != '.'; k++)
					infproc[k] = infname[k];
				infproc[k] = 0;
				fprintf(outf,"%s\t%s\t<%c\n",infproc,infname,fchar);
				}
			ncline = true;
			}
			fclose(inf);

			done = findnext(&ffblk);		/* Next file name			*/
	  	}
		fclose(outf);
}

int strcmpu(char *s1, char *s2)			/* Compare two strings up to 	*/
{													/* length of second				*/
	int i,ll;
	ll = strlen(s2);
	for (i = 0; i < ll; i++)
		if (toupper(*(s1++)) != toupper(*(s2++)))
			return(false);
	return(true);
}

void getword(char wd[], char ln[], int ii)	/* Get word ii from string	*/
{															/* wd - the word				*/
	int i;												/* ln - the string			*/
	for (i = 0; i < ii; i++)						/* ii - which word			*/
		{
		while (*ln == ' ' || *ln == '\t')
			ln++;
	
		while (*ln != ' ' && *ln != '\t' && *ln != '\n')
			{
			if (i + 1 == ii)
				{
				*wd++ = *ln;
				*wd = 0;
				}
			ln++;
			}
		}
}





