/* tagc.c 1.0 - */

#include <stdio.h>	
#include <stdlib.h>	
#include <conio.h>	
#include <ctype.h>	
#include <dos.h>		
#include <dir.h>
#include <io.h>		
#include <fcntl.h>	
#include <string.h>	

#define true 1
#define false 0
#define BACKSLASH 0x5c

typedef enum {T_WORD, T_BRACEEXP, T_COMMA, T_SEMI, T_PREPROCESS, 
	T_OPENPAREN, T_CLOSEPAREN, T_OPENBRACE, T_CLOSEBRACE, T_NL, 
	T_EOF} TOKEN;

void find_functions(void);
void print_defn_line(long line_start);
static TOKEN gettoken(char *word, long *line_start);

FILE *inf;											/* Input file						*/
FILE *outf;											/* Output file						*/
char infname[13];									/* Current input (C) file		*/

void main(int argc, char *argv[])
{
	char fname[12];									/* Ambiguous file name			*/
	char outfname[] = "tags";						/* Output file name				*/
	struct ffblk ffblk;								/* For findfirst etc.		 	*/
	struct ffblk tmpblk;								/* For findfirst etc.		 	*/
	int done;											/* No more files?					*/
	int i,k;												/* Utility ints					*/

	if (argc == 1)										/* No command line args			*/
		strcpy(fname,"*.c");							/* Default is *.c					*/
	else
		strcpy(fname,argv[1]);						/* Use first command line arg	*/

	done = findfirst(fname,&ffblk,0);			/* Look for first matching	file*/

	if (done)											/* No matching files				*/
		{
		printf("No files like %s\n",fname);
		exit(1);
		}

	printf("\nTAGC Version 1.0\n------------------\n");

	i = 'N';

	if (!findfirst(outfname,&tmpblk,0))
		{
		printf("Append to current TAGS file? ");
		i = toupper(getch());
		printf("\n\n");
		}
	if (i == 'Y' || i == 'T')
		outf = fopen(outfname,"a");				/* Open TAGS for append			*/
	else
		outf = fopen(outfname,"w");				/* Open TAGS for output			*/

	while (!done)										/* Loop through files			*/
	   {
		strcpy(infname,(char *) &ffblk.ff_name);
	   
		inf = fopen(infname,"r");					/* Open input file				*/

		if (inf == NULL)								/* Open error (shouldn't be)	*/
			{
			printf("Error opening file %s\n",infname);
			exit(1);
			}

		printf("Processing file %s\n",infname);

		find_functions();
		fclose(inf);
		done = findnext(&ffblk);		/* Next file name			*/
	}
	fclose(outf);
}


void find_functions(void)
{
	TOKEN	gettoken(),curr_token;
	enum	{NEUTRAL, NAME, FN_NAME, INPAREN, INBRACE, CHECK_DEFINE, 
		RECORD_DEFINE, PREPROCESSOR} state = NEUTRAL;
	char	word[132],full_path[255],function[132];
	long	line_start,defn_start;	/* ftell() of the procedure line */
	int	paren_cnt,brace_cnt;

	getcwd(full_path, sizeof(full_path));
	while ((curr_token = gettoken(word, &line_start)) != T_EOF) 
	    switch((int) state) {
	    	/* The "home" state. If a "word" is found, assume that it is
		   a procedure name. If T_PREPROCESS, look for #define names
		   and toss the rest of the line since macro definitions look 
		   like procedures. If an open brace is found, start gobbling 
		   up the text contained within the braces. Keep a brace count 
		   to handle nested braces. */
		case NEUTRAL:
			switch ((int) curr_token) {
				case T_WORD:
					state = NAME;
					/* Note that the parens may start on
					   the next line, so store the offset
					   now. */
					defn_start = line_start;
					continue;
				case T_PREPROCESS:
					state = CHECK_DEFINE;
					defn_start = line_start;
					continue;
				case T_OPENBRACE:
					state = INBRACE;
					brace_cnt = 1;
					continue;
				default:
					continue;
				}
		/* All subsequent "word"s will be assumed to be the real
		   function name until an open paren is found. If something
		   other than a word or paren is found, then this wasn't
		   a function name after all. */
		case NAME:
			switch ((int) curr_token) {
				case T_WORD:
				case T_NL:
					defn_start = line_start;
					continue;
				case T_OPENPAREN:
					state = INPAREN;
					strcpy(function, word);
					paren_cnt = 1;
					continue;
				default:
					state = NEUTRAL;
					continue;
				}
		/* Eat up all the stuff within parens until the close paren
		   is found. Keep a counter to handle nested parens. */
		case INPAREN:
			switch ((int) curr_token) {
				case T_OPENPAREN:
					paren_cnt++;
					continue;
				case T_CLOSEPAREN:
					if (--paren_cnt == 0)
						state = FN_NAME;
					continue;
				default:
					continue;
				}
		/* If a comma or a semicolon is found, then this was a false
		   alarm. If an opening brace or another word is found, then
		   we found a procedure definition. */
		case FN_NAME:
			switch ((int) curr_token) {
				case T_COMMA:
				case T_SEMI:
					state = NEUTRAL;
					continue;
				case T_NL:
					continue;
				case T_OPENBRACE:
					state = INBRACE;
					brace_cnt = 1;
					fprintf(outf,"%s\t%s\\%s\t", function, full_path, infname);
					print_defn_line(defn_start);
					continue;
				default:
					state = NEUTRAL;
					fprintf(outf,"%s\t%s\\%s\t", function, full_path, infname);
					print_defn_line(defn_start);
					continue;
				}
		/* Loop until the closing brace is found. Keep a counter to
		   handle nested braces. */
		case INBRACE:
			switch((int) curr_token) {
				case T_OPENBRACE:
					brace_cnt++;
					continue;
				case T_CLOSEBRACE:
					if (--brace_cnt == 0) 
						state = NEUTRAL;
					continue;
				default:
					continue;
				}
		/* Check preprocessor lines for #define statements */
		case CHECK_DEFINE:
			switch ((int) curr_token) {
				case T_WORD:
					if (0 == strcmp(word, "define"))
						state = RECORD_DEFINE;
					else state = PREPROCESSOR;
					continue;
				default:
					state = PREPROCESSOR;
					continue;
				}
		/* Record the defined name in the same way as function names */
		case RECORD_DEFINE:
			state = PREPROCESSOR; /* toss the rest */
			continue;
		/* Handle the preprocessor line until a new-line is found.
		   The tokenizer tosses escaped new lines. */
		case PREPROCESSOR:
			switch ((int) curr_token) {
				case T_NL:
					state = NEUTRAL;
					continue;
				default:
					continue;
				}
		}
	}



static TOKEN gettoken(char *word, long *line_start)
{
	enum {NEUTRAL, INQUOTE, INSQUOTE, INWORD, INCOMMENT} 
		state = NEUTRAL;
	static int	col_count = 0;
	int	c,
		c2;
	char	*w;

	w = word;
	while ((c = getc(inf)) != EOF) {
		/* Keep a column count to aid in finding preprocessor lines.
		   Keep the ftell() of the start of the line for use when a
		   source line is to be printed. */
		if (c == '\n') {
			col_count = 0;
			*line_start = ftell(inf);
			}
		else col_count++;

		switch((int) state) {
			/* The "home" state. Quoted strings and comments are
			   stripped. Words consisting of letters, digits and
			   the underscore are gathered. */
			case NEUTRAL:
				switch(c) {
					case '(':
						return T_OPENPAREN;
					case ')':
						return T_CLOSEPAREN;
					case '#':
						if (col_count == 1)
							return T_PREPROCESS;
						continue;
					case '\n':
						return T_NL;
					case '"':
						state = INQUOTE;
						continue;
					case '\'':
						state = INSQUOTE;
						continue;
					case '{':
						return T_OPENBRACE;
					case '}':	/*}*/
						return T_CLOSEBRACE;
					case '/':	/* start of comment? */
						if ((c2 = getc(inf)) == '*') {
							state = INCOMMENT;
							col_count++;
							continue;
							}
						else {
							ungetc(c2, inf);
							continue;
							}
					case ';':
						return T_SEMI;
					case ',':
						return T_COMMA;
					case BACKSLASH:
						getc(inf);
						continue;
					default:
						if (isalnum(c) || c == '_') {
							state = INWORD;
							*w++ = c;
							}
						continue;
					}
			/* Stay in this state, tossing characters, until the
			   closing marker. */
			case INCOMMENT:
				switch(c) {
					case '*':	/* end of comment? */
						if ((c2 = getc(inf)) == '/') {
							state = NEUTRAL;
							col_count++;
							continue;
							}
						else {
							ungetc(c2, inf);
							continue;
							}
					default:
						continue;
					}
			case INQUOTE:
				switch(c) {
					case '"':
						state = NEUTRAL;
						continue;
					case BACKSLASH:
						getc(inf);
						continue;
					default:
						continue;
					}
			case INSQUOTE:
				switch(c) {
					case '\'':
						state = NEUTRAL;
						continue;
					case BACKSLASH:
						getc(inf);
						continue;
					default:
						continue;
					}
			/* Gather up the word. */
			case INWORD:
				if (isalnum(c) || c == '_') {
					*w++ = c;
					continue;
					}
				else	{
					ungetc(c, inf);
					*w = NULL;
					col_count--;
					return T_WORD;
					}
			}
		}
	
	return T_EOF;
	}

void print_defn_line(long line_start)
{
	long	current_position;
	int	c;

	current_position = ftell(inf);
	fseek(inf, line_start, SEEK_SET);

	fprintf(outf,"<");
	while ((c = getc(inf)) != EOF && c != '\n') putc(c,outf);
	fprintf(outf,"\n");

	fseek(inf, current_position, SEEK_SET);
	}




