* Program   :TblDemo.prg
* Author    :Mark D. Miller
* Date      :12-Nov-1992
* Notice    : Copyright (c) 12-Nov-1992 by Mark D. Miller
*             All Rights Reserved.
* Notes     :Demo of the field table routines.
*
* The includes
*
#INCLUDE Table.hdr
#INCLUDE IO.HDR
#INCLUDE STRING.HDR
#INCLUDE SYSTEM.HDR
#INCLUDE KEYS.HDR
#INCLUDE COLORS.HDR
#INCLUDE DATABASE.HDR
*
* FORCE externs
*
VARDEF  EXTERN
    BYTE        __color_std
    BYTE        __color_enhcd
ENDDEF
*
* Table Library externs
*
VARDEF  EXTERN
    CHAR( 40 )      TblPath
ENDDEF
*
* The database definition
*
DBFDEF Demo
    CHAR( 20 )      Name
    CHAR( 1 )       Sex
    CHAR( 1 )       Eeoc
    CHAR( 2 )       State
    CHAR( 4 )       Program
ENDDEF

VARDEF
    CHAR( 20 )      Demo_Name
    CHAR( 1 )       Demo_Sex
    CHAR( 1 )       Demo_Eeoc
    CHAR( 2 )       Demo_State
    CHAR( 4 )       Demo_Program
ENDDEF

INDEXDEF
    CHAR( 20 )  DemoIdx UPPER( Demo->Name )
ENDDEF

**********************************************************************
*           T H E    C O D E                                         *
**********************************************************************
PROCEDURE Force_Main
    VARDEF
        UINT    ky
    ENDDEF

    SET CONFIRM ON
    *
    * Set the path to the tables here
    *
    TblPath = "C:\FORCE\SOURCE\TABLE\"
    *
    * Establish aliases
    *
    SET ALIAS DemoIdx TO "TBLSAMP.FDX"
    SET ALIAS Demo    TO "TBLSAMP.DBF"
    *
    * Open Files
    *
    OPEN "TBLSAMP" ALIAS Demo
    IF .NOT. EXIST( "TBLSAMP.FDX" )
        !Demo INDEX "TBLSAMP.FDX" ALIAS DemoIdx
    ENDIF
    *
    * Draw the screen
    *
    __color_std = &blue_yellow
    CLEAR
    __color_std = &RED_WHITE
    @  1, 26  SAY "Field Table Demo"
    __color_std = &blue_yellow
    @  3,  2  SAY "The routines function by trapping the TAB key on any of the four fields"
    @  4,  2  SAY "below.  You set up the Field Tables at compile time and the actual table"
    @  5,  2  SAY "data may be developed and modified at run-time."
    @  7,  2  SAY "The only requirement to use these routines is: The GET variable must be a"
    @  8,  2  SAY "GLOBAL CHAR of not more than 4 characters.  Note that here I show CHAR(1),"
    @  9,  2  SAY "CHAR(2) and CHAR(4) vars."
    @ 12, 16  SAY "See the file TABLE.DOC for more information."

    @ 15, 21  SAY "Name:"
    @ 17,  3  SAY "Sex:"
    @ 17, 21  SAY "Race:"
    @ 17, 53  SAY "State:"
    @ 19, 18  SAY "Program:"
    *
    * Draw f-keys on line 24 so we can show that errors save line 24
    *
    __color_std = &white_black
    @ 24, 00  SAY CENTER( "Use These Keys: PgUp = Prev | PgDn = Next | ESC = Quit ", 80 )
    __color_std = &blue_yellow
    *
    * Main Loop
    *
    DO WHILE .T.
    *
        * Load vars
        *
        Demo_Name   = Demo->Name
        Demo_Sex    = Demo->Sex
        Demo_Eeoc   = Demo->Eeoc
        Demo_State  = Demo->State
        Demo_Program= Demo->Program
        *
        * Show current table values
        *
        ShowTable( "SEX", 17, 10, 6, Demo_Sex )
        ShowTable( "EEOC", 17, 29, 15, Demo_Eeoc )
        ShowTable( "STATE", 17, 63, 15, Demo_State )
        ShowTable( "PROGRAM", 19, 32, 30, Demo_Program )
        @ 15, 27  GET  Demo_Name
        @ 17,  8  GET  Demo_Sex PICTURE "!";
                  FILTER Table( "SEX", 17, 10, 6, Demo_Sex ) ;
                  VALID VerifyTable( "SEX", 17, 10, 6, Demo_Sex )
        @ 17, 27  GET  Demo_Eeoc PICTURE "!";
                  FILTER Table( "EEOC", 17, 29, 15, Demo_Eeoc ) ;
                  VALID VerifyTable( "EEOC", 17, 29, 15, Demo_Eeoc )
        @ 17, 60  GET  Demo_State PICTURE "!!";
                  FILTER Table( "STATE", 17, 63, 15, Demo_State ) ;
                  VALID VerifyTable( "STATE", 17, 63, 15, Demo_State )
        @ 19, 27  GET  Demo_Program PICTURE "XXXX" ;
                  FILTER Table( "PROGRAM", 19, 32, 30, Demo_Program ) ;
                  VALID VerifyTable( "PROGRAM", 19, 32, 30, Demo_Program )
        READ
        !Demo REPLACE   Demo->Name WITH Demo_Name, ;
                        Demo->Sex  WITH Demo_Sex,  ;
                        Demo->Eeoc WITH Demo_Eeoc, ;
                        Demo->State WITH Demo_State,    ;
                        Demo->Program WITH Demo_Program

        ky = LASTKEY()
        DO CASE
            CASE ky = &K_ESC
                EXIT
            CASE ky = &K_PG_UP
                !Demo SKIP -1
                IF A_BOF( Demo )
                    !Demo GO TOP
                    ??CHR( 7 )
                ENDIF
            CASE ky = &K_PG_DOWN
                !Demo SKIP 1
                IF A_EOF( Demo )
                    !Demo GO BOTTOM
                    ??CHR( 7 )
                ENDIF
            OTHERWISE
        ENDCASE
    ENDDO

    CLOSE Demo
    *
    * Closing comments
    *
    CLEAR
    TEXT
        Thank you for reviewing these routines.  Feel free to incorporate
        these routines in your programs.  See the source for this program
        for details.

        All I ask is if you find these routines helpful, please consider
        making a contribution of $5.00 to:

                    Mark D. Miller
                    612 Fairview Blvd. Apt. RNW
                    Rockford, IL 61107
                    71054,3103

    ENDTEXT
    WAIT
    __color_std = &black_light_grey
    CLEAR
ENDPRO

*  EOF : TblDemo.prg