#include "c:\cl87\nandef.h"                /** include CLIPPER header files **/
#include "c:\cl87\extend.h"

#define ISALPHA(c)  ((c) >= 'a' && (c) <= 'z' || (c) >= 'A' && (c) <= 'Z')
#define UPPER(c)    ((c) >= 'a' && (c) <= 'z' ? (c) - 32 : (c))

#define BUFFER_SIZE 3072                   /** max size of return string  **/


/************************************************************************
*                                                                       *
*  Function SY_PRINT: Handles printer output.  Return the associate     *
*  string sequence required by the selected printer for the current     *
*  string                                                               *
*                                                                       *
*  Programmer : Sylvain Faust        Created : 07-26-88                 *
*                                                                       *
*  From       : Sylvain Faust Inc.                                      *
*               978 St-Rene Ouest #4                                    *
*               Gatineau, QUEBEC                                        *
*               J8P 7K7   CANADA                                        *
*  or                                                                   *
*               Sylvain Faust Inc.                                      *
*               9962 Christophe-Colomb                                  *
*               Montreal, QUEBEC                                        *
*               H2C 2T6   CANADA                                        *
*                                                                       *
*  Parameters : (printer array definition), (desired print string)      *
*  Syntax     : SY_PRINT( <expA>, <expC> )                              *
*                                                                       *
*  System Variables : none                                              *
*                                                                       *
*  Returns    : Converted print string according to array definition    *
*                                                                       *
*  Change History   :                                                   *
*     Date           Reason / Desciption                 Programmer     *
*  07-29-88    Add support to printer CONTROL sequence    S.Faust       *
*              above 255 (underline start/end bold start/end...)        *
************************************************************************/

CLIPPER SY_PRINT()

{
    Boolean error;                     /** for parameters validation check **/

    quant line_size;                   /** length of passed line to convert **/
    quant x;
    quant y;
    quant z;

    byte *line;
    byte *sequence;
    byte *code;                        /** start of allocated memory **/

    /** check if parameters OK? **/
    error = (PCOUNT != 2 || !ISARRAY(1) || ALENGTH(1) != 255 || !ISCHAR(2)  || _parclen(2) == 0);

    code = _exmgrab(BUFFER_SIZE);          /** memory allocation request **/
                                           /** 'code' will contain the return result **/

    if ( (!error) || (code) )              /** good parameter and enough memory **/
    {
        line       = _parc(2);             /** read print string **/
        line_size  = (quant)(_parclen(2)); /** get length of print string **/

        /** start scanning of source string **/
        z = 0;
        for (x = 0; x < line_size; x++)
        {
          sequence = _parc(1, line[x]);    /** get corresponding sequence from array **/

          /** put all char in sequence **/
          y = 0;
          for (y = 0; sequence[y] != NIL; y++)
          {
             code[z] = sequence[y];        /** add charactere sequence to code **/
             z++;
          }
        }
    }
    /** if no error, return converted string, else return empty string **/
    if (!error)
    {
        code[z] = NIL;                 /** end result string with NIL **/
        _retc(code);                   /** return result to calling CLIPPER program **/
    }
    else                               /** else ...  **/
        _retc("");                     /** return "" **/
    if (code)
       _exmback(code,BUFFER_SIZE);        /** release allocated memory if any **/
}
/**********************   EOF() _SY_PRIN.C   ******************************
**************************************************************************/
