{ Program : SYSCHECK.PAS

  Purpose : Insure that sufficient file handles and memory is available
            prior to running a Clipper program.  SYSCHECK is esp. useful
            for network Clipper apps.  An optional error log provides
            error tracking.

  Language: Turbo Pascal v4.0

  Author  : Vick Perry

  Date    : 1/5/91

  SYSCHECK is released into the public domain.
}

program syscheck;

uses
   Dos,
   Crt,
   Printer;

var
   req_handles   : word;      {number of file handles needed - parameter 1}
   req_memory    : word;      {amount of regular memory needed - parameter 2}
   userid        : string[20];{name of user - parameter 3}
   errorfile     : string[80];{filename/path for error file - parameter 4}
   avail_handles : word;      {number of file handles available}
   avail_memory  : word;      {amount of regular memory available}
   e_level       : byte;      {DOS ERRORLEVEL set upon exiting}


{bad parameters were passed to SYSCHECK - show the help screen}
procedure showhelp;
   begin
      writeln;
      writeln('Syntax :  SYSCHECK <handles> <memory> [<userid> [<errorfile>]');
      writeln;
      writeln('  where: <handles>   - Number of file handles required (256 max).');
      writeln('         <memory>    - Memory required (in kilobytes, 640 max).');
      writeln('         <userid>    - Optional - user ID to report to screen and');
      writeln('                       error file (max length = 20 characters).');
      writeln('         <errorfile> - Optional - path/name of error text file');
      writeln('                       (max length = 50 characters).');
      writeln;
      writeln('SYSCHECK returns the following DOS ERRORLEVEL codes:');
      writeln('');
      writeln('            0     File handles and memory are sufficient');
      writeln('            1     Not enough available file handles');
      writeln('            2     Not enough available memory');
      writeln('            3     Invalid parameters passed to SYSCHECK');
      writeln;
   end;

{check and load the command line parameters into global variables}
function good_para(p1,p2,p3,p4:string):boolean;
var
   code: integer;
begin
   good_para := false;
   if ((paramCount>0) and (length(paramstr(1))>0) and (length(paramstr(2))>0)) then
      begin
         val(paramstr(1),req_handles,code);
         if ((req_handles>=0) and (req_handles<=256) and (code=0)) then
            begin
               val(paramstr(2),req_memory,code);
               if ((req_memory>=0) and (req_memory<=256) and (code=0)) then
                  begin
                     good_para := true;
                     {load the userid and error file name, if any}
                     userid := paramstr(3);
                     errorfile := paramstr(4);
                  end;
            end;
      end;



   if (good_para = false) then
      e_level := 3
      showhelp;
   end;
end;





{=============================  MAIN PROGRAM ===========================}

begin
   {assign variables}
   req_handles   := 0;
   req_memory    := 0;
   userid        := '';
   errorfile     := '';
   avail_handles := 0;
   avail_memory  := 0;
   e_level       := 0;

   writeln;
   writeln('SYSCHECK is checking available file handles and memory');
   writeln;
   if (good_para(paramstr(1),paramstr(2),paramstr(3),paramstr(4))=true) then
{      avail_handles:=get_handles();
      avail_memory:=get_memory()
}
   end;
   halt(e_level);   {return an ERRORLEVEL code}
end.





