***
*   Langage : Clipper 5.0 VF
*   Auteur  : Philippe Bonnardel
*   Version : 1.0
*   Date    : 10/06/94
*   Objet   : Dterminer la prsence ou non du driver EMM386.EXE en mmoire
*           : et dtecter le commutateur 'NOEMS' responsable d'un "plantage"
*           : des applications crites en Clipper.
*   Compil  : /M/L/N/W
*   Lien    : Avec 3 programmes de la librairie 'Nanfor' de Glenn Scott
*           :   - Peek.c        (Compil. : BCC -ml -c peek.c  )
*           :   - cInt86.c      (Compil. : BCC -ml -c cint86.c)
*           :   - aint86.asm    (Compil. : TASM aint86.asm    )
*   Autre   : Ncessite les fichiers :
*           :   - cint86.h     
*           :   - ftint86.ch   // Dfinitions pour 'ft_int86()'
*           :   - emm.ch       // Dfinitions pour l'tat du driver
*   Return  : Une valeur numrique correspondant  l'tat du driver
*
* Remarques : Programme test sur quelques machines, fiabilit  dmontrer...
*           : A charger dans les premires instructions de l'application
*           : Si 'NOEMS'==> Message  l'utilisateur (par ? et ??) et sortie
***

#include "ftint86.ch"
#include "ems.ch"

#define INT_21h      33
#define FUNC_35h     53
#define FUNC_67h     103

FUNCTION EMS()
LOCAL i, cMem, aRegs, nRet

aRegs := ARRAY(10)
aRegs[AX] := FUNC_35h * 256 + FUNC_67h

IF FT_INT86 (INT_21h, aregs)
    cMem := ""
    FOR i := 0 TO 7
        cMem += CHR(FT_PEEK(aRegs[ES], 10 + i))
    NEXT
    IF cMem == "EMMXXXX0"
        nRet := OK_EMM
    ELSEIF cMem == "$MMXXXX0"
        nRet := NOEMS_NOVCPI
    ELSEIF cMem == "EMMQXXX0"
        nRet := NOEMS
    ELSE
        nRet := NO_EMM
    ENDIF
ELSE
    nRet := INT_ERROR
ENDIF
RETURN (nRet)

