#include "box.ch"
#include "dialog.ch"

FUNCTION MAIN()
LOCAL aTab, aValue, aMes, cOldColor := SETCOLOR("N/W")

CLEAR SCREEN
@ 1, 0, 24, 79 box REPLICATE ("", 9)
SETCOLOR ("W+/B")
@ 0, 0 SAY PADC("- Filtre interactif - P. Bonnardel - Clipper 5.x", 80)

IF FILE ("CP.DBF")     
	USE CP NEW
	IF !FILE ("COMMUNE.NTX")
		WaitMsg ("Indexation en cours~...", "G+/B, W+/B")
			 INDEX ON LEFT(FIELD->COMMUNE, 8)  TO COMMUNE
			 INDEX ON FIELD->CODEPOST          TO CP
			 INDEX ON LEFT(FIELD->BUREAU, 10)  TO BUREAU
		WaitMsg ()
	ENDIF
	SET INDEX TO COMMUNE, CP, BUREAU

******************************************************************************
* 1er exemple

	aTab := {{"COMMUNE"  , "Commune"     , 1, 8, "VAL"  , "@!"    },;
		 {"CODEPOST" , "CP"          , 2, 6, ""     , "999999"}}

	aValue := InterFilt (aTab, "Dictionnaire", "CP", 45, 16, .F.)
									* la fonction InterFilt est situe et dcrite
									* dans le programme INTERACT.prg
	Result (aValue)

******************************************************************************
				SETCOLOR("GR+/N")
				@ 1, 0, 24, 79 box REPLICATE ("", 9)
******************************************************************************

* 2eme exemple

	atab := {{"CODEINSEE", "Codes INSEE"  , 0},;
		 {"COMMUNE"  , "Commune"      , 1, 8   , "LY"  , "@!"    },;
		 {"CODEPOST" , "CP"           , 2, 6   , "268" , "999999"},;
		 {"BUREAU"   , "Bureau"       , 3, 10  , ""    , "@!"    }}
	
	aValue := InterFilt (aTab, "Filtre Interactif", , 80, 20, .T.)
									* la fonction InterFilt est situe et dcrite
									* dans le programme INTERACT.prg

	Result (aValue)
*******************************************************************************

ELSE
	DIALOG (DG_ALERT, {"", "Base de donnes CP.DBF introuvable"},; 
		" Problme ", OK)
ENDIF
USE
SETCOLOR (cOldColor)
CLS
RETURN(NIL)


STATIC FUNCTION Result (aValue)
LOCAL aMes
IF (aValue[1] == 0)
	DIALOG (DG_NOR, {"", "Aucun enregistrement slectionn"},;
		" Filtre Interactif ", OK)
ELSE
	IF (LEN(aValue) > 5)
		aMes := {"", "Slection de l'enregistrement n " + ;
					LTRIM(STR(aValue[1])),;
			 "", "Le nom du filtre tait " + RTRIM(aValue[2]),;
			 "", "Le filtre actif tait " + ;
					IF(EMPTY(aValue[3]), "vide", RTRIM(aValue[3])),;
			 "", "Le code INSEE est " + RTRIM(aValue[4]),;
			 "", "La commune est " + RTRIM(aValue[5]),;
			 "", "Le code postal est " + RTRIM(aValue[6]),;
			 "", "Le bureau est " + RTRIM(aValue[7])}
	ELSE         
		aMes := {"", "Slection de l'enregistrement n " + ;
					LTRIM(STR(aValue[1])),;
			 "", "Le nom du filtre tait " + RTRIM(aValue[2]),;
			 "", "Le filtre actif tait " + ;
					IF(EMPTY(aValue[3]), "vide", RTRIM(aValue[3])),;
			 "", "La commune est " + RTRIM(aValue[4]),;
			 "", "Le code postal est " + RTRIM(aValue[5])}
	ENDIF
	
	DIALOG (DG_NOR,  aMes, ;
		IF(LEN(aValue) > 3, " Filtre interactif ", " Dictionnaire "),; 
		OK)
ENDIF
RETURN (NIL)
