******************************************************************************
**
** Clipper 87 (Include.prg) file for the SilverWare SilverClip library.
**
** Copyright (C) 1991, SilverWare Inc.
**
**----------------------------------------------------------------------------
**
** This is the equivalent of the (slvrclip.ch) file that can be used with
** Clipper 87.  You may not want to include all the variables so make a 
** copy of this file and delete whatever you do not need.
**
** .or.
**
** You can simply put at the top of your main source program:
**
**			do slvrclip
**
** 			This will add all the definitions below to your
**			Clipper 87 application.  You may want to review
**			the information below and just use what is needed.
**
**----------------------------------------------------------------------------
**
** There are 3 functions in the SilverClip SPCS Library that cannot be directly
** called from Clipper 87.  These functions have been recreated in Clipper 87
** source code and are included in this file.
**
**	Note: Some parameters are pass by reference.
**
**	They are:
**
**		SWMGetResp(nPort, @cModemString, nWaitTime) -> nReturnCode
**
**		SWRXBuffer(nPort, @cBuffer, nMaxLength, nTerminator,;
**			   @nReturnLength) -> nReturnCode
**
**		SWRXString(nPort, @cBuffer, nMaxLength, nTerminator, nMaxTime,;
**			   lAbortNoCarrier, lEchoEnable, nEchoCharacter,;
**			   nLocalAbortKey) -> nReturnValue
**
**			   Important Note:
**
**				The nLocalAbortKey parameter in Clipper 5
**				is a ROM Bios scan code.  In Clipper 87 the
**				nLocalAbortKey will need to be an inkey()
**				value.  (ie. ESC = 27)
**
**----------------------------------------------------------------------------
**
** Important Note:
**
** Since the Clipper 87 source functions supplied are named the same as the
** SilverClip SPCS functions, you will need to use the /NOE switch on your 
** linker line to allow for duplicates.
**
**
******************************************************************************
******************************************************************************
**
** Constants for general use.
**
**

PUBLIC SWTRUE, SWFALSE, SWSECOND

SWTRUE		= .T.		&& Logical .T.
SWFALSE		= .F.		&& Logical .F. 
SWSECOND	= 18		&& 1 second value 


**
** Constants for COM ports.
**
**

PUBLIC COM1,  COM2,  COM3,  COM4,  COM5,  COM6,  COM7,  COM8
PUBLIC COM9,  COM10, COM11, COM12, COM13, COM14, COM15, COM16
PUBLIC COM17, COM18, COM19, COM20, COM21, COM22, COM23, COM24
PUBLIC COM25, COM26, COM27, COM28, COM29, COM30, COM31, COM32
PUBLIC COM33, COM34

COM1		= 0		&& COM1 port value 
COM2		= 1		&& COM2 port value 
COM3		= 2		&& COM3 port value 
COM4		= 3		&& COM4 port value 
COM5		= 4		&& COM5 port value 
COM6		= 5		&& COM6 port value 
COM7		= 6		&& COM7 port value 
COM8		= 7		&& COM8 port value 
COM9		= 8		&& COM9 port value 
COM10		= 9		&& COM10 port value 
COM11		= 10		&& COM11 port value 
COM12		= 11		&& COM12 port value 
COM13		= 12		&& COM13 port value 
COM14		= 13		&& COM14 port value 
COM15		= 14		&& COM15 port value 
COM16		= 15		&& COM16 port value 
COM17		= 16		&& COM17 port value 
COM18		= 17		&& COM18 port value 
COM19		= 18		&& COM19 port value 
COM20		= 19		&& COM20 port value 
COM21		= 20		&& COM21 port value 
COM22		= 21		&& COM22 port value 
COM23		= 22		&& COM23 port value 
COM24		= 23		&& COM24 port value 
COM25		= 24		&& COM25 port value 
COM26		= 25		&& COM26 port value 
COM27		= 26		&& COM27 port value 
COM28		= 27		&& COM28 port value 
COM29		= 28		&& COM29 port value 
COM30		= 29		&& COM30 port value 
COM31		= 30		&& COM31 port value 
COM32		= 31		&& COM32 port value 
COM33		= 32		&& COM33 port value 
COM34		= 33		&& COM34 port value 


**
** Constants for IRQs and Base I/O Addresses
**
**

PUBLIC IRQ2, IRQ3, IRQ4, IRQ5, IRQ6, IRQ7

IRQ2		= 2		&& Hardware Interrupt Request #2 
IRQ3		= 3		&& Hardware Interrupt Request #3 (COM2) 
IRQ4		= 4		&& IRQ #4 (COM1) 
IRQ5		= 5		&& IRQ #5 (Parallel Port 2) 
IRQ6		= 6		&& IRQ #6 (Diskette Controller) 
IRQ7		= 7		&& IRQ #7 (Parallel Port 1) 

**
** Note: IRQ 8-15 are only available on AT class machines.  Only IRQ9 through
** IRQ 12 and IRQ 14 through 15 are brought to the buss.  Also note that
** IRQ9-IRQ12 and IRQ14-IRQ15 are only available on the small 36 pin connector
**
**

PUBLIC IRQ8, IRQ9, IRQ10, IRQ11, IRQ12, IRQ13, IRQ14, IRQ15
PUBLIC COM1BASEIO, COM2BASEIO

IRQ8		= 8		&& IRQ #8 (Realtime Clock) 
IRQ9		= 9		&& IRQ #9 (IRQ 2 Redirection) 
IRQ10		= 10		&& IRQ #10 
IRQ11		= 11		&& IRQ #11 
IRQ12		= 12		&& IRQ #12 
IRQ13		= 13		&& IRQ #13 (Coprocessor) 
IRQ14		= 14		&& IRQ #14 (Fixed Disk Controller) 
IRQ15		= 15		&& IRQ #15 

COM1BASEIO	= 1016		&& Base Address of COM1 
COM2BASEIO	= 760		&& Base Address of COM2 


**
** NOTE: The default BASE I/O Address and IRQ number
** for COM3 through COM8 are for the standard IBM Dual Async Adapter/A.
** The IBM Dual Async Adapter/A is a Micro-Channel Board.
**

PUBLIC COM3BASEIO, COM4BASEIO, COM5BASEIO, COM6BASEIO, COM7BASEIO, COM8BASEIO

COM3BASEIO	= 12832		&& Base Address of COM3 
COM4BASEIO	= 12840		&& Base Address of COM4 
COM5BASEIO	= 16928		&& Base Address of COM5 
COM6BASEIO	= 16936		&& Base Address of COM6 
COM7BASEIO	= 21024		&& Base Address of COM7 
COM8BASEIO	= 21032		&& Base Address of COM8 



**
** Values for usOptions parameter in SWOpenCom() function
**
**

PUBLIC SWNOASDTR, SWNOASRTS, SWCUSEINT14INTERFACE

SWNOASDTR		= 1	&& Do not Assert DTR 
SWNOASRTS		= 2	&& Do not Assert RTS 
SWCUSEINT14INTERFACE	= 4	&& Use Int 0x14 Interface 	

**
** Values for nOptions parameter in SWCloseCom
**

PUBLIC SWASDTR, SWASRTS, SWDEASDTR, SWDEASRTS, SWNOFREE

SWASDTR		= 1		&& Assert DTR 
SWASRTS		= 2		&& Assert RTS 
SWDEASDTR	= 4		&& De-Assert DTR 
SWDEASRTS	= 8		&& De-Assert RTS 
SWNOFREE	= 16		&& Do not free() memory at close comm 

**
** Error return codes
**

PUBLIC SWCSUCCESSFUL, SWCINVALIDPARAMETER, SWCQUEUEISFULL, SWCQUEUEISEMPTY
PUBLIC SWCINVALIDPORT, SWCNOUARTPRESENT, SWCNOINTAVAILABLE, SWCNOINTSPECIFIED
PUBLIC SWCNOMEMORY, SWCTIMEDOUT, SWCABORT, SWCNOTFOUND, SWCNOCARRIER
PUBLIC SWCUNABLETOOPENFILE, SWCBADBLOCKCHECK, SWCNOREMOTERESPONSE
PUBLIC SWCLOCALABORT, SWCREMOTEABORT, SWCBADBLOCKNUMBER, SWCBLOCKFRAMINGERROR
PUBLIC SWCRECEIVEQUEUETOOSMALL, SWCEOTDETECTED, SWCMAXLENGTHREACHED
PUBLIC SWCTERMINATORREACHED, SWCQUEUEWENTEMPTY, SWCFEATURENOTAVAILABLE

SWCSUCCESSFUL		= 0	&& Successful 
SWCINVALIDPARAMETER	= -500	&& An invalid parameter was specified 
SWCQUEUEISFULL		= -499 	&& Attempted to insert a character to a full queue 
SWCQUEUEISEMPTY		= -498 	&& Attempted to remove a character from an empty queue 
SWCINVALIDPORT 		= -497 	&& An invalid port was specified when opening the port 
SWCNOUARTPRESENT	= -496	&& No UART present at specified I/O Address 
SWCNOINTAVAILABLE	= -495 	&& All hardware interrupts have been used 
SWCNOINTSPECIFIED	= -494	&& Attempted to open a port and no interrupt was specified 
SWCNOMEMORY		= -493 	&& Insufficient memory 
SWCTIMEDOUT		= -492 	&& Timed out 
SWCABORT		= -491	&& Function aborted 
SWCNOTFOUND		= -490	&& Not Found 
SWCNOCARRIER		= -489 	&& Carrier detect not asserted 
SWCUNABLETOOPENFILE	= -488 	&& Unable to open specified file 
SWCBADBLOCKCHECK	= -487 	&& Bad Block Check (CRC/CHECKSUM) 
SWCNOREMOTERESPONSE	= -486	&& No Response from remote 
SWCLOCALABORT		= -485 	&& Function aborted by local user 
SWCREMOTEABORT 		= -484 	&& Function aborted by remote user  
SWCBADBLOCKNUMBER	= -483 	&& Block Number is bad 
SWCBLOCKFRAMINGERROR	= -482 	&& Block Framing error 
SWCRECEIVEQUEUETOOSMALL	= -481 	&& Receive buffer not big enough 
SWCEOTDETECTED 		= -480 	&& EOT Detect during file receive 
SWCMAXLENGTHREACHED	= -479 	&& Maximum length reached 
SWCTERMINATORREACHED	= -478 	&& Terminator reached 
SWCQUEUEWENTEMPTY	= -477 	&& Queue Went Empty 
SWCFEATURENOTAVAILABLE	= -476	&& Feature Not Available 

**
** Constants for various types of Parity.
**
**

PUBLIC SWPARITYNONE, SWPARITYODD, SWPARITYEVEN, SWPARITYSTICK, SWPARITYMSTICK
PUBLIC SWPARITYMARK, SWPARITYSPACE

SWPARITYNONE		= 0	&& No Parity 
SWPARITYODD	      	= 8	&& Odd parity 
SWPARITYEVEN	      	= 24	&& Even parity 
SWPARITYSTICK	      	= 40	&& Mark parity 
SWPARITYMSTICK	      	= 56	&& Space parity 

SWPARITYMARK	      	= 40	&& Mark parity 
SWPARITYSPACE	      	= 56	&& Space parity 


**
** Constants for bits returned by the SWTXBlcked() function
**
**

PUBLIC TXWFORXON, TXWFORCTS, TXWFORDSR, TXWFORCARRDET, TXWFORMANUAL

TXWFORXON	= 1	&& Transmit Waiting for XON Character 
TXWFORCTS	= 2	&& Transmit Waiting for CTS to be asserted 
TXWFORDSR	= 4	&& Transmit Waiting for DSR to be asserted 
TXWFORCARRDET	= 8	&& Transmit Waiting for Carrier Detect 
TXWFORMANUAL	= 16	&& Transmit Waiting for Manual Enable 


**
** Constants for bits returned by the SWGFloStat() function
**
**

PUBLIC XONXOFFISENABLED, RTSCTSISENABLED, DTRDSRISENABLED, CARRDETISENABLED

XONXOFFISENABLED	= 1	&& XON/XOFF Flow Control Enabled 
RTSCTSISENABLED 	= 2	&& RTS/CTS Flow Control Enabled 
DTRDSRISENABLED 	= 4	&& DTR/DSR Flow Control Enabled 
CARRDETISENABLED	= 8	&& Carrier Detec Flow Control Enabled 



**
** Constants for modem on and off values.
**
**

PUBLIC SWCSMOFF, SWCSMON, SWCSMMODEPULSE, SWCSMMODETONE

SWCSMOFF	= "0" 	&& Smartmodem OFF (initialization) 
SWCSMON		= "1" 	&& Smartmodem ON (initialization) 

SWCSMMODEPULSE 	= 0
SWCSMMODETONE 	= 1

**
** Constants for video attributes.
**
**

PUBLIC SWBLACK, SWBLUE, SWGREEN, SWCYAN, SWRED, SWMAGENTA, SWBROWN
PUBLIC SWWHITE, SWBLINK, SWINTENSE

SWBLACK 	= 0	&& Black 
SWBLUE		= 1	&& Blue 
SWGREEN		= 2	&& Green 
SWCYAN		= 3	&& Cyan 
SWRED		= 4	&& Red 
SWMAGENTA	= 5	&& Magenta 
SWBROWN		= 6	&& Brown 
SWWHITE		= 7	&& White 
SWBLINK		= 128	&& Blinking 
SWINTENSE	= 8	&& High Intensity 


**
** Defines constants used to access the POS registers
** in a MicroChannel Configuration.
**
**

PUBLIC SWPOSREG0, SWPOSREG1, SWPOSREG2, SWPOSREG3, SWPOSREG4
PUBLIC SWPOSREG5, SWPOSREG6, SWPOSREG7, SWPOSMINCHANNEL, SWPOSMAXCHANNEL

SWPOSREG0	= 0	&& POS Register #0 (Adapter I.D. Low Byte) 
SWPOSREG1	= 1	&& POS Register #1 (Adapter I.D. High Byte) 
SWPOSREG2	= 2	&& POS Register #2 (Option Data Byte #1) 
SWPOSREG3	= 3	&& POS Register #3 (Option Data Byte #2) 
SWPOSREG4	= 4	&& POS Register #4 (Option Data Byte #3) 
SWPOSREG5	= 5	&& POS Register #5 (Option Data Byte #4) 
SWPOSREG6	= 6	&& POS Register #6 Subaddress Extension (Low Byte)  
SWPOSREG7	= 7	&& POS Register #7 Subaddress Extension (High Byte) 

SWPOSMINCHANNEL = 0	&& Minimum Channel Number 
SWPOSMAXCHANNEL = 7	&& Maximum Channel Number 

**
** POS Adapter Identification Constant for the IBM Dual Async Adapter
**

PUBLIC SWPOSIBMDUALASYNC

SWPOSIBMDUALASYNC	= 61183	&& IBM Dual Async Adapter 


**
** POS Adapter Identification Constants for DigiBoard
**

PUBLIC SWPOS16DIGIID, SWPOS8DIGIID, SWPOS4DIGIID

SWPOS16DIGIID	= 28644		&& Sixteen Channel Adapter 
SWPOS8DIGIID	= 28645		&& Eight Channel Adapter   
SWPOS4DIGIID	= 28646		&& Four Channel Adapter    
return




******************************************************************************
******************************************************************************
******************************************************************************
** 			                                                    **
** 			Recreated Functions()                               **
** 		                                                            **
******************************************************************************
******************************************************************************
******************************************************************************

** SWMGetResp(nPort, @cModemString, nWaitTime) -> nReturnCode
**
** Description
** 	This function gets a modem response string from the receive buffer.
**	Leading control characters are first removed from the receive queue.
**	The response string is then removed, trailing control characters are
**	removed from the string also.


FUNCTION SWMGetResp

PARAMETERS nPort, cModemString, nWaitTime

PRIVATE lLoopExit, lControlFlush, nCharCount, nInputChar, nTempTime
PRIVATE nTotalTime, nReturnValue, nTempTime, nMaxBufferSize

lLoopExit     = .F.			&& SWFALSE
lControlFlush = .T.			&& SWTRUE
nCharCount    = 0
nInputChar    = 0
nTempTime     = 0	
nTotalTime    = 0
nReturnValue  = 0
nTempTime     = SWGetSec()
nMaxBufferSize= 60

cModemString  = ""

do while !lLoopExit

   if nCharCount >= nMaxBufferSize
      nReturnValue = -479		&& SWCMAXLENGTHREACHED
      lLoopExit = .T.
      loop
   endif

   if nWaitTime > 0 .and. nTotalTime > nWaitTime
      nReturnValue = -492		&& SWCTIMEDOUT
      lLoopExit = .T.
      loop
   endif

   if nWaitTime > 0 .and. nTempTime != SWGetSec()
      nTempTime = SWGetSec()
      nTotalTime = nTotalTime + 1 
   endif

   if !SWRXEmpty(nPort)

      nInputChar = SWRXChar(nPort)
 
      if (!lControlFlush) .and. (nInputChar = 10 .or. nInputChar = 13)
	 nReturnValue = -478		&& SWCTERMINATORREACHED
  	 lLoopExit = .T.
  	 loop
      endif		

      if lControlFlush .and. nInputChar >= 32
         lControlFlush = .F.
      endif
	
      if !lControlFlush
         cModemString = cModemString + chr(nInputChar)
         nCharCount = nCharCount + 1 
      endif

   endif

enddo

RETURN nReturnValue



******************************************************************************
******************************************************************************
******************************************************************************


** SWRXBuffer(nPort, @cBuffer, nMaxLength, nTerminator, @nReturnLength) -> nReturnCode
**
** Description
**	Receive multiple characters from the receive buffer to a user
**	buffer.  Also monitors for a terminating character or maximum length
**	reached.  SWRXBuffer() will return when the terminator is
**	reached, maximum length is reached or if buffer is empty.

FUNCTION SWRXBuffer

PARAMETERS nPort, cBuffer, nMaxLength, nTerminator, nReturnLength

PRIVATE lLoopExit, nCharCount, nInputChar, nReturnCode

lLoopExit    = .F.
nCharCount   = 0
nInputChar   = 0
nReturnCode  = 0
cBuffer      = ""

if SWRXEmpty(nPort)
   nReturnCode = -498			&& SWCQUEUEISEMPTY
   lLoopExit = .T.
endif

do while !lLoopExit

   if nCharCount >= nMaxLength
      nReturnCode = -479		&& SWCMAXLENGTHREACHED
      lLoopExit = .T.
      loop
   endif


   if !SWRXEmpty(nPort)
      nInputChar = SWRXChar(nPort)
      cBuffer = cBuffer + chr(nInputChar)
      nCharCount = nCharCount + 1

      if (nTerminator != -1 .and. nInputChar = nTerminator)
 	 nReturnCode = -478		&& SWCTERMINATORREACHED
  	 lLoopExit = .T.
	 loop

      endif

   else
      lLoopExit = .T.
      nReturnCode = -477		&& SWCQUEUEWENTEMPTY
      loop

   endif
 
enddo

nReturnLength = nCharCount

RETURN nReturnCode


******************************************************************************
******************************************************************************
******************************************************************************


** SWRXString(nPort, @cBuffer, nMaxLength, nTerminator, nMaxTime, lAbortNoCarrier, lEchoEnable, nEchoCharacter, nLocalAbortKey) -> nReturnValue
**
** Description
**
**	Provides the capability for a remote user to input a string of
**	characters with backspace and editing.  Based on the parameters
**	passed to SWRXString(), several events can cause return
**	of this function, such as loss of carrier and timeout expired.  The
**	string that is updated by this function will include the terminating
**	character.  If echo is enabled, all received characters will be echoed
**	to the remote.

FUNCTION SWRXString
PARAMETERS nPort, cBuffer, nMaxLength, nTerminator, nMaxTime, lAbortNoCarrier, lEchoEnable, nEchoCharacter, nLocalAbortKey

PRIVATE lLoopExit, nCharCount, nInputChar, nTempTime, nTotalTime, nReturnValue

lLoopExit    = .F.
nCharCount   = 0
nInputChar   = 0
nTempTime    = 0 
nTotalTime   = 0
nReturnValue = 0
cBuffer      = ""

nTempTime = SWGetSec()

do while !lLoopExit

   if nCharCount >= nMaxLength
      nReturnValue = -479		&& SWCMAXLENGTHREACHED
      lLoopExit = .T.
      loop
   endif

   if lAbortNoCarrier .and. !SWGetCD(nPort)
      nReturnValue = -489		&& SWCNOCARRIER
      lLoopExit = .T.
      loop
   endif

   if nMaxTime > 0 .and. nTotalTime > nMaxTime
      nReturnValue = -492		&& SWCTIMEDOUT
      lLoopExit = .T.
      loop
   endif

   if nMaxTime > 0 .and. nTempTime != SWGetSec()
      nTempTime = SWGetSec()
      nTotalTime = nTotalTime + 1
   endif

   if !SWRXEmpty(nPort)

      nInputChar = SWRXChar(nPort)
      if nInputChar = 127
 	 nInputChar = 8
      endif

      if nInputChar < 32

         do case 
	    case nInputChar = 8		&& Back Space
	       if nCharCount > 0
		  nCharCount = nCharCount - 1
		  cBuffer = substr(cBuffer,1,len(cBuffer)-1)

 		  if lEchoEnable .or. (!lEchoEnable .and. nEchoCharacter > 0)
     	             SWTXChar(nPort,8)
		     SWTXChar(nPort,32)
		     SWTXChar(nPort,8)
                  endif

		else
		    SWTXChar(nPort,7)
		endif    

	    case nInputChar = 13
		 if lEchoEnable
	  	    SWTXChar(nPort,13)
		 endif
 		 cBuffer = cBuffer + chr(nInputChar)
		 nCharCount = nCharCount + 1

	 endcase

      else

         if lEchoEnable
   	    SWTXChar(nPort,nInputChar)
	 else
            if !lEchoEnable .and. nEchoCharacter > 0
	       SWTXChar(nPort,nEchoCharacter)
            endif
	 endif

	 cBuffer = cBuffer + chr(nInputChar)
	 nCharCount = nCharCount + 1

      endif 

      if nTerminator != -1 .and. nInputChar = nTerminator
    	 nReturnValue = -478		&& SWCTERMINATORREACHED
         lLoopExit = .T.
	 loop
      endif

   endif

   if nLocalAbortKey > 0 .and. inkey() = nLocalAbortKey
      nReturnValue = -485		&& SWCLOCALABORT
      lLoopExit =.T.
      loop
   endif

enddo

RETURN nReturnValue 

******************************************************************************
******************************************************************************
******************************************************************************

** EOF() slvrclip.prg

