#include "c:\clipper5\include\extend.h"

// swapstrs.c -- function to be called from Clipper 5.01 to
// directly replace portions of a string with new strings.
// See the accompanying file SWAPTEST.PRG for a calling example.
//
// Written by Keith Goldberg, released 04/23/1992. You may use this
// code for non-commercial use only, and use of this subroutine in
// your Clipper program implies your agreement that any such use
// is solely at your own risk. See the README.DOC file for more
// information.

#define	TRUE		1
#define	FALSE	0

CLIPPER swapstrs()
{
	char far *string, *srcptr;
	char far *ptr1, *ptr2;
	unsigned int ctr, ctr2, slen, sublen, alen1, alen2, offset;

	// First, initialize all numerics to zero.
	ctr = ctr2 = slen = alen1 = alen2 = sublen = offset = 0;


	// Check to see that you really got a string and two
	// arrays passed.
	if (_parinfo(1) != CHARACTER)
		_retl(FALSE);

	if (_parinfo(2) != ARRAY)
		_RETL(FALSE);

	if (_parinfo(3) != ARRAY)
		_RETL(FALSE);


	// Now, get the lengths and pointers of incoming parameters
	// as follows:
	// 	slen  = length of the master string.
	// 	alen1 = length of the first array (offsets for swaps).
	// 	alen2 = length of the second array (strings to swap).
	//	srcptr = far address of the master string.
	slen = _parclen(1);
	alen1 = _parinfa(2, 0);
	alen2 = _parinfa(3, 0);
	srcptr = _parc(1);

	// If the two arrays are not of equal length, or they have lengths
	// of less than one, then return FALSE.
	if (alen1 != alen2 || alen1 < 1)
		_retl(FALSE);

	// Now, attempt to allocate enough string space FROM CLIPPER to
	// make a copy to modify. Return a FALSE if no success.
	if ((string = _xalloc(slen+1)) == NULL)
		_retl(FALSE);
	else strcpy(string, srcptr);

	// Now, element by element, do a swap out of the string array.
	for (ctr = 1; ctr <= alen1; ctr++)
		{
		// Perform swap only if the types are valid.
		if (_parinfa(2,ctr) == NUMERIC && _parinfa(3,ctr) == CHARACTER)
			{
			offset = _parni(2,ctr);
			ptr1 = (char far *)(string + offset - 1);
			ptr2 = _parc(3, ctr);
			sublen = _parclen(3, ctr);

			// Perform the swap if there's no overlap.
			if (offset + sublen - 1 <= slen)
				{
				for (ctr2 = 1; ctr2 <= sublen; ctr2++)
					*ptr1++ = *ptr2++;
				}
			}

		}

	// Transfer a copy of the string to the caller. 
	_storclen(string, (unsigned int)strlen(string), 1);

	// Free up the associated memory.
	_xfree(string);

	_retl(TRUE);

}

