/*********************************************************************/
/**                                                                 **/
/** SUBSTRMEMO ()                                                   **/
/**                                                                 **/
/** Syntax: SUBSTRMEMO (<expC) [, <expN> [, <expN]] )               **/
/**                                                                 **/
/** Returns: A string containing the specified number of lines from **/
/**          a memo field.  The sub-portion of the memo field       **/
/**          starts with the first number specified and includes    **/
/**          all the lines up to and including the last number.     **/
/**          Useful if you must print a memo field that is more     **/
/**          than a page in length                                  **/
/**          If start > end, a nul string is returned               **/
/**                                                                 **/
/** Example: ? substrmemo (memofld, 3, 5) => return lines 3 to 5 of **/
/**                                          the field MEMOFLD      **/
/**          ? substrmemo (memofld, 8)    => returns the remainder  **/
/**                                          of the field MEMOFLD   **/
/**                                          starting at line 8     **/
/**          ? substrmemo (memofld, 7, 7) => return line 7          **/
/**          ? substrmemo (memofld)       => returns whole field    **/
/**          ? substrmemo (memofld, 5, 3) => return nul string      **/
/**                                                                 **/
/** Compiler:  Microsoft 5.0 :: CL /c /AL /Zl /Oalt /FPa /Gs substrm.c **/
/**                                                                 **/
/** Author:  Matt Colegrove                                         **/
/**                                                                 **/
/*********************************************************************/

#include "d:\clip87\nandef.h"
#include "d:\clip87\extend.h"

#define LF           '\n'
#define SOFT_LF      ('\n' | 0x80)
#define MAX_SIZE     0x7ff           /* 32K */

CLIPPER SUBSTRMEMO ()

{
   unsigned char *_exmgrab();
   unsigned char *str1, *pos1;         /* string and pointer to it */
   unsigned char *str2, *pos2;
   unsigned sizeof2;

   int lines, start, end;

   if (PCOUNT >= 1 && ISCHAR (1))
      {
      str1 = _parc (1);
      pos1 = str1;
      start = 1;
      end   = MAX_SIZE;           /* guaranteed end of field */

      if (PCOUNT >= 2 && ISNUM (2))
         {
         start = _parni (2);

         if (PCOUNT == 3 && ISNUM (3))
            {
            end = _parni (3);
            }
         else
            {
            _retc ("ERROR: Too Many Parameters passed to SUBSTRMEMO");
            }
         }  /* endif PCOUNT >= 2 */

      lines = 1;      /* when we begin, we are on line 1 */
      while (*pos1 && (lines < start))  /* spin pass lines before start */
         {
         if (*pos1 == LF || *pos1 == SOFT_LF)
            lines++;
         pos1++;
         }

      sizeof2 = strlen (str1);
      str2 = _exmgrab (sizeof2);  /* allocate space to str2 */
      pos2 = str2;
      while ((*pos1) && (*pos1 != 0x1a) && (lines <= end))
         {
         *pos2 = ((*pos1) & 0x7f);  /* strip of high order bit */
         if (*pos1 == LF || *pos1 == SOFT_LF)
            lines++;
         pos1++;
         pos2++;
         }
      *pos2 = '\0';   /* terminate the string */
      _retc (str2);
      _exmback (str2, sizeof2);
      }
   else /* PCOUNT < 1 */
      {
      _retc ("ERROR: SUBSTRMEMO has no parameters passed to it");
      }
}
/* end of substrm.c */
