 /*
   STRUWRIT.PRG
   
   Author     : Phil Barnett
   
   Written    : 11/04/92
   
   Function   : Program Generator
   
   Purpose    : Create the code needed to generate an empty .DBF
   
   Syntax     : STRUWRIT( FILENAME )
   
   Parameters : FILENAME is the exact name of the .DBF you wish to generate
   
   Returns    : NIL
   
   Example    : STRUWRIT ANY.DBF
   
   Compile    : Clipper STRUWRIT /N
   
   Link       : Rtlink  FI STRUWRIT
   
   Warning    : Creates a file by same name ending with .STX extension.
   
   Released to Public Domain by Author
   
*/

#define  CRLF   CHR( 13 ) + CHR( 10 )

static out_hdl

FUNCTION struwrit(file_name)

local dotat, prog_name, checkbyte, st_ary, st_ary_len, dbf_hdl, w

// check for startup conditions

IF valtype(file_name) <> 'C'
  ? 'Usage:'
  ? 'STRUWRIT DBFNAME.DBF'
  ?
  QUIT
ELSE
  file_name := UPPER(file_name)
ENDIF

IF !( '.DBF' $ file_name )
  ? 'Filespec must include a .DBF extension'
  ?
  QUIT
ENDIF

IF !FILE( file_name )
  ? 'Cannot find file ' + file_name
  ?
  QUIT
ENDIF

// Create the output file name.

dotat := AT( '.', file_name )
prog_name := LEFT( file_name, dotat ) + 'STX'

// Is this file *REALLY* a .DBF?

dbf_hdl = fopen( file_name, 0 )
fseek( dbf_hdl, 0, 0 )
checkbyte := ' '
fread( dbf_hdl, @checkbyte, 1 )
fclose( dbf_hdl )

checkbyte := ASC( checkbyte )

IF checkbyte <> 131 .AND. checkbyte <> 3
  ? file_name + ' is not a Legitimate .DBF file.'
  ?
  QUIT
ENDIF

IF checkbyte == 131
  dotat := AT( '.', file_name )
  IF !FILE( LEFT( file_name, dotat ) + 'DBT' )
    ? file_name + " is missing it's .DBT file."
    ?
    QUIT
  ENDIF
ENDIF

// Good enough. lets make it!

? 'Creating ' + prog_name + ' from ' + file_name
?

USE ( file_name )

st_ary := dbstruct( )
st_ary_len := len( st_ary )

out_hdl := fcreate( prog_name )

output( 'LOCAL A := {}' + CRLF + CRLF )
output( "IF !FILE('" + file_name + "')" + CRLF)
output( "  ASIZE(A,0)" + CRLF )

FOR w := 1 TO st_ary_len
  output('  AADD(A,{' + pad('"' + st_ary[ w, 1 ] + '"', 12 ) + ',"' + ;
  st_ary[ w, 2 ] + '",' + STR( st_ary[ w, 3 ], 5 ) + ',' + ;
  STR( st_ary[ w, 4 ], 2 ) + '})' + CRLF )
NEXT

output( '  DBCREATE("' + file_name + '",A)' + CRLF )
output( 'ENDIF' + CRLF + CRLF )

fclose( out_hdl )

CLOSE ALL

RETURN nil

************************

FUNCTION output( sometext )

fwrite( out_hdl, sometext, len( sometext ) )

RETURN nil

