* Ŀ
*          SYSTEM: KD Utility Library                                       
*                                                                           
*  Module: STRUCOMP.PRG.     .DBF file structure compare                    
*  Rev: $Revision$           Orig.Date : August 26, 1986                    
*  Programmer: M. Thomas     Date of LC: August 26, 1986                    
*  Placed in the public domain by Kansas Data, Evanston, IL, 60202          
* 
*PARAMETERS aDc_File1, aDc_File2, aDc_Mode
CLOSE DATA
SET SAFETY OFF
SET TALK OFF
CLEAR

STORE SPACE(24) TO aDc_File1, aDc_File2
aDc_BColWd = 5             && Columns spacing BETWEEN output of each structure.
aDc_Bytes1 = 0             && Count of bytes in file 1
aDc_Bytes2 = 0             && Count of bytes in file 2
aDc_CurLn  = 0             && Output line count
aDc_Device = "S"           && Output to Screen or Printer
aDc_DifCt  = 0             && Count of fields which did not differ
aDc_DLine  = 1             && Top line of screen display
aDc_Done   = .T.           && Flag for all fields processed
aDc_EOF1   = .F.           && Unprocessed records in 1st structure list file ?
aDc_EOF2   = .F.           && Unprocessed records in 2nd structure list file ?
aDc_File1  = SPACE(24)     && Name of 1st input file
aDc_File2  = SPACE(24)     && Name of 2nd input file
aDc_FldCt1 = 0             && Count of fields in file 1
aDc_FldCt2 = 0             && Count of fields in file 2
aDc_LinInc = .F.           && Increment line count?
aDc_Mode   = "A"           && Show "A"ll, "I"dentical, or "D"iffering Fields
aDc_NDec   = ""            && Display for name of field absent in other file
aDc_NLen   = ""
aDc_NName  = ""
aDc_NType  = ""
aDc_PLMrgn = 5             && Left margin of PRINTED output
aDc_RCol   = 0             && Start Col for right structure listing
aDc_SamCt  = 0             && Count of fields which differ
aDc_SColWd = 2             && Spacing WITHIN output of each structure MIN = 2!
aDu_NulChr = "."           && Character to display for missing field values

* Get user inputs
@ 6,  2 TO 15, 78
@ 6, 12 SAY "Kansas Data File Structure Comparison Utility, Rev 1.0"
@ 8,  4 SAY "File 1:"
@ 9,  4 SAY "File 2:"
@ 10, 4 SAY 'Output:    ("Screen" or "P"rinter)'
@ 11, 4 SAY 'Mode:      ("A"ll, "I"dentical, "D"ifferent, "Q"uit)'
aDu_List = .F. && Proceed to list structures ?
aDc_FIn = .T. && First time in input loop

DO WHILE .T. && Until legal input or abort
    IF .NOT. aDc_FIn
        ? CHR(7)
    ENDIF
    aDc_FIn = .F.

    @ 8,  13 GET aDc_File1  PICTURE "!!!!!!!!!!!!!!!!!!!!!!!!"
    @ 9,  13 GET aDc_File2  PICTURE "!!!!!!!!!!!!!!!!!!!!!!!!"
    @ 10, 13 GET aDc_Device PICTURE "!"
    @ 11, 13 GET aDc_Mode   PICTURE "!"
    READ
    aDc_File1 = UPPER(aDc_File1)
    aDc_File2 = UPPER(aDc_File2)
    @ 8,  13 SAY aDc_File1  PICTURE "!!!!!!!!!!!!!!!!!!!!!!!!"
    @ 9,  13 SAY aDc_File2  PICTURE "!!!!!!!!!!!!!!!!!!!!!!!!"
    @ 10, 13 SAY aDc_Device PICTURE "!"
    @ 11, 13 SAY aDc_Mode   PICTURE "!"

    IF aDc_Mode = "Q"
        EXIT
    ENDIF  aDc_Mode = "Q"
    
    IF  (.NOT. "." $ aDc_File1 ) .OR. (.NOT. "." $ aDc_File2 )
        @ 13, 4 SAY "Input File Names Must Include An Extension"
        LOOP
    ENDIF
    
    IF (.NOT. FILE("&aDc_File1"))
        @ 13, 4 SAY "Input File1 " + TRIM(aDc_File1) +;
         " Does Not Exist          "
        LOOP
    ENDIF
    
    IF (.NOT. FILE("&aDc_File2"))
        @ 13, 4 SAY "Input File2 " + TRIM(aDc_File2) +;
        " Does Not Exist          "
        LOOP
    ENDIF
    
    IF .NOT. aDc_Device $ "SP"
        @ 13, 4 SAY "Output device must be Screen or Printer        "
        LOOP
    ENDIF
    
    IF .NOT. aDc_Mode $ "AID"
        @ 13, 4 SAY "Mode must be All, Identical, Different, or Quit"
        LOOP
    ENDIF
    
    aDu_List = .T.
    EXIT && Input is OK
ENDDO WHILE .T. && Until legal input


IF aDu_List && User input OK
    CLEAR

    * Calculate start Col of Right structure listing
    aDc_RCol = 23 + (aDc_SColWd*3) +  aDc_BColWd

    * Output the structure of each file to a temp file
    aDc_File1 = TRIM(aDc_File1)
    aDc_File2 = TRIM(aDc_File2)
    @ 4, 4 SAY "Analyzing Input File Structures"
    USE &aDc_File1
    aDc_Recs1 = RECCOUNT()
    COPY STRU EXTENDED TO aDc_Src1.Tmp
    
    USE &aDc_File2
    aDc_Recs2 = RECCOUNT()
    COPY STRU EXTENDED TO aDc_Src2.Tmp
    
    
    SELECT 2
    USE aDc_Src2.Tmp ALIAS Struct_2
    INDEX ON FIELD_NAME TO aDc_Src2.Ndx
    SELECT 1
    USE aDc_Src1.Tmp ALIAS Struct_1
    INDEX ON FIELD_NAME TO aDc_Struc1.Ndx

    IF aDc_Device = "P"
        SET MARGIN TO aDc_PLMrgn
        SET PRINT ON
    ENDIF

    DO WHILE .T. && Still records to process in at least one file

        IF aDc_CurLn = 0
    CLEAR && Print header
    aDc_Temp1 = aDc_File1 + " " + LTRIM(STR(aDc_Recs1,8,0)) + " Records"
    aDc_Temp2 = aDc_RCol - LEN(aDc_Temp1) 
    ? aDc_Temp1  + SPACE(aDc_Temp2)  + aDc_File2 + " " +;
     LTRIM(STR(aDc_Recs2,8, 0)) + " Records"
    aDc_CurLn = aDc_CurLn + 1

    DO CASE
    CASE aDc_Mode = "D"
        ? "ONLY DIFFERING FIELDS ARE SHOWN"
    CASE aDc_Mode = "I"
        ? "ONLY IDENTICAL FIELDS ARE SHOWN"
    OTHERWISE
        ? "ALL FIELDS ARE SHOWN"
    ENDCASE
    aDc_CurLn = aDc_CurLn + 1
    *Field     .Type..Width....Dec
    *----------.----..-----..-----
    *XXXXXXXXXX..b9b..b999b..b999b
    ? "Field    " + SPACE(aDc_SColWd-1) + "Type" + SPACE(aDc_SColWd)  +;
      "Width" + SPACE(aDc_SColWd+3) + "Dec" + SPACE(aDc_BColWd) +;
      "Field    " + SPACE(aDc_SColWd-1) + "Type" + SPACE(aDc_SColWd)  +;
      "Width" + SPACE(aDc_SColWd+3) +  "Dec"
    aDc_CurLn = aDc_CurLn + 1

     ? "----------" + SPACE(aDc_SColWd-1) + "----" + SPACE(aDc_SColWd) +;
      "-----" +  + SPACE(aDc_SColWd) +"-----" + SPACE(aDc_BColWd) +;
       "----------" + SPACE(aDc_SColWd-1) + "----" + SPACE(aDc_SColWd) +;
      "-----" +  + SPACE(aDc_SColWd) +"-----" 
     aDc_CurLn = aDc_CurLn + 1
    * Initialize variables holding the values to be displayed for 
    * absent fields which would match fields present in the other file.
    * number of decimals to null values. The extra leading and trailing
    * blanks around the values for Type, Length and Decimals allow the
    * later display of marker values if these values are not identical in
    * both files.
    aDc_NName = REPLICATE(aDu_NulChr,10)
    aDc_NType = SPACE(aDc_SColWd) + " " + REPLICATE(aDu_NulChr,1) + " " 
    aDc_NLen  = SPACE(aDc_SColWd) + " " + REPLICATE(aDu_NulChr,3) + " " 
    aDc_NDec  = SPACE(aDc_SColWd) + " " + REPLICATE(aDu_NulChr,3) + " " 

        ENDIF aDc_CurLn = 0

        * Initialize variables holding current field name, type, len and
        * number of decimals for each file to null values.
        STORE " " + SPACE(10) + " " TO  aDc_Name1, aDc_Name2
        STORE " " + SPACE(1)  + " " TO aDc_Type1, aDc_Type2
        STORE " " + SPACE(3)  + " " TO  aDc_Dec1,  aDc_Dec2, aDc_Len1,;
        aDc_Len2


        * Load values for current fields record in each temp file.  If the end
        * of a temp file has been reached the default (null) values set above
        * will retained and a flag for all records processed set.  All values 
        * are converted as required to character variables, and left padded as
        * required to provide spacing output. The extra leading and trailing
        * blanks around the values for Type, Length and Decimals allow the
        * later display of marker values if these values are not identical in
        * both files.
        SELECT Struct_1
        IF .NOT. EOF()
            aDc_Name1  = FIELD_NAME
            aDc_Type1  = SPACE(aDc_SColWd+1) + FIELD_TYPE +  SPACE(1)
            aDc_Len1   = SPACE(aDc_SColWd+1) + STR(FIELD_LEN,3,0) + SPACE(1)
            aDc_Dec1   = SPACE(aDc_SColWd+1) + STR(FIELD_DEC,3,0) + SPACE(1)
        ELSE
            aDc_EOF1 = .T. && No more records in this file
        ENDIF .NOT. EOF()
        
        SELECT Struct_2
        IF .NOT. EOF()
            aDc_Name2 = FIELD_NAME
            aDc_Type2 = SPACE(aDc_SColWd+1) + FIELD_TYPE + SPACE(1)
            aDc_Len2  = SPACE(aDc_SColWd+1) + STR(FIELD_LEN,3,0) + SPACE(1)
            aDc_Dec2  = SPACE(aDc_SColWd+1) + STR(FIELD_DEC,3,0) + SPACE(1)
        ELSE
            aDc_EOF2 = .T. 
        ENDIF .NOT. EOF()
        
        IF aDc_EOF1 .AND. aDc_EOF2 && All fields processed
            aDc_Done = .F. && Ready to exit main loop
            EXIT && To print of footer
        ENDIF
        
        * Test for any differences between the fields. Keep count of those
        * fields which are the same and those which differ
        aDc_Diff = .F. && Any differences ?
        aDc_Diff = IIF(aDc_Type1<>aDc_Type2,.T.,aDc_Diff)
        aDc_Diff = IIF(aDc_Len1<>aDc_Len2,.T.,aDc_Diff)
        aDc_Diff = IIF(aDc_Dec1<>aDc_Dec2,.T.,aDc_Diff)
        aDc_DifCt = IIF(aDc_Diff,aDc_DifCt+1,aDc_DifCt) && Differents
        aDc_SamCt = IIF(aDc_Diff,aDc_SamCt,aDc_SamCt+1) && Sames
        
        aDc_Disp = "" && Display control flag
        DO CASE
        CASE aDc_Name1 = aDc_Name2
            * Each File contains a field of the same name. Display both fields,
            * and any differences. 
            aDc_Disp = "B"

        CASE aDc_EOF1
            * There are no fields left to display in file 1. Display
            * information for file 2 only, skip and test next file 2 field.
            aDc_Disp = "2"

        CASE aDc_EOF2
            * There are no fields left to display in file 2. Display
            * information for file 1 only, skip and test next file 1 field.
            aDc_Disp = "1"

        OTHERWISE
            * Both files still contain fields to display.  Display the field
            * which occurs first in an alphabetical sort.
            aDc_Disp = IIF(aDc_Name1 < aDc_Name2,"1", "2")
        ENDCASE
        
        STORE .F. TO  aDc_Skip1, aDc_Skip2 && Flag to force skips
        aDc_LinInc = .F.                   && Increment line count ?
        DO CASE && Display requested information, set skip flags.
        CASE aDc_Disp = "1"
            IF aDc_Mode <> "I" && Not display only identical fields
                 ?  aDc_Name1 + aDc_Type1 + aDc_Len1 + aDc_Dec1
                 ?? SPACE(aDc_BColWd)
                 ?? aDc_NName + aDc_NType + aDc_NLen + aDc_NDec
                aDc_LinInc = .T.
                aDc_Skip1 = .T.
            ENDIF

        CASE aDc_Disp = "2"
            IF aDc_Mode <> "I" && Not display only identical fields
                 ?  aDc_NName + aDc_NType + aDc_NLen + aDc_NDec
                 ?? SPACE(aDc_BColWd)
                 ?? aDc_Name2 + aDc_Type2 + aDc_Len2 + aDc_Dec2
                aDc_LinInc = .T.
                aDc_Skip2 = .T.
            ENDIF

        CASE aDc_Disp = "B" && Both files' fields, with differences marked
            * If requested show only differences
            IF (aDc_Mode = "A") .OR. (aDc_Mode = "D" .AND. aDc_Diff) .OR.;
             (aDc_Mode = "I" .AND. (.NOT. aDc_Diff))
                ?  aDc_Name1 + aDc_Type1 + aDc_Len1 + aDc_Dec1
                ?? SPACE(aDc_BColWd)
                ?? aDc_Name2
                ?? IIF(aDc_Type1 = aDc_Type2 ,aDc_Type2 ,;
                 SPACE(aDc_SColWd) + "<"+SUBSTR(aDc_Type2,2+aDc_SColWd,1)+">" )
                ?? IIF(aDc_Len1 = aDc_Len2 , aDc_Len2 ,;
                 SPACE(aDc_SColWd) +"<"+SUBSTR(aDc_Len2,2+aDc_SColWd,3)+">" )
                ?? IIF(aDc_Dec1 = aDc_Dec2 , aDc_Dec2 ,;
                 SPACE(aDc_SColWd) +"<"+SUBSTR(aDc_Dec2,2+aDc_SColWd,3)+">")
                aDc_LinInc = .T.
            ENDIF (aDc_Mode <> "D") .OR. (aDc_Mode = "D" .AND. aDc_Diff)
            aDc_Skip1 = .T.
            aDc_Skip2 = .T.
        ENDCASE
        
        * Skip and update counts as required
        IF aDc_Skip1
            SELECT Struct_1
            aDc_Bytes1 = aDc_Bytes1 + FIELD_LEN && Total bytes
            aDc_FldCt1 = aDc_FldCt1 + 1         && Field Count
            SKIP
        ENDIF
        
        IF aDc_Skip2
            SELECT Struct_2
            aDc_Bytes2 = aDc_Bytes2 + FIELD_LEN
            aDc_FldCt2 = aDc_FldCt2 + 1
            SKIP
        ENDIF
        
        IF aDc_Device = "S"
            IF aDc_LinInc && A line was Printed/Displayed
                IF aDc_CurLn = 21
                    WAIT
                    CLEAR
                    aDc_CurLn = 0
                ELSE
                    aDc_CurLn = aDc_CurLn + 1
                ENDIF
            ENDIF aDc_LinInc && A line was Printed/Displayed
        ELSE
            IF aDc_LinInc && A line was Printed/Displayed
                 aDc_CurLn = aDc_CurLn + 1
            ENDIF aDc_LinInc && A line was Printed/Displayed
        ENDIF aDc_Device = "S"
    ENDDO WHILE .T.

    CLOSE DATA

    aDc_CurLn = aDc_CurLn + 2 && Print footer
    aDc_Temp1 = LTRIM(STR(aDc_FldCt1,4,0)) + " Fields" + SPACE(3)
    aDc_Temp1 = aDc_Temp1 +  LTRIM(STR(aDc_Bytes1,4,0)) + " Bytes"
    aDc_Temp2 = aDc_RCol - LEN(aDc_Temp1)
    ? aDc_Temp1 + SPACE(aDc_Temp2) + LTRIM(STR(aDc_FldCt2,4,0)) + " Fields" +;
      SPACE(3) + LTRIM(STR(aDc_Bytes2,4,0)) + " Bytes"
    ? LTRIM(STR(aDc_SamCt,4,0)) + " Fields Matched"
    ? LTRIM(STR(aDc_DifCt,4,0)) + " Fields Differed"

    IF aDc_Device = "P"
        EJECT
        SET MARGIN TO 0
        SET PRINT OFF
    ENDIF

    DELETE FILE aDc_Src1.Tmp
    DELETE FILE aDc_Src1.Ndx
    DELETE FILE aDc_Src2.Tmp
    DELETE FILE aDc_Src2.Ndx
ENDIF aDu_List

SET SAFETY ON

* EOP STRUCOMP.PRG

