/* StrmTest.prg : Example program, to show how to use the StrmRead function.

   StrmRead accelerates Fread dramatically by buffering the file (upto 32k)

   Written By Chris Murray, December 1993, First uploaded to Compuserve May 1994.

   Feel free to copy and distribute all the files, I would be interested
   in any comments and I can be reached on compuserve mail (100043,2247).

   I would be appreciate $25, for my time and effort from people that are
   going to continue using the routines, (especially companies).

   I will admit that the $25 is purely to feed my compuserve addiction,
	 currently runnning at $100 a month. Thats a lot of money compared to my
	 salary.

   For that fee I will do all the normal stuff, like sending updates when needed
   and online support via compuserve.

   Even if you are an unregistered user, feel free to contact me via Compuserve
   if you have any questions.

   Note : if the file you are dealing with ends without CRLF the function will
          FALSE but the buffer will be filled with the remaining characters. I
          haven't come across this yet in a text file. The obvious way round it
          would be to use a repeat/until loop and process the buffer if the
          function returns FALSE but the buffer is not empty, and of course when
          the function returns TRUE.
*/

#include "Fileio.ch"

Procedure Main( cFileName )

  LOCAL cBuf := ""    , ;                        // line buffer
        nHandle       , ;                        // dos file handle
        nCounter := 0 , ;                        // line counter
        nStartTime    , ;                        // timer start time
        nStopTime                                // timer stop time

  Cls

  If cFileName == NIL .or. .not. File( cFileName )
    cFileName := CreateTestFile()
  Endif

  nHandle := Fopen( cFileName , FO_READ )

  If nHandle == F_ERROR
    ? "File open error :", FERROR()
  Else

    @ 05 , 10 Say "Strmread Demo, Written By Chris Murray, April 1994"

    @ 10 , 10 Say "StrmRead - Lines read    :"
    @ 12 , 10 Say "           Lines per sec :"

    // accept default buffer of 32k
    StrmBufReset( nHandle )

    // start timer
    nStartTime := Seconds()

    Do While StrmLineRead( @cBuf )
      // do stuff here
      @ 10 , 37 Say Str( ++nCounter , 6 , 0 )
    Enddo

    // stop timer
    nStopTime := Seconds()

    // close stream and release static memory.
    StrmBufReset()

    // display lines per second
    @ 12 , 37 Say Str( nCounter / ( nStopTime - nStartTime ) , 7 , 2 )

  Endif

  Fclose( nHandle )

Return

Static Function CreateTestFile()

  Local cFileName := "StrmRead.clm" , ;
        nCounter                    , ;
        nHandle

  @ 07 , 10 Say "Creating test file, please wait..."

  nHandle := FCreate( cFileName )

  For nCounter := 1 To 1000
    Fwrite( nHandle , "line : " + Str( nCounter , 6 , 0 ) + ;
		   Space( 80 ) + Str( nCounter , 6 , 0 ) + Chr( 13 ) + Chr( 10 ) )
  Next

	FClose( nHandle )

Return( cFileName )
