*/ ---------------------------------------------------------------------------
* Program name..:  TESTPRIN.prg
*
* Purpose.......:  To test OUTPUT functions:  StartPrint()
*                                             LinePrint()
*                                             PrnCode()
*                                             DonePrint()
*                                             TextDate()
*                                             VarToSTR()
*                                             AMpmTime()
*                                             Display()
*                                             Frame()
*
* Author........:  Stephen L. Woolstenhulme
* Notice........:  Copyright (C) 1990, All Rights Reserved.
*
*/ ---------------------------------------------------------------------------

* MemVar mHeading, mColHead, TextLine, pSmallPRN, pNormPRN, PrnFile
* MemVar PgNo, LnNo, PgLn, mWhere, mFiles, LoopCount, mRow, mScrn, ScrnColor
* MemVar FileName, FileSize, FileDate, FileTime, FileAttr

Private mHeading, mColHead, TextLine, pSmallPRN, pNormPRN, PrnFile
Private PgNo, LnNo, PgLn, mWhere, mFiles, LoopCount, mRow, mScrn, ScrnColor
Private FileName, FileSize, FileDate, FileTime, FileAttr

mScrn     = SaveScreen(00,00,24,79)  && We'll need this when we exit
mRow      = Row()                    && Let's remember where to put the cursor
ScrnColor = SetColor()               && And let's not forget the current colors
pSmallPRN = '\27&k2S'                && Code for HP-LaserJet Compressed Print
pNormPRN  = '\27&k0S'                && Code for HP-LaserJet Normal Print
PrnFile   = ''                       && Passed by reference to StartPrint()
PgNo      =  0                       && Current Page Number (Start with 0)
LnNo      =  0                       && Line on this page (Start with 0)
PgLn      = 56                       && Printed lines per page

SetColor(iif(isColor(),'w+/b','w+/n'))
@ 00,00,24,79 box Frame('SOLID','PATTERN')

Declare mHeading[3]
mHeading[1]="FILES IN THIS DIRECTORY"
mHeading[2]=Curdir()
mHeading[3]=TextDate(Date(),.t.)

Declare mColHead[3]
mColHead[ 1]="=================================================="
mColHead[ 2]="File Name     File Size    Date      Time    Attr."
mColHead[ 3]="------------  ---------  --------  --------  -----"

mFiles = aDir('*.*')
Declare FileName[mFiles], FileSize[mFiles], FileDate[mFiles]
Declare FileTime[mFiles], FileAttr[mFiles]
aDir('*.*', FileName, FileSize, FileDate, FileTime, FileAttr)
Declare TextLine[5]
aFill(TextLine,'')
BoxHead('Test print-related library functions.',12,39)
mWhere=StartPrint(mHeading[1],@PrnFile,pNormPRN)

if mWhere!='E'
   for LoopCount = 1 to mFiles
      TextLine[1] = VarToSTR(FileName[LoopCount],13,'L')
      TextLine[2] = VarToSTR(FileSize[LoopCount],09,'R','9,999,999')
      TextLine[3] = VarToSTR(FileDate[LoopCount],09,'R')
      TextLine[4] = VarToSTR(AMpmTime(FileTime[LoopCount],.f.),09,'R')
      TextLine[5] = VarToSTR(FileATTR[LoopCount],06,'C')
      If .not. LinePrint(@PgNo,@LnNo,PgLn,mHeading,mColHead,TextLine,'I.D. 101')
         Exit
      endif
   next
   DonePrint(mWhere,mColHead,PrnFile,pNormPRN)
endif

SetColor(ScrnColor)
RestScreen(00,00,24,79,mScrn)
@ mRow-1,00 say ''
Return
