*/ ---------------------------------------------------------------------------
* Program name..:  TESTFUNC.prg
*
* Purpose.......:  To test all functions of STEVE.LIB.
*
* Author........:  Stephen L. Woolstenhulme
*
* Notice........:  Copyright (C) 1990, All Rights Reserved.
*
*/ ---------------------------------------------------------------------------

private laFuncList,lnChoice,lcScrn,lnRow,laHdFt,laColors,laMsg,lnOffset,;
        lnTemp,lcTemp,laChoice
PushScrn()
lnChoice = 1
lnOffset = 1
declare laFuncList[24]
laFuncList[01] = 'AMpmTime()   01 of 24' 
laFuncList[02] = 'BoxHead()    02 of 24'  
laFuncList[03] = 'CenterIt()   03 of 24' 
laFuncList[04] = 'CheckPrn()   04 of 24' 
laFuncList[05] = 'dbfPick()    05 of 24'
laFuncList[06] = 'DonePrint()  06 of 24'
laFuncList[07] = 'Frame()      07 of 24'    
laFuncList[08] = 'HotPick()    08 of 24'  
laFuncList[09] = 'IncrDate()   09 of 24'
laFuncList[10] = 'LinePrint()  10 of 24'
laFuncList[11] = 'MakeFile()   11 of 24'
laFuncList[12] = 'MakeMenu()   12 of 24'
laFuncList[13] = 'Noise()      13 of 24'
laFuncList[14] = 'PickOne()    14 of 24'
laFuncList[15] = 'PopScrn()    15 of 24'
laFuncList[16] = 'PrnCode()    16 of 24'
laFuncList[17] = 'PushScrn()   17 of 24'
laFuncList[18] = 'ReadIt()     18 of 24'
laFuncList[19] = 'Shadow()     19 of 24' 
laFuncList[20] = 'StopNow()    20 of 24'
laFuncList[21] = 'StartPrint() 21 of 24'
laFuncList[22] = 'TextBox()    22 of 24'
laFuncList[23] = 'TextDate()   23 of 24'
laFuncList[24] = 'VarToStr()   24 of 24'

declare laHdFt[2]
laHdFt[1] = 'Library Functions'
laHdFt[2] = '* Please Select *'

declare laColors[3]
laColors[1]='w+/b,w+/r,,,w/b'
laColors[2]='w+/rb'
laColors[3]='w+/gr+'
clear
do while .t.
   lnChoice = HotPick(03,27,21,51,laFuncList,.t.,;
                 lnChoice,lnOffset,laHdFt,'BOLD',laColors)
   lnOffset = Row()-6

   do case
      case lnChoice =  0        
         exit

      case lnChoice =  1        && 'AMpmTime' 
         declare laMsg[13]
         laMsg[ 1] = 'Some examples of AmPmTime():'
         laMsg[ 2] = ''
         laMsg[ 3] = 'With seconds:'
         laMsg[ 4] = ''
         laMsg[ 5] = '   Current time  '+AmPmTime(time(),.t.)
         laMsg[ 6] = '       00:15:20  '+AmPmTime('00:15:20',.t.)
         laMsg[ 7] = '       15:15:30  '+AmPmTime('15:15:30',.t.)
         laMsg[ 8] = ''
         laMsg[ 9] = 'Without seconds:'
         laMsg[10] = ''
         laMsg[11] = '   Current time  '+AmPmTime(time())
         laMsg[12] = '       00:15:20  '+AmPmTime('00:15:20',.f.)
         laMsg[13] = '       15:15:30  '+AmPmTime('15:15:30',.f.)
         TextBox(laMsg,.t.)

      case lnChoice =  2        && 'BoxHead'  
         PushScrn()
         BoxHead('BoxHead() at 06,20.',06,20)
         BoxHead('BoxHead() with default coordinates.')
         BoxHead('BoxHead() at 18,60.',18,60)
         BoxHead('Press any key to return to menu...',23,18)
         Inkey(0)
         PopScrn()

      case lnChoice =  3        && 'CenterIt' 
         PushScrn()
         CenterIt('Center date, character, or numeric variable types on any column:',1)
         CenterIt(Date(),06,20)
         CenterIt('< date at 06,20.',06,60)
         CenterIt('This is centered at default coordinates.')
         CenterIt(1000.00,18,60)
         CenterIt('Number at 18,60 >',18,20)
         CenterIt('Press any key to return to menu...',23)
         Inkey(0)
         PopScrn()

      case lnChoice =  4        && 'CheckPrn' 
         Declare laMsg[6]
         laMsg[1] = 'To test this function, select StartPrint(),'
         laMsg[2] = 'DonePrint(), or LinePrint().  Make sure your'
         laMsg[3] = 'printer is turned off, then select to send'
         laMsg[4] = 'the report to the printer.  CheckPrn() will'
         laMsg[5] = 'tell you that the printer is not ready and'
         laMsg[6] = 'will give you an opportunity to recover.'
         TextBox(laMsg,.t.)

      case lnChoice =  5        && 'dbfPick'
         set exclusive off
         use testfunc index testfunc
         do while LastKey() != 27
            if dbfPick('','FILE_NAME','TestFunc.DBF','BOLD','W+/R')
               TextBox('You picked '+FILE_NAME,.t.)
            endif
         enddo
         close

      case lnChoice =  6        && 'DonePrint'
         do TestPrin

      case lnChoice =  7        && 'Frame'    
         PushScrn()
         
         SetColor('w+/n')
         @ 00,00,24,79 box frame('NONE','PATTERN')
         
         SetColor('w+/g')
         @ 01,10,05,69 box frame('DOUBLE','EMPTY')
         CenterIt('*** DOUBLE, EMPTY ***',03,39)
         
         SetColor('w+/b')
         @ 07,10,11,69 box frame('BOLD','BLANK')
         CenterIt('*** BOLD, BLANK ***',09,39)

         SetColor('w+/rb')
         @ 13,10,17,69 box frame('SOLID','PLUS')
         CenterIt('*** SOLID, PLUS ***',15,39)
         
         SetColor('w+/gr+')
         @ 19,10,23,69 box frame('SINGLE','PATTERN')
         CenterIt('*** SINGLE, PATTERN ***',21,39)

         SetColor('w+/r')
         Shadow(03,03,07,17)
         @ 03,03,07,17 box frame('NONE','BLANK')
         CenterIt('NONE, BLANK',05,11)
         
         Shadow(03,61,07,75)
         @ 03,61,07,75 box frame('NONE','BLANK')
         CenterIt('NONE, BLANK',05,69)
         
         Shadow(16,03,20,17)
         @ 16,03,20,17 box frame('NONE','BLANK')
         CenterIt('NONE, BLANK',18,11)

         Shadow(16,61,20,75)
         @ 16,61,20,75 box frame('NONE','BLANK')
         CenterIt('NONE, BLANK',18,69)

         Inkey(0)
         PopScrn()

      case lnChoice =  8        && 'HotPick'  
         Declare laMsg[7]
         laMsg[1] = 'This menu uses the HotPick() function to allow'
         laMsg[2] = 'you to choose functions to test.  You can use'
         laMsg[3] = 'the arrow keys to move up and down among the'
         laMsg[4] = 'choices, or you can type in a choice.  As you'
         laMsg[5] = 'type, the highlight bar moves instantly to the'
         laMsg[6] = 'first matching option.  Press ENTER to select'
         laMsg[7] = 'the highlighted item.'
         TextBox(laMsg,.t.)

      case lnChoice =  9        && 'IncrDate'
         PushScrn()
         SetColor('w+/rb')
         @ 06,15,18,64 box frame('NONE','BLANK')
         CenterIt('< Press ESC to exit >',18)
         ldTmpDate=Date()
         lnTemp   = 6
         set scoreboard OFF
         do while lastkey()!=27
            @ 10,18 say 'Base date....: ' get ldTmpDate pict '@d'
            @ 12,18 say 'Months to add: ' get lnTemp    pict '999'
            ReadIt()
            if year(IncrDate(ldTmpDate,lnTemp))>1999
               Set Century ON
            else 
               Set Century OFF
            endif
            @ 14,18 say 'IncrDate() returns '+dtoc(IncrDate(ldTmpDate,lnTemp))
         enddo
         set scoreboard ON
         Set Century OFF
         PopScrn()

      case lnChoice = 10        && 'LinePrint'
         do TestPrin

      case lnChoice = 11        && 'MakeFile'
         PushScrn()
         SetColor('w+/r')
         @ 00,00,24,79 box frame('BOLD','PATTERN')
         SetColor('w+/b')
         CenterIt('Here are sample temporary file names...',0,39)
         SetColor('w+/gr')
         BoxHead(MakeFile('NTX'),5)
         SetColor('w+/bg')
         BoxHead(MakeFile('TMP'),10)
         SetColor('w+/g')
         BoxHead(MakeFile('$$$'),15)
         SetColor('w+/rb')
         BoxHead(MakeFile('   '),20)
         SetColor('w+/b')
         CenterIt(' Press any key to continue... ',24)
         Inkey(0)
         PopScrn()

      case lnChoice = 12        && 'MakeMenu'
         declare laChoice[3]
         laChoice[1]='First choice'
         laChoice[2]='Another option'
         laChoice[3]='Quit'
         declare laMsg[3]
         laMsg[1]='This option is your first choice.'
         laMsg[2]='Here is another option you might select.'
         laMsg[3]='Pick this option to get out of this function.'
         lnTemp=1
         do while .t.
            lnTemp=MakeMenu('*** Choose An Option ***',laChoice,laMsg,lnTemp,'w+/r,w+/g,,,w/n')
            do case
               case lnTemp = 1
                  Textbox('You chose '+laChoice[1],.t.)
               case lnTemp = 2
                  Textbox('You chose '+laChoice[2],.t.)
               case lnTemp = 3
                  TextBox('You chose '+laChoice[3],.t.)
                  exit
            endcase
         enddo

      case lnChoice = 13        && 'Noise'
         declare laChoice[9]
         laChoice[1]='Screw-up'
         laChoice[2]='Wake-up'
         laChoice[3]='Happy'
         laChoice[4]='Sad'
         laChoice[5]='Bad'
         laChoice[6]='Alarm'
         laChoice[7]='Cheep'
         laChoice[8]='Buzz'
         laChoice[9]='Quit'
         lnTemp=1
         do while .t.
            lnTemp=MakeMenu('*** Choose An Option ***',laChoice,'',lnTemp,'w+/r,w+/g,,,w/n')
            do case
               case lnTemp = 1
                  noise('SCREW-UP')
                  Textbox('You chose '+laChoice[1],.t.)
               case lnTemp = 2
                  noise('WAKE-UP')
                  Textbox('You chose '+laChoice[2],.t.)
               case lnTemp = 3
                  noise('HAPPY')
                  Textbox('You chose '+laChoice[3],.t.)
               case lnTemp = 4
                  noise('SAD')
                  Textbox('You chose '+laChoice[4],.t.)
               case lnTemp = 5
                  noise('BAD')
                  Textbox('You chose '+laChoice[5],.t.)
               case lnTemp = 6
                  noise('ALARM')
                  Textbox('You chose '+laChoice[6],.t.)
               case lnTemp = 7
                  noise('CHEEP')
                  Textbox('You chose '+laChoice[7],.t.)
               case lnTemp = 8
                  noise('BUZZ')
                  Textbox('You chose '+laChoice[8],.t.)
               case lnTemp = 9
                  exit
            endcase
         enddo

      case lnChoice = 14        && 'PickOne'
         declare laChoice[3]
         laChoice[1]='First choice'
         laChoice[2]='Another option'
         laChoice[3]='Quit'
         do while .t.
            lnTemp=PickOne('Choose an option',laChoice,21,1,'w+/r,w+/bg,,,w/n')
            do case
               case lnTemp = 1
                  Textbox('You chose '+laChoice[1],.t.)
               case lnTemp = 2
                  Textbox('You chose '+laChoice[2],.t.)
               case lnTemp = 3
                  TextBox('You chose '+laChoice[3],.t.)
                  exit
            endcase
         enddo

      case lnChoice = 15 .or. lnChoice = 17  && 'PushScrn' & 'PopScrn' 
         PushScrn()
         @ 01,00,24,79 box frame('BOLD','PATTERN')

         PushScrn(00,00,12,39)
         SetColor('w+/rb')
         @ 00,00,12,39 box frame('NONE','BLANK')
         CenterIt('Box #1',6,19)
         
         PushScrn(13,00,24,39)
         SetColor('w+/g')
         @ 13,00,24,39 box frame('NONE','BLANK')
         CenterIt('Box #2',18,19)

         PushScrn(00,40,12,79)
         SetColor('w+/gr')
         @ 00,40,12,79 box frame('NONE','BLANK')
         CenterIt('Box #3',06,59)

         PushScrn(13,40,24,79)
         SetColor('w+/bg')
         @ 13,40,24,79 box frame('NONE','BLANK')
         CenterIt('Box #4',18,59)
         declare laMsg[5]
         laMsg[1]='I have saved five screens--the entire screen'
         laMsg[2]='before painting these four boxes, and a quarter'
         laMsg[3]='of the screen each under each box.  Press any'
         laMsg[4]='key to start restoring.  A section will be'
         laMsg[5]='restored with each key you press.'
         TextBox(laMsg,.t.)
         inkey(0)
         PopScrn()   && #4 Restored.
         inkey(0)
         PopScrn()   && #3 Restored.
         inkey(0)
         PopScrn()   && #2 Restored.
         inkey(0)
         PopScrn()   && #1 Restored.
         inkey(0)

      case lnChoice = 16        && 'PrnCode'
         Declare laMsg[4]
         laMsg[1]='\027&k2S becomes '+PrnCode('\027&k2S')
         laMsg[2]='\27&k2S  becomes '+PrnCode('\27&k2S')
         laMsg[3]='\027\18  becomes '+PrnCode('\027\18')
         laMsg[4]='\27\015  becomes '+PrnCode('\27\015')
         TextBox(laMsg,.t.)

      case lnChoice = 17        && 'PushScrn'

      case lnChoice = 18        && 'ReadIt'
         PushScrn()
         clear
         lcTemp='QUIT'
         declare laMsg[5]
         laMsg[1]='The ReadIt() function simply assures that the'
         laMsg[2]='cursor is set ON with each READ, then set OFF'
         laMsg[3]='when the READ is completed.  That eliminates'
         laMsg[4]='annoying cursor flicker and relieves you of the'
         laMsg[5]='task of keeping track of the cursor state.'
         TextBox(laMsg,.f.)
         @ 19,09,23,69 Box Frame('DOUBLE','BLANK')
         @ 21,20 say 'This is ReadIt() in action: ' get lcTemp pict '!!!!'
         ReadIt()
         PopScrn()

      case lnChoice = 19        && 'Shadow'
         PushScrn()
         SetColor('w+/b')
         @ 00,00,24,79 box frame('SOLID','PATTERN')
         lnTRow=08
         lnLCol=15
         lnBRow=16
         lnRCol=64
         Shadow(lnTRow,lnLCol,lnBRow,lnRCol)
         CenterIt('Box coordinates are 08,30,16,49',11,39)
         CenterIt('Press any key to lay on the box...',13,39)
         Inkey(0)
         @ lnTRow,lnLCol,lnBRow,lnRCol box frame('BOLD','BLANK')
         CenterIt('SHADOW() draws an offset box.',11,39)
         CenterIt('You then overlay the box of your choice.',13,39)
         inkey(0)
         PopScrn()

      case lnChoice = 20
         PushScrn()
         clear
         SetColor('W+/R')
         BoxHead('---------',03,40)
         declare laMsg[6]
         laMsg[1] = 'Ever get stuck in an infinite loop?'
         laMsg[2] = 'Try this next time:'
         laMsg[3] = ''
         laMsg[4] = 'do while (! eof()) .and. (! StopNow())'
         laMsg[5] = ''
         laMsg[6] = 'Press a key to see StopNow() in action.'
         TextBox(laMsg,.f.)
         lnCount = 1
         do while ! StopNow()
            CenterIt(Str(lnCount,9),3,40)
            lnCount = lnCount + 1
         enddo
         PopScrn()

      case lnChoice = 21        && 'StartPrint'
         do TestPrin

      case lnChoice = 22        && 'TextBox'
         Declare laMsg[14]
         laMsg[1]='You have seen TEXTBOX() in action throughout'
         laMsg[2]='this demonstration of the library functions.'
         laMsg[3]=''
         laMsg[4]='Pass an array of lines of text to TEXTBOX()'
         laMsg[5]='and it centers a box on the screen with the'
         laMsg[6]='array items displayed in it.'
         laMsg[7]=''
         laMsg[8]='If you send .t. as the second parameter the'
         laMsg[9]='screen will be saved, a PRESS ANY KEY...'
         laMsg[10]='message will display, and execution will'
         laMsg[11]='pause until someone presses a key.  If you'
         laMsg[12]='pass .f., the message will display and pro-'
         laMsg[13]='gram execution will continue until the'
         laMsg[14]='message is overwritten.'
         TextBox(laMsg,.t.)

      case lnChoice = 23        && 'TextDate'
         declare laMsg[5]
         laMsg[2]=''
         laMsg[3]='Date by itself.....: '+TextDate(Date())
         laMsg[4]='Day and date.......: '+TextDate(Date(),.t.)
         laMsg[5]='Day, date, and time: '+TextDate(Date(),.t.,.t.)
         laMsg[1]=VarToStr('Examples of TextDate()',len(laMsg[5]),'C')
         TextBox(laMsg,.t.)

      case lnChoice = 24        && 'VarToStr'
         declare laMsg[8]
         laMsg[1]='VarToSTR() converts any variable type to a character type.'
         laMsg[2]='You can pass as parameters the width you want the string'
         laMsg[3]='to be and whether to pad it left, centered, or right.  It'
         laMsg[4]='will trim if the string is longer than the width you specify.'
         laMsg[5]=''
         laMsg[6]='This is the date as a string: '+VarToStr(Date())
         laMsg[7]='This is a number as a string: '+VarToStr(999999.99,10,'R','999,999.99')
         laMsg[8]='This is a centered string...: '+VarToStr('String',16,'C')
         TextBox(laMsg)
   endcase
enddo
PopScrn()
set cursor ON
quit
