/*
Program...... Stdchng.prg
Author....... Dave Adams    CIS-ID: 72037,2654
Date......... Sept 26, 1991
Copyright.... None.  This is public domain
Description.. Creates a file compatible with Expert Help compiler for STD.CH
Comments..... This uses NanFor.lib FT_F* functions
              Once the file has been created, run Compile.bat file which
              uses the stdch.lnk file to link the ngo.
              Hopefully Nantucket will keep the format the same in future
              releases.
Contains..... Main()         Main program
              CreateFile()   Creates the file
Syntax....... Stdchng
Return....... n/a
Compile...... Clipper stdchng /n /w
Link......... Rtlink FI stdchng LI nanfor
*/

*-----------------------------------------------
// Pre-processor stuff

#include "inkey.ch"
#include "box.ch"
#include "setcurs.ch"

#xcommand Window( <nT>, <nL>, <nB>, <nR> )                ;
          => @ <nT>, <nL> CLEAR TO <nB>, <nR>          ;  ;
             @ <nT>, <nL>, <nB>, <nR> BOX B_SINGLE

#define clrget   IIF( IsColor(), "W+/B,W+/RB,,,W/RB", "N/W,W+/N,,,W/N" )

*-----------------------------------------------
// File-wide statics

STATIC cInPath, cOutPath

*-----------------------------------------------
FUNCTION Main()
//  Create a file to be used as input to Expert Help Compiler

LOCAL nRowDos  := ROW()
LOCAL nColDos  := COL()
LOCAL cClrDos  := SETCOLOR()
LOCAL cScrDos  := SAVESCREEN( 00, 00, MAXROW(), MAXCOL() )
LOCAL nCurDos  := SETCURSOR( SC_NONE )
LOCAL GetList  := {}

*.... default paths for input and output files
***cInPath  := PadR("\clipper5\include\",26)
cInPath  := PadR("\cl501\include\",26)
cOutPath := Space(26)

SET SCOREBOARD Off
CLS

*.... get paths
SETCOLOR( clrget )
Window( 06, 13, 12, 63 )
SETCURSOR( SC_NORMAL )
@ 08, 17 SAY "Path to std.ch"
@ 10, 17 SAY "Output Path   "
@ 08, 33 GET cInPath  VALID FILE( TRIM(cInPath) + "std.ch" )
@ 10, 33 GET cOutPath VALID FILE( TRIM(cOutPath) + "Nul" )
READ

*.... Create file
IF LASTKEY() <> K_ESC
  CreateFile()
ENDIF

*.... restore the DOS environment and quit
SETCOLOR( cClrDos )
RESTSCREEN( 00, 00, MAXROW(), MAXCOL(), cScrDos )
SETPOS( nRowDos, nColDos )
SETCURSOR( nCurDos )

RETURN Nil

*-----------------------------------------------
STATIC FUNCTION CreateFile()
// Create the file (stdch.txt)
// Syntax:  CreateFile()
// Return:  Nil

/* New sections in std.ch are identified with...

   ***
   *  xxxxxxxxxxxxxxxxxx
   *

 where xxxxxxxxxxxxxxxxxx == Section heading used in NG index

  For some reason the last section "Close" didn't get a title, so I
  hard-coded the "//Note" they used to identify a section change.

*/

LOCAL nHdlIn := FT_FUSE( TRIM(cInPath) + "std.ch" )
LOCAL cTitle := Space(50)
LOCAL cLine

SET ALTERNATE TO ( TRIM(cOutPath) + "stdch" )
SET ALTERNATE ON

??"'-----------------------------------------------------------------"
? "'   STD.CH  Clipper standard language definitions."
? "'   Copyright (c) 1990,1991 Nantucket Corp.  All rights reserved."
? "'-----------------------------------------------------------------"
? ""

DO WHILE ! FT_FEOF()

  cLine := FT_FREADLN()

  *... special considerations for Close functions which don't have title
  IF LEFT( cLine, 7 ) == "// NOTE"
    ? "^C20"
    ? "!SeeAlso:"
    ? "'-----------------------------------------------------------------"
    ? ""
    cTitle := " Close"
    ? "!Short:" + cTitle
    ? "^u" + cTitle
    FT_FSKIP()
    ? ""
    FT_FSKIP()
    cLine := FT_FREADLN()      // read a normal line
  ENDIF

  *... new section
  IF LEFT( cLine, 3 ) == "***"
    IF ! Empty( cTitle )       // end previous section
      ? "^C20"
      ? "!SeeAlso:"
      ? "'-----------------------------------------------------------------"
      ? ""
    ENDIF
    FT_FSKIP()
    cLine  := FT_FREADLN()     // line with title
    cTitle := " " + ALLTRIM( SUBS( cLine, 2 ) )
    ? "!Short:" + cTitle
    ? "^u" + cTitle
    FT_FSKIP()
    cLine := FT_FREADLN()      // line with an asterisk
    ? ""
    FT_FSKIP()
    cLine := FT_FREADLN()      // read a normal line
  ENDIF

  ? " " + cLine                // add line to file
  FT_FSKIP()

ENDDO

? "^C20"
? "SeeAlso"

FT_FUSE()            // close input file
SET ALTERNATE OFF    // close output file
RETURN Nil

*-----------------------------------------------
* eof stdchng.prg
