/*Ŀ
  Program....: STCHECK.C    4 func. - isstate(), isprov(), state(), prov() 
  Written for: Clipper Spring 87.                                          
  Author.....: Eric E. Osmann                                              
  Notice.....: Control Software Systems (c), 1988  All Rights Reserved.    
  Address....:(new): 4191 Farquhar Ave. Los Alimitos, CA. 90720.           
  Address....:(old): 14008 Edgewater Dr. Norwalk, CA. 90650 Until Sept 8/88
  Date.......: Monday, August  5, 1988.                      (213) 864-2736
  Note.......: If you like this program, and find it of use, then your     
  ...........: contribution will be appreciated.                           
  To compile.: I used MicroSoft C Version 5.1 (c), however early versions  
  ...........: may work just fine, I use the following commands:           
  ...........:  CL /c /AL /Zi /Oalt /Gs stcheck.c                          
  ...........:  /c    = Compiles without linking.                          
  ...........:  /AL   = Compile large model                                
  ...........:  /Zi   = Generate symbolic info. for MicroSoft CodeView (c) 
  ...........:  /Oalt = Control optimization (Favors execution speed).     
  ...........:  /Gs   = Removes calls to the stack-checking routine.       
 */

#include <extend.h>                      /* Clipper's extend system.       */

#define TRUE      1
#define FALSE     0
#define STATES    51
#define PROVINCES 12

/*Ŀ
  Structure for both Canada and USA.                                       
 */
struct States {
       char State[22];
       char Abbrev[5];
              };

/*Ŀ
  United States of America                                                 
 */
struct States America[ STATES ] = {
              { "Alabama", "AL" },
              { "Alaska", "AK" },
              { "Arizona", "AZ" },
              { "Arkansas", "AR" },
              { "California", "CA" },
              { "Colorado", "CO" },
              { "Connecticut", "CT" },
              { "Delaware", "DE" },
              { "District of Columbia", "DC" },
              { "Florida", "FL" },
              { "Georgia", "GA" },
              { "Hawaii", "HI" },
              { "Idaho", "ID" },
              { "Illinois", "IL" },
              { "Indiana", "IN" },
              { "Iowa", "IA" },
              { "Kansas", "KS" },
              { "Kentucky", "KY" },
              { "Louisiana", "LA" },
              { "Maine", "ME" },
              { "Maryland", "MD" },
              { "Massachusetts", "MA" },
              { "Michigan", "MI" },
              { "Minnesota", "MN" },
              { "Mississippi", "MS" },
              { "Missouri", "MO" },
              { "Montana", "MT" },
              { "Nebraska", "NE" },
              { "Nevada", "NV" },
              { "New Hampshire", "NH" },
              { "New Jersey", "NJ" },
              { "New Mexico", "NM" },
              { "New York", "NY" },
              { "North Carolina", "NC" },
              { "North Dakota", "ND" },
              { "Ohio", "OH" },
              { "Oklahoma", "OK" },
              { "Oregon", "OR" },
              { "Pennsylvania", "PA" },
              { "Rhode Island", "RI" },
              { "South Carolina", "SC" },
              { "South Dakota", "SD" },
              { "Tennessee", "TN" },
              { "Texas", "TX" },
              { "Utah", "UT" },
              { "Vermont", "VT" },
              { "Virginia", "VA" },
              { "Washington", "WA" },
              { "West Virginia", "WV" },
              { "Wisconsin", "WI" },
              { "Wyoming", "WY" }
                                  };

/*Ŀ
  Canadian provinces follow below.                                         
 */
struct States Canada[12] = {
              { "Alberta", "ALTA"},
              { "British Columbia", "B.C." },
              { "Manitoba", "MAN " },
              { "New Brunswick", "N.B." },
              { "Newfoundland", "NFLD" },
              { "Northwest Territories", "NWT "},
              { "Nova Scotia", "N.S." },
              { "Ontario", "ONT " },
              { "Prince Edward Island", "PEI " },
              { "Quebec", "QUE " },
              { "Saskatchewan", "SASK" },
              { "Yukon Territories", "Y.T." }
                            };

/*Ŀ
  Returned is a logical .T. if valid or .F. if not valid.                  
 */
CLIPPER isstate( )               /* Check to see if state is valid, return  */
{                                /* logical .T. if so.                      */
                                 /* Usage: VALID( isstate("CA") )           */
    int i = 0, Found = 1;
    while( i < STATES && Found != 0 ) 
       Found = StrComp( _parc( 1, 0 ), America[i++].Abbrev );
    if( Found != 0 )
      _retl( FALSE );            /* Return to clipper .F. for no find.      */
    else 
      _retl( TRUE );             /* Return to clipper .T. for found name.   */
}


/*Ŀ
  Returned is a logical .T. if valid or .F. if not valid.                  
 */
CLIPPER isprov( )                /* Check to see if state is valid, return  */
{                                /* logical .T. if so.                      */
                                 /* Usage: VALID( isprov("B.C.") )          */
    int i = 0, Found = 1;
    while( i < PROVINCES && Found != 0 ) 
       Found = StrComp( _parc( 1, 0 ), Canada[i++].Abbrev );
    if( Found != 0 )
      _retl( FALSE );            /* Return to clipper .F. for no find.      */
    else 
      _retl( TRUE );             /* Return to clipper .T. for found name.   */
}


/*Ŀ
  Returned is the states full name if found and null if not found.         
 */
CLIPPER state( )                  /* Find abbr. and return with state name. */
{                                 /* Usage: ? state("ID")  && Prints "Idaho"*/
    int i = 0, Found = 1;
    char *ptr;
    while( i < STATES && Found != 0 ) 
       Found = StrComp( _parc( 1, 0 ), America[i++].Abbrev );
    ptr = America[--i].State;     /* Point to state name.                   */
    if( !Found )
      _retc( ptr );               /* Return to clipper the state name.      */
    else 
      _retc( " " );               /* Return to clipper a null (blank).      */
}


/*Ŀ
  Returned is the provinces full name if found and null if not found.      
 */
CLIPPER prov( )                   /* Find abbr. and return with state name. */
{                                 /* Usage: ? prov("SASK") && "Saskatchewan"*/
    int i = 0, Found = 1;
    char *ptr;
    while( i < PROVINCES && Found != 0 ) 
       Found = StrComp( _parc( 1, 0 ), Canada[i++].Abbrev );
    ptr = Canada[--i].State;      /* Point to province name.                */
    if( !Found )                  /* If Found = 0.                          */
      _retc( ptr );               /* Return to clipper the province name.   */
    else 
      _retc( " " );               /* Return to clipper a null (blank).      */
}


/*Ŀ
  StrComp (String Compare function) Similar to strcmp() in the C library.  
  Compares each character of string s to string t, if the test fails,      
  returned is the decimal value of string s - string t, else if equal 0.   
 */
StrComp ( char *s, char *t )           /* Compare strings function.         */
{
  int i;
  for ( i = 0; s[i] == t[i]; s++, t++ )
     if ( *s == '\0' )                 /* If string = NULL character then it*/
        return 0;                      /*  be equal to string t.            */
  return *s - *t;                      /* Return the difference.            */
}   /*> End of function: StrComp()         */



