* Program Name: statezip.prg *
* Author: Ken Camp *
* (c) 1988 by Ken Camp - 1988 *
**************************************************************************
* Created: 7/7/1988 at 14:44                                             *
*************************** ALL RIGHTS RESERVED **************************
*
*   This routine contains two functions for Clipper Summer '87 (although
*   they may work with Autumn '86). The first is a state code validation
*   which I found elsewhere in PD and made very minor changes to. I'd give
*   the original author credit if I knew who saved me the work of typing
*   it from scratch. The second is a ZIP code validation based on a database
*   I found listing ZIP code ranges by state.
*   NOTE: Some US territories are validated, but I did not know the
*         correct ZIPs for Canal Zone (CZ) so no ZIP code checking is done
*         there.
*
*   The memory variable shown need to be initialized, but feel free to call
*   call them whatever you like. Make any changes yuo wish to this code.
*
*   This code released to the public domain with no guarantees expressed
*   or implied..........works for me.
*
* The 1st memvar is the 2 char state codes to check against
STORE "AL/AK/AZ/AR/CA/CZ/CO/CT/DE/DC/FL/GA/GU/HI/ID/IL/IN/IA/KS/"+;
"KY/LA/ME/MD/MA/MI/MN/MS/MO/MT/NE/NV/NH/NJ/NM/NY/NC/ND/OH/OK"+;
"/OR/PA/PR/RI/SC/SD/TN/TX/UT/VT/VA/VI/WA/WV/WI/WY/" TO mSTATECODE
mSTATE = SPACE(2)
mZIP = 00000                                     && I use numeric ZIPs

FUNCTION STATECHK
    *
    *   The state abbreviation function is used in this fashion:
    *   @ ROW,COL SAY "Enter State CODE" GET mSTATE PICTURE "XX" VALID(STATECHK())
    *
    PRIVATE OK                                   && funtion loop control var
    IF MSTATE $ mSTATECODE                       && check validity against list
        OK=.T.                                   && bounce a good one right back
    ELSE
        OK=.F.                                   && go into error
        curr_color = SETCOLOR()                  && colors are here to show how to
        SAVE SCREEN TO FILLSCRN                  && use the SETCOLOR() function
        SETCOLOR("W+/R")
        @ 10,40 SAY      'ͻ'
        @ ROW()+1,38 SAY '  INVALID STATE ABBREVIATION    '
        @ ROW()+1,38 SAY '   Press any key to continue    '
        @ ROW()+1,38 SAY 'ͼ'
        DO WHILE INKEY()=0
        ENDDO
        SETCOLOR(curr_color)
        RESTORE SCREEN FROM FILLSCRN
    ENDIF
RETURN(OK)



FUNCTION ZIPCHECK
    *   The ZIPCHECK is used to validate a range of ZIP codes based on
    *   2 character state codes used above.
    *   NOTE: ZIP code is not validated for the Canal Zone (CZ)
    *
    *   SYNTAX:
    *   @ ROW,COL SAY "Enter ZIP Code:" GET mZIP PICTURE "99999" VALID(ZIPCHECK())

    PRIVATE OK
    IF mSTATE = "AK" .AND. (mZIP > 99500 .AND. mZIP < 99999) .OR.;
        mSTATE = "AL" .AND. (mZIP > 35000 .AND. mZIP < 36999) .OR.;
        mSTATE = "AR" .AND. (mZIP > 71500 .AND. mZIP < 72899) .OR.;
        mSTATE = "AZ" .AND. (mZIP > 85000 .AND. mZIP < 86599) .OR.;
        mSTATE = "CA" .AND. (mZIP > 90000 .AND. mZIP < 96699) .OR.;
        mSTATE = "CO" .AND. (mZIP > 80000 .AND. mZIP < 81699) .OR.;
        mSTATE = "CT" .AND. (mZIP > 06000 .AND. mZIP < 06999) .OR.;
        mSTATE = "DC" .AND. (mZIP > 20000 .AND. mZIP < 20599) .OR.;
        mSTATE = "DE" .AND. (mZIP > 19700 .AND. mZIP < 19999) .OR.;
        mSTATE = "FL" .AND. (mZIP > 32000 .AND. mZIP < 34299) .OR.;
        mSTATE = "GA" .AND. (mZIP > 30000 .AND. mZIP < 31999) .OR.;
        mSTATE = "GU" .AND. (mZIP > 96900 .AND. mZIP < 96999) .OR.;
        mSTATE = "HI" .AND. (mZIP > 96700 .AND. mZIP < 96899) .OR.;
        mSTATE = "IA" .AND. (mZIP > 50000 .AND. mZIP < 52699) .OR.;
        mSTATE = "ID" .AND. (mZIP > 83200 .AND. mZIP < 83899) .OR.;
        mSTATE = "IL" .AND. (mZIP > 60000 .AND. mZIP < 62999) .OR.;
        mSTATE = "IN" .AND. (mZIP > 46000 .AND. mZIP < 47999) .OR.;
        mSTATE = "KS" .AND. (mZIP > 66000 .AND. mZIP < 67999) .OR.;
        mSTATE = "KY" .AND. (mZIP > 40000 .AND. mZIP < 42799) .OR.;
        mSTATE = "LA" .AND. (mZIP > 70000 .AND. mZIP < 71499) .OR.;
        mSTATE = "MA" .AND. (mZIP > 01000 .AND. mZIP < 02799) .OR.;
        mSTATE = "MD" .AND. (mZIP > 20600 .AND. mZIP < 21999) .OR.;
        mSTATE = "ME" .AND. (mZIP > 03900 .AND. mZIP < 04999) .OR.;
        mSTATE = "MI" .AND. (mZIP > 48000 .AND. mZIP < 49999) .OR.;
        mSTATE = "MN" .AND. (mZIP > 55000 .AND. mZIP < 56799) .OR.;
        mSTATE = "MO" .AND. (mZIP > 63000 .AND. mZIP < 65899) .OR.;
        mSTATE = "MS" .AND. (mZIP > 38600 .AND. mZIP < 39799) .OR.;
        mSTATE = "MT" .AND. (mZIP > 59000 .AND. mZIP < 59999) .OR.;
        mSTATE = "NB" .AND. (mZIP > 68000 .AND. mZIP < 69399) .OR.;
        mSTATE = "NC" .AND. (mZIP > 27000 .AND. mZIP < 28999) .OR.;
        mSTATE = "ND" .AND. (mZIP > 58000 .AND. mZIP < 58899) .OR.;
        mSTATE = "NH" .AND. (mZIP > 03000 .AND. mZIP < 03899) .OR.;
        mSTATE = "NJ" .AND. (mZIP > 07000 .AND. mZIP < 08999) .OR.;
        mSTATE = "NM" .AND. (mZIP > 87000 .AND. mZIP < 88499) .OR.;
        mSTATE = "NV" .AND. (mZIP > 88900 .AND. mZIP < 89899) .OR.;
        mSTATE = "NY" .AND. (mZIP > 09000 .AND. mZIP < 14999) .OR.;
        mSTATE = "OH" .AND. (mZIP > 43000 .AND. mZIP < 45899) .OR.;
        mSTATE = "OK" .AND. (mZIP > 73000 .AND. mZIP < 74999) .OR.;
        mSTATE = "OR" .AND. (mZIP > 97000 .AND. mZIP < 97999) .OR.;
        mSTATE = "PA" .AND. (mZIP > 15000 .AND. mZIP < 19699) .OR.;
        mSTATE = "PR" .AND. (mZIP > 00600 .AND. mZIP < 00999) .OR.;
        mSTATE = "RI" .AND. (mZIP > 02800 .AND. mZIP < 02999) .OR.;
        mSTATE = "SC" .AND. (mZIP > 29000 .AND. mZIP < 29999) .OR.;
        mSTATE = "SD" .AND. (mZIP > 57000 .AND. mZIP < 57799) .OR.;
        mSTATE = "TN" .AND. (mZIP > 37000 .AND. mZIP < 38599) .OR.;
        mSTATE = "TX" .AND. (mZIP > 75000 .AND. mZIP < 79999) .OR.;
        mSTATE = "UT" .AND. (mZIP > 84000 .AND. mZIP < 84799) .OR.;
        mSTATE = "VA" .AND. (mZIP > 22000 .AND. mZIP < 24699) .OR.;
        mSTATE = "VI" .AND. (mZIP > 00800 .AND. mZIP < 00899) .OR.;
        mSTATE = "VT" .AND. (mZIP > 05000 .AND. mZIP < 05999) .OR.;
        mSTATE = "VW" .AND. (mZIP > 24700 .AND. mZIP < 26899) .OR.;
        mSTATE = "WA" .AND. (mZIP > 98000 .AND. mZIP < 99499) .OR.;
        mSTATE = "WI" .AND. (mZIP > 53000 .AND. mZIP < 54999) .OR.;
        mSTATE = "WY" .AND. (mZIP > 82000 .AND. mZIP < 83199) .OR.;
        mSTATE = "CZ"
        OK=.T.
    ELSE
        OK=.F.
        SAVE SCREEN TO FILLSCRN
        curr_color = SETCOLOR()
        SETCOLOR("W+/R")
        @ 10,35 SAY      'ͻ'
        @ ROW()+1,35 SAY '  The ZIP code you entered does    '
        @ ROW()+1,35 SAY '  not match the range of valid     '
        @ ROW()+1,35 SAY '  ZIP codes for   . Please enter   '
        @ ROW()+1,35 SAY '  a zip code in the correct range. '
        @ ROW()+1,35 SAY '                                   '
        @ ROW()+1,35 SAY '    Press any key to continue      '
        @ ROW()+1,35 SAY 'ͼ'
        @ ROW()-4,52 SAY mSTATE
        DO WHILE INKEY()=0
        ENDDO
        SETCOLOR(curr_color)
        RESTORE SCREEN FROM FILLSCRN
    ENDIF
RETURN(OK)



