/*----------------------------------------------------------------------------

   STATUS version 1.01
   (c) 1992 John T. Opincar, Jr.
   CID: 71631,541
   02/27/92 
 
   PLEASE READ THIS!
                                       
   You are free to distribute STATUS in any manner you choose and use STATUS
   in any setting, including commercial without any obligation to me.  The
   only thing that I ask is that you do not distribute modified versions of
   STATUS without including the original code and documentation in its
   entirety.  If you feel inclined to distribute STATUS with your own 
   modifications (which I would discourage), ***PLEASE*** keep your changes
   in seperate files, and make the seperation and changes obvious to anyone
   who might subsequently encounter the ZIP.
 
   I have been informally supporting STATUS on CIS, and do not want a zillion
   messages about problems introduced by others.  In lieu of making your own
   changes, I would prefer that you send me mail describing the additional
   features you would like to see in STATUS.  The exceptional performance
   gains yielded by STATUS are the result of several key assumptions about 
   how it will be used.  Before making a suggestion, please read the section
   in the documentation entitled, "What Makes STATUS Tick." The main 
   motivation behind this version of STATUS was input I received from users.
 
----------------------------------------------------------------------------*/

#include "extend.h"
#include "clipdbf.h"
#include "status.ch"

extern int _gtMaxRow();      /* Clipper internal function returning max row */
extern int _gtMaxCol();      /* Clipper internal function returning max column */
extern int _gtIsColor();     /* Clipper internal function returning iscolor */

extern void timerOn();       /* Declare functions defined in timentxa.asm */
extern void timerOff();

extern int barOffset;        /* Offset into video mem for bar display */
extern int barChar;          /* Character to be used in bar */
extern int barColor;         /* Color to be used for bar */ 
extern int barActive;        /* Flag, non-zero if bar is to be used */  

extern int numOffset;        /* Offset into video mem for number display */
extern int numColor;         /* Color to be used for number display */ 
extern int numActive;        /* Flag, non-zero if number is to be used */

extern int ticks;            /* Number of ticks (18/second) between updates */
extern int isColor;          /* Flag, non-zero if color monitor present */
extern int active;           /* Flag, non-zero if currently displaying */
extern long lastRec;         /* Number of records in database */
extern long *recnoPtr;       /* Pointer to recno() value */
                  
char coltable[16][4] = {"N", "B", "G", "BG", "R", "BR", "GR", "W", "N+", "B+", "G+", "BG+", "R+", "BR+", "GR+", "W+"};

/*--------------------------------_VCOLTONUM----------------------------------*/

int _vcoltonum(char *color) {
  int i = -1, found = 0;
  char *colptr, *cptr, temp;

  colptr = color;
  while (*colptr) {
    if ((*colptr >= 'a') && (*colptr <= 'z')) {
      *colptr -= 32;
    }
    colptr++;
  }
  colptr = color + 1;
  if ( (*colptr != '\0') && (*colptr != '+') && (*colptr < *color) ) {
    temp = *color;
    *color = *colptr;
    *colptr = temp;
  }
  while ( (i < 15) && !found ) {
    colptr = color;
    cptr = coltable[++i];
    while ( (found = (*colptr == *cptr)) && *colptr++ && *cptr++ ) {};
  }
  return(i);
}

/*-------------------------------_VCOLTOATTR----------------------------------*/

int _vcoltoattr(char *color) {
  char *colptr;

  colptr = color;
  while ( *colptr ) {
    if ( *colptr == '/' ) {
      *colptr++ = '\0';
      break;
    } else {
      colptr++;
    }
  }
  return( (_vcoltonum(colptr) * 16) + _vcoltonum(color) );
}

/*--------------------------------STATUSBAR---------------------------------*/

CLIPPER STATUSBAR() {
/* function statusBar(nRow, nCol, uChar, uColor) */

  if ( (PCOUNT != 1) && (PCOUNT != 4) ) {
    _retni(BAD_PARM_COUNT);
    return;
  }

  if ( !ISNUM(1) ) {
    _retni(TYPE_MISMATCH);
    return;
  }

  /* If nRow passed is less than zero, then disable bar display */
  if ( _parni(1) < 0 ) {
    barActive = 0;
    _retni(0);
    return;
  }

  if ( !(ISNUM(2) && (ISNUM(3) || ISCHAR(3)) && (ISNUM(4) || ISCHAR(4))) ) {
    _retni(TYPE_MISMATCH);
    return;
  }

  if ( (_parni(1) < 0) || (_parni(1) > _gtMaxRow()) ||
       (_parni(2) < 0) || (_parni(2) > _gtMaxCol()) ) {
    _retni(BAD_COORDS);
    return;
  }
  barOffset = (((_gtMaxCol() + 1) * _parni(1)) + _parni(2)) * 2;


  if ( ISNUM(3) ) {
    barChar = _parni(3);
  } else {
    barChar = *(_parc(3));
  }

  if ( ISNUM(4) ) {
    barColor = _parni(4);
  } else {
    barColor = _vcoltoattr(_parc(4));
  }
  
  barActive = 1;
  _retni(0);
}

/*-------------------------------STATUSNUMBER-------------------------------*/

CLIPPER STATUSNUMB() {
/* function statusNumber(nRow, nCol, uColor) */
      
  if ( (PCOUNT != 1) && (PCOUNT != 3) ) {
    _retni(BAD_PARM_COUNT);
    return;
  }

  if ( !ISNUM(1) ) {
    _retni(TYPE_MISMATCH);
    return;
  }

  /* If nRow passed is less than zero, then disable number display */
  if ( _parni(1) < 0 ) {
    numActive = 0;
    _retni(0);
    return;
  }

  if ( !(ISNUM(2) && (ISNUM(3) || ISCHAR(3))) ) {
    _retni(TYPE_MISMATCH);
    return;
  }

  if ( (_parni(1) < 0) || (_parni(1) > _gtMaxRow()) ||
       (_parni(2) < 0) || (_parni(2) > _gtMaxCol()) ) {
    _retni(BAD_COORDS);
    return;
  }
  numOffset = (((_gtMaxCol() + 1) * _parni(1)) + _parni(2)) * 2;


  if ( ISNUM(3) ) {
    numColor = _parni(3);
  } else {
    numColor = _vcoltoattr(_parc(3));
  }
  
  numActive = 1;
  _retni(0);
}

/*---------------------------------STATUSON---------------------------------*/

CLIPPER STATUSON() {
/* statusOn([nTicks]) */

  if ( PCOUNT > 1 ) {
    _retni(BAD_PARM_COUNT);
    return;
  }
  if ( (PCOUNT == 1) && !ISNUM(1) ) {
    _retni(TYPE_MISMATCH);
    return;
  }
  if ( PCOUNT == 1 ) {
    ticks = _parni(1);
  } else {
    ticks = 18;
  }
  if ( ticks <= 0 ) {
    _retni(BAD_TICKS);
    return;
  }
  if ( (*_Workareas)[0] == NULL ) {
    _retni(NO_DBF_USED);
    return;
  }
  if ( (*_Workareas)[0]->indexord != 0 ) {
    _retni(BAD_ORDER);
    return;
  }
  isColor = _gtIsColor();
  recnoPtr = &((*_Workareas)[0]->recno);
  lastRec = (*_Workareas)[0]->lastrec;
  if ( lastRec > 0 ) {
    timerOn();
  }
  _retni(0);
}

/*--------------------------------STATUSOFF---------------------------------*/

CLIPPER STATUSOFF() {
  timerOff();
  _retni(0);
}

