#include "box.ch"             

#define BORDCOLOR   'w+/n'
#define NORMCOLOR   'w/n'
#define HIGHCOLOR   'w+/r'
#define BARCHAR     ''

/*----------------------------------MYSAY-----------------------------------*/

function mySay(nRow, nCol, sMessage, sColor)

* begin
  setPos(nRow, nCol)
  dispOut(sMessage, sColor)
return NIL

/*--------------------------------STATUSPACK--------------------------------*/

function statusPack(sDbfName, aNtxInfo)

local lSuccess := .f., nOldArea := select(), nNtxCount := len(aNtxInfo)
local nRow, sScreen, nI, nOldCursor := setCursor(0)

begin sequence
  dbSelectArea(select(sDbfName))
  dbUseArea(,, sDbfName, .f., .f.)
  if ( netErr() )
    break
  endIf

  if ( aNtxInfo == NIL )
    aNtxInfo := {}
  endIf
  
  nRow := int(((maxRow() + 1) - (nNtxCount + 3)) / 2)
  sScreen := saveScreen(nRow, 1, nRow + nNtxCount + 2, 78)
  dispBox(nRow, 1, nRow + nNtxCount + 2, 78, B_SINGLE + ' ', BORDCOLOR)
  mySay(nRow + 1, 2, padl('Packing ' + sDbfName + ':', 19) + ' ' + space(50) + '    % ', NORMCOLOR)
  for nI := 1 to nNtxCount
    mySay(nRow + nI + 1, 2, padl('Building ' + aNtxInfo[nI,1] + ':', 19) + ' ' + space(50) + '    % ', NORMCOLOR)
  next nI
  
  mySay(nRow + 1, 2, padl('Packing ' + sDbfName + ':', 19) + ' ' + space(50) + '    % ', HIGHCOLOR)
  statusBar(nRow + 1, 22, BARCHAR, HIGHCOLOR)
  statusNumber(nRow + 1, 73, HIGHCOLOR)
  statusOn(18)
  pack                    
  statusOff()
  mySay(nRow + 1, 2, padl('Packing ' + sDbfName + ':', 19) + ' ' + replicate(BARCHAR, 50) + ' 100% ', NORMCOLOR)
  for nI := 1 to nNtxCount
    dbClearIndex()
    dbGoTop()
    mySay(nRow + nI + 1, 2, padl('Building ' + aNtxInfo[nI,1] + ':', 19) + ' ' + space(50) + '    % ', HIGHCOLOR)
    statusBar(nRow + nI + 1, 22, BARCHAR, HIGHCOLOR)
    statusNumber(nRow + nI + 1, 73, HIGHCOLOR)
    statusOn(18)
    dbCreateIndex(aNtxInfo[nI,1], aNtxInfo[nI,2], &('{|| ' + aNtxInfo[nI,2] + '}'))
    statusOff()
    mySay(nRow + nI + 1, 2, padl('Building ' + aNtxInfo[nI,1] + ':', 19) + ' ' + replicate(BARCHAR, 50) + ' 100% ', NORMCOLOR)
  next nI
  use                 

  restScreen(nRow, 1, nRow + nNtxCount + 2, 78, sScreen)
end sequence
  select (nOldArea)
  setCursor(nOldCursor)
return lSuccess
