;-----------------------------------------------------------------------------
;
;  STATUS version 1.01
;  (c) 1992 John T. Opincar, Jr.
;  CID: 71631,541
;  02/27/92 
;
;  PLEASE READ THIS!
;                                      
;  You are free to distribute STATUS in any manner you choose and use STATUS
;  in any setting, including commercial without any obligation to me.  The
;  only thing that I ask is that you do not distribute modified versions of
;  STATUS without including the original code and documentation in its
;  entirety.  If you feel inclined to distribute STATUS with your own 
;  modifications (which I would discourage), ***PLEASE*** keep your changes
;  in seperate files, and make the seperation and changes obvious to anyone
;  who might subsequently encounter the ZIP.
;
;  I have been informally supporting STATUS on CIS, and do not want a zillion
;  messages about problems introduced by others.  In lieu of making your own
;  changes, I would prefer that you send me mail describing the additional
;  features you would like to see in STATUS.  The exceptional performance
;  gains yielded by STATUS are the result of several key assumptions about 
;  how it will be used.  Before making a suggestion, please read the section
;  in the documentation entitled, "What Makes STATUS Tick." The main 
;  motivation behind this version of STATUS was input I received from users.
;
;-----------------------------------------------------------------------------

DOSSEG
.MODEL      LARGE

PUBLIC      _barOffset, _barChar, _barColor, _barActive
PUBLIC      _numOffset, _numColor, _numActive
PUBLIC      _ticks, _isColor, _active, _lastRec, _recnoPtr
PUBLIC      _timeron, _timeroff

EXTRN       __aFldiv:FAR        ;MS C runtime library routine for dividing longs
EXTRN       setint:FAR          ;see ints.asm

.DATA
_barOffset  dw      0           ;offset into video memory for bar display
_barChar    dw      176         ;character to be used for bar display
_barColor   dw      7           ;color attribute for bar display
_barActive  dw      1           ;non-zero if bar display is to be used

_numOffset  dw      160         ;offset into video memory for number display
_numColor   dw      7           ;color attribute for number display
_numActive  dw      1           ;non-zero if number display is to be used

_ticks      dw      18          ;number of timer ticks between display updates
_isColor    dw      1           ;non-zero if color monitor present
_active     dw      0           ;non-zero if display is active
_lastRec    dd      1           ;number of records in the database
_recnoPtr   dd      0           ;pointer to the current record #

installed   dw      0           ;non-zero if timer isr has been installed
tickcount   dw      0           ;number of ticks until next display update
lastPercent dw      0           ;0 <= lastPercent <=50, last displayed percent
old8h       dw      2 dup(0)    ;old timer interrupt vector

.CODE

;----------------------------------_TIMERON-------------------------------------

;PURPOSE: Initializes progress display.  Installs timer routine if not yet
;         installed

_timeron    proc    far
            cmp     installed,0         ;see if timer routine installed
            jne     setactive

            mov     ax,SEG timerctrl    ;install timer int
            push    ax
            mov     ax,OFFSET timerctrl
            push    ax
            mov     ax,08h
            push    ax
            call    SETINT
            add     sp,6
            mov     old8h[0],ax         ;save old timer interrupt vector
            mov     old8h[2],dx
            mov     installed,1

setactive:  mov     bx,0b000h           ;load proper video segment
            cmp     _isColor,0
            je      notcolor3
            mov     bx,0b800h
notcolor3:  mov     es,bx

            mov     di,_numOffset
            add     di,4
            mov     ax,_numColor
            mov     BYTE PTR es:[di],'0'        ;show 0 percent
            mov     es:[di + 1],al

            mov     ax,_ticks
            mov     tickcount,ax
            mov     lastPercent,0
            mov     _active,1
            ret
_timeron    ENDP

;---------------------------------_TIMEROFF-------------------------------------

;PURPOSE: Turns of progress display.

_timeroff   proc    far
            push    es
            push    di

            mov     _active,0           ;disable progress display

            mov     bx,0b000h           ;load proper video segment
            cmp     _isColor,0
            je      notcolor2
            mov     bx,0b800h
notcolor2:  mov     es,bx

            cmp     _barActive,0        ;is bar active?
            je      noBar

            mov     ax,50               ;fill in complete bar
            mov     di,_barOffset
            mov     bx,_barChar
            mov     cx,_barColor
            mov     bh,cl
bloop:      mov     es:[di],bx
            add     di,2
            dec     ax
            jnz     bloop
            
noBar:      cmp     _numActive,0        ;is number active?
            je      offDone

            mov     di,_numOffset
            mov     ax,_numColor
            mov     BYTE PTR es:[di],'1'        ;show 100 percent
            mov     es:[di + 1],al
            mov     BYTE PTR es:[di + 2],'0'
            mov     es:[di + 3],al
            mov     BYTE PTR es:[di + 4],'0'
            mov     es:[di + 5],al

offdone:    pop     di
            pop     es
            ret
_timeroff   ENDP

;----------------------------------TIMERCTRL-------------------------------------

oldtimer    label   dword
cs_old8h    dw      2 dup(?)

TIMERCTRL   proc    far
            pushf
            push    ds

            push    cx                  ;load old timer address into code seg
            mov     cx,DGROUP
            mov     ds,cx
            assume  ds:DGROUP
            mov     cx,old8h
            mov     cs:cs_old8h,cx
            mov     cx,old8h[2]
            mov     cs:cs_old8h[2],cx
            pop     cx

            cmp     _active,0           ;see if we're active
            jne     decrement
            jmp     calloldtime

decrement:  dec     tickcount           ;check for need to update display
            jz      rollover
            jmp     calloldtime

rollover:   push    ax
            push    bx
            push    cx
            push    dx
            push    si
            push    di
            push    es

            mov     ax,_ticks           ;reset tickcount
            mov     tickcount,ax

            les     si,_recnoPtr
            mov     ax,es:[si]
            add     si,2
            mov     dx,es:[si]

            shl     ax,1                ;ax:dx = (recno() * 50), uses shift-add
            rcl     dx,1                ;technique to avoid long multiply
            mov     bx,ax
            mov     cx,dx
            shl     ax,1
            rcl     dx,1
            shl     ax,1
            rcl     dx,1
            shl     ax,1
            rcl     dx,1
            add     bx,ax
            adc     cx,dx
            shl     ax,1
            rcl     dx,1
            add     ax,bx
            adc     dx,cx

            mov     bx,WORD PTR _lastRec[2]     ;load up for call to long div
            push    bx
            mov     bx,WORD PTR _lastRec[0]
            push    bx
            push    dx
            push    ax
            call    FAR PTR __aFldiv            ;note, no stack clean up needed
                                                ;here.  Very strange.

            mov     cx,ax                       ;see if we really need to
            sub     ax,lastPercent              ;update display
            jbe     restoreregs

            push    cx
            mov     bx,0b000h           ;load video segment
            cmp     _isColor,0
            je      notcolor
            mov     bx,0b800h
notcolor:   mov     es,bx

            cmp     _barActive,0        ;is bar display active?
            je      noBar2

            mov     bx,_barChar         ;fill in bar extension from last call
            mov     cx,_barColor
            mov     bh,cl
            mov     di,_barOffset
            add     di,lastPercent
            add     di,lastPercent
barloop:    mov     es:[di],bx
            add     di,2
            dec     ax
            jnz     barloop

noBar2:     cmp     _numActive,0        ;is number active?
            je      storelp

            pop     ax                  ;display progress as percent number
            push    ax
            shl     ax,1
            mov     di,_numOffset
            add     di,4
            mov     bx,10
            mov     cx,_numColor

numloop:    cmp     ax,0
            je      storelp
            div     bl
            add     ah,48
            mov     es:[di],ah   
            mov     es:[di + 1],cl
            sub     ah,ah
            sub     di,2
            jmp     numloop

storelp:    pop     cx                  ;set lastPercent to current position
            mov     lastPercent,cx

restoreregs:pop     es
            pop     di
            pop     si
            pop     dx
            pop     cx
            pop     bx
            pop     ax

calloldtime:pop     ds                  ;jump to old timer routine
            popf
            assume  ds:nothing
            jmp     oldtimer
TIMERCTRL   ENDP
            END
