echo off
rem
rem Demo of batch file stamp for system Foobar, assumed to comprise all PRG,
rem C, and ASM files in current directory.  Purpose of temporary batch file
rem rather than direct stamping in FOR command is to avoid occasional double
rem stamping of files.  Double stamping is harmless, but grating.
rem
rem Since STAMP.COM creates and renames temp file (with @s in extension), the
rem directory would be modified during the FOR command.  The FOR command makes
rem sequential pass through the directory once for each file specification.
rem DOS fills the first directory hole whenever a new file is created.
rem Because of all this, one double stamp could occur each pass.  Problem is
rem solved by postponing directory shuffles until FOR command is done.
rem
if %1x==x goto syntax
echo echo off >$$$.bat
for %%f in (*.PRG *.ASM *.C) do echo stamp %%f /SFoobar /D%1 /V%2 %3 >>$$$.bat
command /c $$$
del $$$.bat
goto end
:syntax
echo Supply date and version to stamp Foobar system files, e.g.,
echo .
echo                STAMPFOO 01-31-90 1.12
echo .
echo Optional /N as third parameter preserves file dates...
:end
