******************************************************************************
* Author   : Frank H. Sleeper                                                *
* Represent: Sleeper's Software                                              *
* Location : 3080 Marmil Ave. San Diego, CA 92139 (619) 470-1555             *
* Written  : March 13, 1991                                                  *
* Language : CLIPPER (Summer '87)                                            *
*   Contact us if you need lower overhead and/or speed increases. Request    *
*   the Turbo C  Tool Kit developed by Sleeper's Software for linking with   *
*   CLIPPER (Summer '87).                                                    *
******************************************************************************


******************************************************************************
Function Shadow
Parameters Top, Left, Bottom, Right
Private Area, Area2, Cnt, NewValue, BlinkOn
******************************************************************************
* Descrip  : Clipper capability of true shadowing
* Returns  : Nothing
* This routine will enable 'TRUE' shadowing for a specified area
* NOTE : To calculate memory required by SHADOW use the following method
*  (((Bottom-Top)+1)+((Right-Left)+1))*4 = X bytes
* Thus Shadow(0,0,24,79) will require 8000 Bytes
******************************************************************************

Area       = SaveScreen( Top, Left, Bottom, Right )
Area2      = ""
For Cnt    = 2 to Len(Area) Step 2
  NewValue = Asc(SubStr(Area,Cnt,1))
  BlinkOn  = NewValue>127
  NewValue = NewValue - iif(NewValue>127,128,0)
  NewValue = Mod(NewValue,16)
  NewValue = NewValue - iif(NewValue>7,8,NewValue)+iif(BlinkOn,128,0)
  Area2    = Area2 + SubStr(Area,Cnt-1,1)+Chr(NewValue)
Next
RestScreen( Top, Left, Bottom, Right, Area2 )
Return (0)

******************************************************************************
Function ScrnCap
Parameters Top, Left, Bottom, Right
Private Area, Area2, Cnt, 
******************************************************************************
* Descrip  : Screen text capture
* Returns  : String of captured text
* This routine captures the text within a specified area
* NOTE : To calculate memory required by ScrnCap use the following method
*  x=(((Bottom-Top)+1)+((Right-Left)+1))*2
*  x=(x+(x/2))   x will hold final total memroy requirements
******************************************************************************

Area       = SaveScreen( Top, Left, Bottom, Right )
Area2      = ""
For Cnt    = 1 to (Len(Area)-1) Step 2
  Area2    = Area2 + SubStr(Area,Cnt,1)
Next
Return (Area2)


******************************************************************************
FUNCTION   Cost2Str
PARAMETERS amount,sublen
PRIVATE    negon, stramnt, str1, amnt2
******************************************************************************
* Descrip : The Number to Word routine
* Returns : Text for numeric passed
* This routine is designed to convert numerics to words for
* Currency printouts.
* The correct method of call is Cost2Str(X,[y]) where..
* X is the number and y is the optional length of the
* substring use on the words MILLION, THOUSAND, and HUNDRED
* This substring will only take affect tif the returning string
* is greater than MAX_LEN (defined in Num2Str, called from Cost2Str)
******************************************************************************

IF TYPE("sublen")#"N"
  sublen=2
ENDIF
negon = (amount<0)
amount = IIF(negon, amount*(-1), amount)  
stramnt = LTRIM( STR(amount,0) )
IF VAL(stramnt)>amount
  stramnt=LTRIM( STR( VAL(stramnt) -1) )
ENDIF
str1 = Num2Str( VAL(stramnt), sublen )
amnt2 = amount - VAL(stramnt)
str1 = IIF(negon, "- " ,"") + str1 + "DOLLARS AND " + ;
   IIF(amnt2>0, LTRIM( STR( (amnt2*100) ,0) ), "NO" ) + " CENTS"

RETURN( str1 )


******************************************************************************
FUNCTION   Num2Str 
PARAMETERS amount,sublen
PRIVATE    max_len, stramnt, str, addon, cnt, newstr, loc, loc1, loc2, loc3
PRIVATE    h, m, t, hd, ml, th
* Descrip : The Whole Number to Word routine
* Returns : Text for Number passed
* This routine is designed to convert numerics to words for
* Currency printouts.
* The correct method of call is AmttoStr(x,[y]) where..
* X is the number and y is the optional length of the
* substring use on the words MILLION, THOUSAND, and HUNDRED
* This substring will only take affect if the returning string
* is greater than MAX_LEN (defined in AMTTOSTR, called from AMNTTOSTR)
* This routine should only be called if you do not want decimals or the
* word DOLLARS returned.
******************************************************************************

max_len = 60
stramnt = LTRIM(STR(amount,0))
str     = ""
addon   = ""
cnt     = LEN(stramnt)

IF stramnt<="0.00"
  RETURN( "NO " )
ENDIF

DO WHILE cnt>0
  IF cnt=9 .OR. cnt=6 .OR. cnt=3
    addon=Digtostr( VAL(SUBSTR(stramnt,LEN(stramnt)-(cnt-1),1)))+" HUNDRED"
  ELSEIF cnt=8 .OR. cnt=5 .OR. cnt=2
    IF VAL( SUBSTR( stramnt, LEN(stramnt) - (cnt-1), 1) )=1 
      addon=Teentostr( VAL( SUBSTR( stramnt, LEN(stramnt) - (cnt-1), 2) ) )
      cnt=cnt-1
    else
      addon=Tentostr( VAL( SUBSTR( stramnt, LEN(stramnt) - (cnt-1), 1) ) )
      IF VAL( SUBSTR( stramnt, LEN(stramnt) - (cnt-2), 1) )>0
        addon=addon+"-"
      ENDIF
    ENDIF
  ELSE
    addon=Digtostr( VAL( SUBSTR(stramnt, LEN(stramnt) - (cnt-1), 1) ) )
  ENDIF
  str=str+addon
  IF cnt=4
    str=str+" THOUSAND"
  ELSEIF cnt=7
    str=str+" MILLION"
  ENDIF
  IF RIGHT(str, 1)#"-"
    str=str+" "
  ENDIF
  cnt=cnt-1
  addon=""
ENDDO
IF LEN(str)>max_len
  newstr=""
  loc=1
  hd=SUBSTR("HUNDRED" , 1, sublen)
  ml=SUBSTR("MILLION" , 1, sublen)
  th=SUBSTR("THOUSAND", 1, sublen)
  DO WHILE loc>0
    loc=0
    loc1 =AT("HUNDRED" ,str)
    loc2 =AT("THOUSAND",str)
    loc3 =AT("MILLION" ,str)
    h=(loc1>0)
    t=(loc2>0)
    m=(loc3>0)
    IF h .OR. t .OR. m
      loc1= IIF(loc1=0,999,loc1)
      loc2= IIF(loc2=0,999,loc2)
      loc3= IIF(loc3=0,999,loc3)
    ENDIF
    loc=MIN(loc1,loc2)
    loc=MIN(loc, loc3)
    h=loc=loc1
    t=loc=loc2
    m=loc=loc3
    IF loc>0
      newstr = newstr + LEFT(str, loc-1) + IIF(h, hd, IIF(m, ml, th) )
      str = RIGHT(str, LEN( str )-IIF(T, loc+7, loc+6) )
    ENDIF
  ENDDO
  str=newstr+str
ENDIF

RETURN( str )


******************************************************************************
FUNCTION   Digtostr
PARAMETERS digit
******************************************************************************
* Descrip  : Converts digit to string for 1 number (1-9)
* Returns  : Text of digit passed
******************************************************************************
DO CASE
  CASE digit = 1
    RETURN( "ONE" )
  CASE digit = 2
    RETURN( "TWO" )
  CASE digit = 3
    RETURN( "THREE" )
  CASE digit = 4
    RETURN( "FOUR" )
  CASE digit = 5
    RETURN( "FIVE" )
  CASE digit = 6
    RETURN( "SIX" )
  CASE digit = 7
    RETURN( "SEVEN" )
  CASE digit = 8
    RETURN( "EIGHT" )
  CASE digit = 9
    RETURN( "NINE" )
  OTHERWISE
    RETURN( "" )
ENDCASE

******************************************************************************
FUNCTION   Teentostr
PARAMETERS number
******************************************************************************
* Descrip  : Converts Teen's to string for 2 numbers (10-19)
* Returns  : Text of Teen's passed
******************************************************************************
DO CASE
  CASE number=10
    RETURN( "TEN" )
  CASE number=11
    RETURN( "ELEVEN" )
  CASE number=12
    RETURN( "TWELVE" )
  CASE number=13
    RETURN( "THIRTEEN" )
  CASE number=14
    RETURN( "FOURTEEN" )
  CASE number=15    
    RETURN( "FIFTEEN" )
  CASE number=16
    RETURN( "SIXTEEN" )
  CASE number=17
    RETURN( "SEVENTEEN")
  CASE number=18
    RETURN( "EIGHTEEN" )
  OTHERWISE
    RETURN( "NINTEEN" )
ENDCASE

******************************************************************************
FUNCTION   Tentostr
PARAMETERS digit
******************************************************************************
* Descrip  : Converts Ten's to string for 1 number (1-9)
* Returns  : Text of Ten's passed
******************************************************************************
DO CASE
  CASE digit = 2
    RETURN( "TWENTY" )
  CASE digit = 3
    RETURN( "THIRTY" )
  CASE digit = 4
    RETURN( "FOURTY" )
  CASE digit = 5
    RETURN( "FIFTY" )
  CASE digit = 6
    RETURN( "SIXTY" )
  CASE digit = 7
    RETURN( "SEVENTY" )
  CASE digit = 8
    RETURN( "EIGHTY" )
  CASE digit = 9
    RETURN( "NINTY" )
  OTHERWISE
    RETURN( "" )
ENDCASE
