PAGE    ,132

INCLUDE EXTENDA.INC


DATASEG

CLpublic <_SetSpool, _Spool>

CLstatic <byte Status <<0>>>          ; 0 = enabled
CLstatic <byte PrintFlags <<01101000B>>>
                    ;       ||| |
                    ;       ||| `------------ 1 = no form feed (empirical)
                    ;       ||`-------------- 1 = delete spool file after printing
                    ;       |`--------------- 1 = enable tab expansion
                    ;       `---------------- 1 = banner page
CLstatic <byte TabSize       <<0>>>         ; 0 - 20
CLstatic <byte TargetPrinter <<0>>>         ; 0 - n
CLstatic <byte Copies        <<1>>>         ; 0 - 255
CLstatic <byte FormType      <<0, ?>>>      ; 0 - 255
CLstatic <byte BannerText <<13 DUP(0), 0>>> ; banner text (null padded)
CLstatic <byte LocalPrinter  <<0>>>         ; 0 = LPT1, 1 = LPT2, 2 = LPT3
CLstatic <int  TimeOut       <<0>>>         ; 1/18ths of a second (0 = infinite)
CLstatic <byte DeviceClose   <<0>>>         ; 0 = auto ENDSPOOL/SPOOL on PRN close



CLfunc log      _SetSpool <int _localprn, int _netprn, int _timeout, char _bannertxt>
CLcode
                push    ES

; check params
                cmp     PCOUNT, 02
                jae     SS_Params
                jmp     SS_Abort        ; too few params

SS_Params:      mov     AX, _localprn
                mov     LocalPrinter, AL
                mov     AX, _netprn
                mov     TargetPrinter, AL

                cmp     PCOUNT, 03
                jae     SS_TimP
                jmp     SS_NovCall      ; no timeout or banner param specified

SS_TimP:        mov     AX, _timeout
                mov     TimeOut, AX

                cmp     PCOUNT, 04
                jae     SS_DefB

; set to 'do not print banner page'
                mov     AL, PrintFlags
                and     AL, 01111111B
                mov     PrintFlags, AL
                jmp     SS_NovCall      ; no banner param specified

; set default of 'print banner page'
SS_DefB:        mov     AL, PrintFlags
                or      AL, 10000000B
                mov     PrintFlags, AL

; test for null banner string
                les     SI, _bannertxt
                cmp     BYTE PTR ES:[SI], 00
                jne     SS_BanFill      ; banner string not null

; set to 'do not print banner page'
                mov     AL, PrintFlags
                and     AL, 01111111B
                mov     PrintFlags, AL
                jmp     SS_NovCall

; fill BannerText buffer with nulls
SS_BanFill:     mov     CX, 14
                mov     BX, 00
SS_ClrLoop:     mov     BYTE PTR DS:[BX + BannerText], 00
                inc     BX
                loop    SS_ClrLoop

; move new _bannertxt to BannerText buffer
                mov     BX, 00
                mov     CX, 13
                les     SI, _bannertxt
SS_StrLoop:     cmp     BYTE PTR ES:[BX + SI], 00
                je      SS_NovCall
                mov     AL, BYTE PTR ES:[BX + SI]
                mov     BYTE PTR DS:[BX + BannerText], AL
                inc     BX
                loop    SS_StrLoop

SS_NovCall:     mov     CX, 24          ; buffer size
                mov     bx, SEG Status
                mov     es, bx
                mov     bx, OFFSET Status
                mov     AL, 01          ; set defaults subfunction
                DOSREQ  0B8H
                jnc     SS_NormalEnd

SS_Abort:       mov     AX, 0
                jmp     SS_End
SS_NormalEnd:   mov     AX, 1

SS_End:         pop     ES
                CLret   AX

               

CLfunc log      _Spool <int _function>
CLcode

S_NovCall:      mov     DL, BYTE PTR _function  ; 00h = start, 01h = end
                                                ; 02h = end and abort
                                                ; 03h = queue and continue
                DOSREQ  0DFH
                cmp     AL, 0
                je      S_NormalEnd

S_Abort:        mov     AX, 0
                jmp     S_End
S_NormalEnd:    mov     AX, 1

S_End:          CLret   AX
               
END
