********************************************************************************
* Program Id: splitit.prg
*     System: JFK.LIB, a.k.a. the Kaster Collection!  <grin>
*     Client: All you smart people out there.
*    Version: 1.20
********************************************************************************
*
*    Purpose: Split a miscellaneous name into its individual parts
*
********************************************************************************

****** Test source code - take out when you understand the weird function
private pre,first,mid,last,suf, fullname
store '' to pre,first,mid,last,suf
clear
@ 2,0 say "Please enter a name for me to attempt to figure out!"
fullname = space( 60 )
do while lastkey() # 27
  @ 4, 0 say "Test name: " get m->fullname
  read
  @ 6, 0 clear
  if splitname( m->fullname, @pre, @first, @mid, @last, @suf )
    @ 6,0 say "Prefix: " + m->pre
    ? " First:",m->first
    ? "Middle:",m->mid
    ? "  Last:",m->last
    ? "Suffix:",m->suf
  else
    @ 6, 0 say "Oh, oh!"
  endif
enddo
return
****** Test source code ends

******************
******************
**
**  Syntax:
**  splitname( <fullname>, @<pre>, @<first>, @<mi>, @<last>, @<suff> )
**
**  Variable  T Len Description
**      
**  fullname  C     the unformatted, combined name of the person
**  pre       C     prefix:  Mr., Mrs., Dr., etc. - reference parameter
**  first     C     first name
**  mi        C     middle name
**  last      C     last name
**  suff      C     suffix:  Jr., Sr., III, M.D., etc.
**
**  Returns:  .T. if it thinks it was successful, .F. otherwise
**
**    Notes:  the last 5 parameters must all be passed as reference in order
**            for them to be assigned correctly.  This means that you must
**            have them declared and assigned some value before calling
**            splitname().  You can just do a store "" to v1,v2,v3,v4,v5
**            as a one-liner.
**
**  Example:  
**  
**  private pre,first,mid,last,suf
**  store '' to pre,first,mid,last,suf
**
**  select 0
**  use maillist && Existing file with full name in one field (FULLNAME)
**  select 0
**  use fixnames && File you are using to convert FULLNAME
**
**  do while maillist->( ! eof() )
**    if splitname( maillist->fullname, @pre, @first, @mid, @last, @suf )
**      append blank
**      replace ;
**        fixnames->prefix with m->pre, ;
**        fixnames->first  with m->first, ;
**        fixnames->middle with m->mid, ;
**        fixnames->last   with m->last, ;
**        fixnames->suffix with m->suf
**      unlock
**    endif
**    skip alias maillist
**  enddo
**
**
**   Source:  splitit.prg
**
******************
******************
function splitname
parameter fullname, pre, first, mi, last, suff
private prefixes,suffixes,i,k

fullname = strtran( ltrim( trim( m->fullname ) ), ",", " " )
fullname = capfirst( strtran( m->fullname, "  ", ' ' ) )

store '' to pre,first,mi,last,suff
if len( m->fullname ) < 2 .or. at( ' ', m->fullname ) == 0
  last = m->fullname
  return .f.
endif

prefixes = 'MR.,MRS.,MS.,MZ.,MISS,DR.,HON.,JUDGE,MINISTER,'+;
           'MR. AND MRS.,COL.,LT. COL.,GEN.,LT. GEN.,PROFESSOR,PROF.,'+;
           'AMBASSADOR,CPTN.,LORD,THE HONORABLE AND MRS.,'+;
           'DR. AND MRS.,CAPTAIN AND MRS.,GENERAL'

suffixes = 'ESQ.,SR.,JR.,IIIV,M.D.,PH.D.,MD,PHD'
surnames = 'VANDER,VONDER,MAC,MC,ST.,SAINT,DE,DA,DI'
lowers   = 'de ,da ,di '

* Stripping out suffix if it's there

k = len( m->fullname )
do while m->k > 1 .and. ! substr( m->fullname, m->k, 1 ) $ ' ,'
  k = m->k - 1
enddo

if m->k > 1
  tmp = substr( m->fullname, m->k + 1 )
  if upper( m->tmp ) $ m->suffixes
    if '.' $ m->tmp
      suff = capfirst( m->tmp )
    else
      suff = upper( m->tmp )
    endif

    fullname = substr( m->fullname, 1, m->k - 1 )
  endif
endif

* Checking for prefix if it's there
tmpfull = fullname
tmp = nextword( @tmpfull )

* Checking for "THE"s
if upper( m->tmp ) == 'THE'
  tmp      = tmp + ' ' + nextword( @tmpfull )
endif

* Checking for 'AND's
if 'AND ' == upper( substr( m->tmpfull, 1, 4 ) )
  k = at( ' ', m->tmpfull )
  k = m->k + 1
  do while substr( m->tmpfull, m->k, 1 ) # ' ' .and. m->k < len( m->tmpfull )
    k = m->k + 1
  enddo

  if k = len( m->tmpfull )
    tmp = m->tmp + ' ' + m->tmpfull
    tmpfull = ''
    pre = tmp
    return .f.
  endif

  tmp      = m->tmp + ' ' + substr( m->tmpfull, 1, m->k - 1)
  tmpfull  = substr( m->tmpfull, m->k + 1 )
endif

if upper( m->tmp ) $ m->prefixes
  pre = m->tmp
  fullname = m->tmpfull
endif

* Checking for a middle initial to use as an anchor

k = at('.', m->fullname )
if m->k > 0 .and. m->k > at( ' ', m->fullname )
  i = m->k
  do while substr( m->fullname, m->i, 1 ) # ' '
    i = m->i - 1
  enddo
  mi = substr( m->fullname, m->i + 1, m->k - m->i )
  fullname = substr( m->fullname, 1, m->i ) + ltrim( substr( m->fullname, m->k + 1 ) )
endif

* getting last name
do while ' ' $ m->fullname
  tmp = lastword( @fullname )
  if empty( m->last )
    last = m->tmp
  else
    last = m->tmp + ' ' + m->last
  endif
  if upper( m->tmp ) $ m->surnames .or. ' ' $ m->last
    if ! upper( m->tmp ) $ m->surnames
      fullname = m->fullname + ' ' + m->tmp
      last     = substr( m->last, at( ' ', m->last ) + 1 )
    endif
    exit
  endif
enddo

first = m->fullname
fullname = ''

if upper( m->mi ) == 'ST.'
  last = m->mi + ' ' + m->last
  mi   = ''
elseif empty( m->mi ) .and. ' ' $ m->last
  mi = nextword( @last )
  if upper( m->mi ) $ m->surnames
    if lower( m->mi ) $ m->lowers
      mi = lower( m->mi )
    endif
    last = m->mi + ' ' + m->last
    mi   = ''
  endif
endif

if empty( m->mi ) .and. ' ' $ m->first
  mi = lastword( @first )
endif

if lower( substr( m->last, 1, 3 ) ) $ m->lowers
  last = lower( substr( m->last, 1, 3 ) ) + substr( m->last, 4 )
endif

return ( ! ' ' $ m->last ) .or. empty( m->first ) .or. empty( m->last )

*****************
*
* Syntax:  nextword( @<text> )
*
* Notes.:  returns the next word in <text>, and <text> with that word removed
*          if '@' is used.
*
*****************
function nextword
para txt
private sp,cp,rettxt

txt = ltrim( trim( m->txt ) )
cp = at( ',', m->txt )
sp = at( ' ', m->txt )
if cp == 0
  cp = len( m->txt )
endif
if m->sp == 0
  sp = len( m->txt )
endif
sp = min( m->sp, m->cp )

if sp < len( m->txt )
  rettxt = substr( m->txt, 1, m->sp - 1 )
  txt = substr( m->txt, m->sp + 1 )
else
  rettxt = m->txt
  txt = ''
endif
return m->rettxt

*****************
*
* Syntax:  lastword( @<text> )
*
* Notes.:  returns the last word in <text>, and <text> with that word removed
*          if '@' is used.
*
*****************
function lastword
para txt
private sp,cp,rettxt

txt = ltrim( trim( m->txt ) )
if substr( m->txt, len( m->txt) ) = ','
  txt = substr( m->txt, 1, len( m->txt ) - 1 )
endif
cp = rat( ',', m->txt )
sp = rat( ' ', m->txt )
if cp == 0
  cp = len( m->txt )
endif

if m->sp == 0
  sp = len( m->txt )
endif

sp = min( m->sp, m->cp )

if sp < len( m->txt )
  rettxt = substr( m->txt, m->sp + 1 )
  txt    = substr( m->txt, 1, m->sp - 1 )
else
  rettxt = m->txt
  txt    = ''
endif
return m->rettxt

*****************
*
* Syntax:  capfirst( <text> )
*
* Notes.:  returns <text> with (hopefully) proper casing.  Sensitive to
*          "-'(),. ".  Used mainly for Titles, etc.
*
*****************
function capfirst
parameter txt
private i,l,ch,retval

l = len( trim( m->txt ) )
retval = upper( substr( m->txt, 1, 1 ) )
for i = 2 to m->l
  ch = substr( m->txt, m->i - 1, 1 )
  if ( m->ch $ " '-.(/,)" )
    retval = m->retval + upper( substr( m->txt, m->i, 1 ) )
  else
    retval = m->retval + lower( substr( m->txt, m->i, 1 ) )
  endif
next i
return m->retval

