#include "inkey.ch"
#include "getexit.ch"          

#define K_SPACEBAR 32

static arr := {}    // this array will hold all the get choices

function spacebar(oGet)                        
   LOCAL gvar := ASCAN(arr,{ |var| upper(var[1]) == upper(oGet:name)})
   LOCAL x := 2, key := 0,alen := LEN(arr[gvar]),tx := 0,diff,hotkey

   oGet:setfocus()  // give the get input focus

   DO WHILE key != K_ESC .and. key != K_ENTER                  
      diff := len(oGet:buffer) - len(arr[gvar][x]) // find the # of spaces to pad the value
      oGet:varput(arr[gvar][x]+space(diff) )  // stuff the get variable with the array element
      oGet:updatebuffer()  // display the current get buffer

      key = INKEY(0) // wait for a key to be pressed

      // see if a hot key was pressed

      IF ( hotkey := SETKEY(Key) ) != NIL 
         EVAL(hotkey, PROCNAME(1), PROCLINE(1),READVAR())
         LOOP
      ENDIF

      // determine what key was pressed

      DO CASE
         CASE key = K_ESC
            oGet:undo()
            oGet:exitstate := GE_ESCAPE
         CASE key  = K_SPACEBAR
            x = IF(x +1>alen,2,x+1) //move to the next item
         CASE key = K_ENTER
            oGet:exitstate := GE_ENTER
         CASE key = K_UP       // up arrow
            oGet:exitstate := GE_UP
            exit                     
         CASE key = K_PGUP     // page up
            oGET:exitstate := GE_WRITE
            exit
         CASE key = K_PGDN     // page down
            oGet:exitstate := GE_WRITE
            exit
         CASE key = K_DOWN    // down arrow
            oGET:exitstate := GE_DOWN
            exit
        OTHERWISE // did user press a key to select the first letter
            tx := ascan(arr[gvar],{ |ae| upper( left(ae,1) ) == upper ( chr(key) ) },2 )
            x := if(tx >0,tx,x)
      ENDCASE 

   ENDDO           

   oGet:Killfocus()    // take away the gets input focus

return nil

// this function will add each choice to the arr array
// you will notice the choices are parsed then made into
// a multi-dimmensional array.

function spaceadd(getvar,value)
return aadd(arr,stringparse(getvar+','+value) )

// this function will parse the items and return them as an array

static function stringparse(value)
    local parsearray := {},string,pos

    while .not. empty(value)    
       pos = at(",",value)

       if pos = 0
           string = value
           value = ''
       else
          string = substr(value,1,pos-1)
          value = substr(value,pos+1)
      endif

      aadd(parsearray,string)
    enddo 

return (parsearray)    

// clear the item array

function spacedel()
    arr := {}
return nil

