*:*********************************************************************
*:
*:        Program: SORTCLIP.PRG
*:
*:         System: Bubble Sort Demo on memvar arrays for Clipper S87
*:         Author: Milton F. Shaw Jr.
*:      Copyright (c) 1989, Auto Exec Inc.
*:  Last modified: 04/29/89     21:18
*:
*:  Procs & Fncts: SORTDISP
*:               : GETWORDS
*:               : SHOWDATA
*:               : SORT
*:               : TIMECALC
*:
*:          Calls: SORTDISP         (procedure in SORTCLIP.PRG)
*:               : GETWORDS         (procedure in SORTCLIP.PRG)
*:               : SHOWDATA         (procedure in SORTCLIP.PRG)
*:               : SORT             (procedure in SORTCLIP.PRG)
*:               : TIMECALC         (procedure in SORTCLIP.PRG)
*:
*:     Documented: 04/29/89 at 21:22               FoxDoc version 1.0
*:*********************************************************************

SET COLOR TO W+/B,R/W,B
CLOSE ALL
CLEAR MEMORY
RELEASE ALL
DECLARE sortlist[100]
PUBLIC RAND, stime,etime, tottime
SET PROCEDURE TO sortclip
DO sortdisp
DO getwords
DO showdata                      && display the unsorted data
SET COLOR TO RG+*/R
@23,28 SAY "Press Any Key to Sort"
WAIT ""
SET COLOR TO G+*/R
@23,28 SAY "       Sorting       "
stime=TIME()
DO SORT     
etime=TIME()
DO timecalc
DO showdata                      && display the sorted data
SET COLOR TO BG+/R
@23,60 SAY "Sort Time: "
SET COLOR TO W+/R
@23,72 SAY tottime
SET COLOR TO RG+*/R
@23,28 SAY "Press Any Key to Quit"
WAIT ""
CLOSE ALL
RETURN

*!*********************************************************************
*!
*!      Procedure: GETWORDS
*!
*!      Called by: SORTCLIP.PRG   
*!
*!           Uses: WORDS.DBF      
*!
*!*********************************************************************
PROCEDURE getwords
USE words
DO WHILE .NOT. EOF() .AND. RECNO()<=100
   STORE TRIM(word) TO sortlist[recno()]
   SKIP
ENDDO
RETURN

*!*********************************************************************
*!
*!      Procedure: SORT
*!
*!      Called by: SORTCLIP.PRG   
*!
*!*********************************************************************
PROCEDURE SORT
again="Y"
DO WHILE again="Y"
   dif="N"
   start=2
   DO WHILE start<=100
      IF sortlist[start]<sortlist[start-1]
         STORE sortlist[start-1] TO temp
         STORE sortlist[start] TO sortlist[start-1]
         STORE temp TO sortlist[start]
         dif="Y"
      ENDIF
      start=start+1
   ENDDO
   IF dif="N"
      again="N"
   ENDIF
ENDDO
RETURN

*!*********************************************************************
*!
*!      Procedure: SHOWDATA
*!
*!      Called by: SORTCLIP.PRG   
*!
*!*********************************************************************
PROCEDURE showdata
SET COLOR TO W+/B
ROW=6
COL=2
@6,1 clear to 20,78
BEGIN=1
DO WHILE BEGIN<=100
   @ROW,COL SAY sortlist[begin]
   COL=COL+11
   IF COL>70
      ROW=ROW+1
      COL=2
   ENDIF
   BEGIN=BEGIN+1
ENDDO
stime=TIME()
RETURN

*!*********************************************************************
*!
*!      Procedure: TIMECALC
*!
*!      Called by: SORTCLIP.PRG   
*!
*!*********************************************************************
PROCEDURE timecalc
ssec=(((VAL(LEFT(stime,2))*60)+VAL(SUBSTR(stime,4,2)))*60)+;
   VAL(SUBSTR(stime,7,2))
esec=(((VAL(LEFT(etime,2))*60)+VAL(SUBSTR(etime,4,2)))*60)+;
   VAL(SUBSTR(etime,7,2))
tsec=esec-ssec
MIN=STR((tsec-MOD(tsec,60))/60,2)
esec=MOD(tsec,60)
IF esec<10
   sec="0"+STR(esec,1)
ELSE
   sec=STR(esec,2)
ENDIF
tottime=MIN+":"+sec
RETURN

*!*********************************************************************
*!
*!      Procedure: SORTDISP
*!
*!      Called by: SORTCLIP.PRG   
*!
*!*********************************************************************
PROCEDURE sortdisp

SET COLOR TO +W/B
CLEAR
SET COLOR TO +GR/R
@ 01,00 CLEAR TO 04,19
@ 01,00 TO 04,19
@ 02,03 SAY "Auto Exec BBS"
@ 03,02 SAY "(508)  833-0508"
SET COLOR TO +W/G
@ 01,20 CLEAR TO 04,63
@ 01,20 TO 04,63
@ 02,23 SAY "FoxBase, dBASE, Clipper Sort Demo Prg"
@ 03,28 SAY "Sort 100 Character Strings"
SET COLOR TO +GR/R
@ 01,64 CLEAR TO 04,79
@ 01,64 TO 04,79
@ 02,69 SAY "8-N-1"
@ 03,65 SAY "1200/2400/9600"
SET COLOR TO +BG/B
@ 05,00 TO 21,79
SET COLOR TO +W/B
@ 06,01 CLEAR TO 20,78
SET COLOR TO +GR/R
@ 22,00 CLEAR TO 24,79
@ 22,00 TO 24,79
SET COLOR TO W+/B,R/W,B
RETURN



*: EOF: SORTCLIP.PRG
